/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.vma;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VmaAllocationInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MEMORYTYPE;
    public static final int DEVICEMEMORY;
    public static final int OFFSET;
    public static final int SIZE;
    public static final int PMAPPEDDATA;
    public static final int PUSERDATA;

    VmaAllocationInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VmaAllocationInfo(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VmaAllocationInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint32_t")
    public int memoryType() {
        return VmaAllocationInfo.nmemoryType(this.address());
    }

    @NativeType(value="VkDeviceMemory")
    public long deviceMemory() {
        return VmaAllocationInfo.ndeviceMemory(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long offset() {
        return VmaAllocationInfo.noffset(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long size() {
        return VmaAllocationInfo.nsize(this.address());
    }

    @NativeType(value="void *")
    public long pMappedData() {
        return VmaAllocationInfo.npMappedData(this.address());
    }

    @NativeType(value="void *")
    public long pUserData() {
        return VmaAllocationInfo.npUserData(this.address());
    }

    public static VmaAllocationInfo malloc() {
        return VmaAllocationInfo.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VmaAllocationInfo calloc() {
        return VmaAllocationInfo.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VmaAllocationInfo create() {
        return new VmaAllocationInfo(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VmaAllocationInfo create(long address) {
        return new VmaAllocationInfo(address, null);
    }

    @Nullable
    public static VmaAllocationInfo createSafe(long address) {
        return address == 0L ? null : VmaAllocationInfo.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VmaAllocationInfo.create(VmaAllocationInfo.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VmaAllocationInfo.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VmaAllocationInfo.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VmaAllocationInfo.create(address, capacity);
    }

    public static VmaAllocationInfo mallocStack() {
        return VmaAllocationInfo.mallocStack(MemoryStack.stackGet());
    }

    public static VmaAllocationInfo callocStack() {
        return VmaAllocationInfo.callocStack(MemoryStack.stackGet());
    }

    public static VmaAllocationInfo mallocStack(MemoryStack stack) {
        return VmaAllocationInfo.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VmaAllocationInfo callocStack(MemoryStack stack) {
        return VmaAllocationInfo.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VmaAllocationInfo.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VmaAllocationInfo.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VmaAllocationInfo.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VmaAllocationInfo.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nmemoryType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MEMORYTYPE);
    }

    public static long ndeviceMemory(long struct) {
        return MemoryUtil.memGetLong(struct + (long)DEVICEMEMORY);
    }

    public static long noffset(long struct) {
        return MemoryUtil.memGetLong(struct + (long)OFFSET);
    }

    public static long nsize(long struct) {
        return MemoryUtil.memGetLong(struct + (long)SIZE);
    }

    public static long npMappedData(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PMAPPEDDATA);
    }

    public static long npUserData(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PUSERDATA);
    }

    static {
        Struct.Layout layout = VmaAllocationInfo.__struct(VmaAllocationInfo.__member(4), VmaAllocationInfo.__member(8), VmaAllocationInfo.__member(8), VmaAllocationInfo.__member(8), VmaAllocationInfo.__member(POINTER_SIZE), VmaAllocationInfo.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MEMORYTYPE = layout.offsetof(0);
        DEVICEMEMORY = layout.offsetof(1);
        OFFSET = layout.offsetof(2);
        SIZE = layout.offsetof(3);
        PMAPPEDDATA = layout.offsetof(4);
        PUSERDATA = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<VmaAllocationInfo, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VmaAllocationInfo newInstance(long address) {
            return new VmaAllocationInfo(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="uint32_t")
        public int memoryType() {
            return VmaAllocationInfo.nmemoryType(this.address());
        }

        @NativeType(value="VkDeviceMemory")
        public long deviceMemory() {
            return VmaAllocationInfo.ndeviceMemory(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long offset() {
            return VmaAllocationInfo.noffset(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long size() {
            return VmaAllocationInfo.nsize(this.address());
        }

        @NativeType(value="void *")
        public long pMappedData() {
            return VmaAllocationInfo.npMappedData(this.address());
        }

        @NativeType(value="void *")
        public long pUserData() {
            return VmaAllocationInfo.npUserData(this.address());
        }
    }
}

