/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.vma;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VmaAllocationCreateInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int FLAGS;
    public static final int USAGE;
    public static final int REQUIREDFLAGS;
    public static final int PREFERREDFLAGS;
    public static final int MEMORYTYPEBITS;
    public static final int POOL;
    public static final int PUSERDATA;

    VmaAllocationCreateInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VmaAllocationCreateInfo(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VmaAllocationCreateInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VmaAllocationCreateFlags")
    public int flags() {
        return VmaAllocationCreateInfo.nflags(this.address());
    }

    @NativeType(value="VmaMemoryUsage")
    public int usage() {
        return VmaAllocationCreateInfo.nusage(this.address());
    }

    @NativeType(value="VkMemoryPropertyFlags")
    public int requiredFlags() {
        return VmaAllocationCreateInfo.nrequiredFlags(this.address());
    }

    @NativeType(value="VkMemoryPropertyFlags")
    public int preferredFlags() {
        return VmaAllocationCreateInfo.npreferredFlags(this.address());
    }

    @NativeType(value="uint32_t")
    public int memoryTypeBits() {
        return VmaAllocationCreateInfo.nmemoryTypeBits(this.address());
    }

    @NativeType(value="VmaPool")
    public long pool() {
        return VmaAllocationCreateInfo.npool(this.address());
    }

    @NativeType(value="void *")
    public long pUserData() {
        return VmaAllocationCreateInfo.npUserData(this.address());
    }

    public VmaAllocationCreateInfo flags(@NativeType(value="VmaAllocationCreateFlags") int value) {
        VmaAllocationCreateInfo.nflags(this.address(), value);
        return this;
    }

    public VmaAllocationCreateInfo usage(@NativeType(value="VmaMemoryUsage") int value) {
        VmaAllocationCreateInfo.nusage(this.address(), value);
        return this;
    }

    public VmaAllocationCreateInfo requiredFlags(@NativeType(value="VkMemoryPropertyFlags") int value) {
        VmaAllocationCreateInfo.nrequiredFlags(this.address(), value);
        return this;
    }

    public VmaAllocationCreateInfo preferredFlags(@NativeType(value="VkMemoryPropertyFlags") int value) {
        VmaAllocationCreateInfo.npreferredFlags(this.address(), value);
        return this;
    }

    public VmaAllocationCreateInfo memoryTypeBits(@NativeType(value="uint32_t") int value) {
        VmaAllocationCreateInfo.nmemoryTypeBits(this.address(), value);
        return this;
    }

    public VmaAllocationCreateInfo pool(@NativeType(value="VmaPool") long value) {
        VmaAllocationCreateInfo.npool(this.address(), value);
        return this;
    }

    public VmaAllocationCreateInfo pUserData(@NativeType(value="void *") long value) {
        VmaAllocationCreateInfo.npUserData(this.address(), value);
        return this;
    }

    public VmaAllocationCreateInfo set(int flags, int usage, int requiredFlags, int preferredFlags, int memoryTypeBits, long pool, long pUserData) {
        this.flags(flags);
        this.usage(usage);
        this.requiredFlags(requiredFlags);
        this.preferredFlags(preferredFlags);
        this.memoryTypeBits(memoryTypeBits);
        this.pool(pool);
        this.pUserData(pUserData);
        return this;
    }

    public VmaAllocationCreateInfo set(VmaAllocationCreateInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VmaAllocationCreateInfo malloc() {
        return VmaAllocationCreateInfo.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VmaAllocationCreateInfo calloc() {
        return VmaAllocationCreateInfo.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VmaAllocationCreateInfo create() {
        return new VmaAllocationCreateInfo(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VmaAllocationCreateInfo create(long address) {
        return new VmaAllocationCreateInfo(address, null);
    }

    @Nullable
    public static VmaAllocationCreateInfo createSafe(long address) {
        return address == 0L ? null : VmaAllocationCreateInfo.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VmaAllocationCreateInfo.create(VmaAllocationCreateInfo.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VmaAllocationCreateInfo.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VmaAllocationCreateInfo.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VmaAllocationCreateInfo.create(address, capacity);
    }

    public static VmaAllocationCreateInfo mallocStack() {
        return VmaAllocationCreateInfo.mallocStack(MemoryStack.stackGet());
    }

    public static VmaAllocationCreateInfo callocStack() {
        return VmaAllocationCreateInfo.callocStack(MemoryStack.stackGet());
    }

    public static VmaAllocationCreateInfo mallocStack(MemoryStack stack) {
        return VmaAllocationCreateInfo.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VmaAllocationCreateInfo callocStack(MemoryStack stack) {
        return VmaAllocationCreateInfo.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VmaAllocationCreateInfo.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VmaAllocationCreateInfo.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VmaAllocationCreateInfo.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VmaAllocationCreateInfo.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nflags(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FLAGS);
    }

    public static int nusage(long struct) {
        return MemoryUtil.memGetInt(struct + (long)USAGE);
    }

    public static int nrequiredFlags(long struct) {
        return MemoryUtil.memGetInt(struct + (long)REQUIREDFLAGS);
    }

    public static int npreferredFlags(long struct) {
        return MemoryUtil.memGetInt(struct + (long)PREFERREDFLAGS);
    }

    public static int nmemoryTypeBits(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MEMORYTYPEBITS);
    }

    public static long npool(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)POOL);
    }

    public static long npUserData(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PUSERDATA);
    }

    public static void nflags(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FLAGS, value);
    }

    public static void nusage(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)USAGE, value);
    }

    public static void nrequiredFlags(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)REQUIREDFLAGS, value);
    }

    public static void npreferredFlags(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)PREFERREDFLAGS, value);
    }

    public static void nmemoryTypeBits(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)MEMORYTYPEBITS, value);
    }

    public static void npool(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)POOL, Checks.check(value));
    }

    public static void npUserData(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PUSERDATA, Checks.check(value));
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)POOL));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)PUSERDATA));
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            VmaAllocationCreateInfo.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = VmaAllocationCreateInfo.__struct(VmaAllocationCreateInfo.__member(4), VmaAllocationCreateInfo.__member(4), VmaAllocationCreateInfo.__member(4), VmaAllocationCreateInfo.__member(4), VmaAllocationCreateInfo.__member(4), VmaAllocationCreateInfo.__member(POINTER_SIZE), VmaAllocationCreateInfo.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        FLAGS = layout.offsetof(0);
        USAGE = layout.offsetof(1);
        REQUIREDFLAGS = layout.offsetof(2);
        PREFERREDFLAGS = layout.offsetof(3);
        MEMORYTYPEBITS = layout.offsetof(4);
        POOL = layout.offsetof(5);
        PUSERDATA = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<VmaAllocationCreateInfo, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VmaAllocationCreateInfo newInstance(long address) {
            return new VmaAllocationCreateInfo(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="VmaAllocationCreateFlags")
        public int flags() {
            return VmaAllocationCreateInfo.nflags(this.address());
        }

        @NativeType(value="VmaMemoryUsage")
        public int usage() {
            return VmaAllocationCreateInfo.nusage(this.address());
        }

        @NativeType(value="VkMemoryPropertyFlags")
        public int requiredFlags() {
            return VmaAllocationCreateInfo.nrequiredFlags(this.address());
        }

        @NativeType(value="VkMemoryPropertyFlags")
        public int preferredFlags() {
            return VmaAllocationCreateInfo.npreferredFlags(this.address());
        }

        @NativeType(value="uint32_t")
        public int memoryTypeBits() {
            return VmaAllocationCreateInfo.nmemoryTypeBits(this.address());
        }

        @NativeType(value="VmaPool")
        public long pool() {
            return VmaAllocationCreateInfo.npool(this.address());
        }

        @NativeType(value="void *")
        public long pUserData() {
            return VmaAllocationCreateInfo.npUserData(this.address());
        }

        public Buffer flags(@NativeType(value="VmaAllocationCreateFlags") int value) {
            VmaAllocationCreateInfo.nflags(this.address(), value);
            return this;
        }

        public Buffer usage(@NativeType(value="VmaMemoryUsage") int value) {
            VmaAllocationCreateInfo.nusage(this.address(), value);
            return this;
        }

        public Buffer requiredFlags(@NativeType(value="VkMemoryPropertyFlags") int value) {
            VmaAllocationCreateInfo.nrequiredFlags(this.address(), value);
            return this;
        }

        public Buffer preferredFlags(@NativeType(value="VkMemoryPropertyFlags") int value) {
            VmaAllocationCreateInfo.npreferredFlags(this.address(), value);
            return this;
        }

        public Buffer memoryTypeBits(@NativeType(value="uint32_t") int value) {
            VmaAllocationCreateInfo.nmemoryTypeBits(this.address(), value);
            return this;
        }

        public Buffer pool(@NativeType(value="VmaPool") long value) {
            VmaAllocationCreateInfo.npool(this.address(), value);
            return this;
        }

        public Buffer pUserData(@NativeType(value="void *") long value) {
            VmaAllocationCreateInfo.npUserData(this.address(), value);
            return this;
        }
    }
}

