/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.remotery;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.util.remotery.RMTFree;
import org.lwjgl.util.remotery.RMTFreeI;
import org.lwjgl.util.remotery.RMTInputHandler;
import org.lwjgl.util.remotery.RMTInputHandlerI;
import org.lwjgl.util.remotery.RMTMalloc;
import org.lwjgl.util.remotery.RMTMallocI;
import org.lwjgl.util.remotery.RMTRealloc;
import org.lwjgl.util.remotery.RMTReallocI;

@NativeType(value="struct rmtSettings")
public class RMTSettings
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int PORT;
    public static final int REUSE_OPEN_PORT;
    public static final int LIMIT_CONNECTIONS_TO_LOCALHOST;
    public static final int MSSLEEPBETWEENSERVERUPDATES;
    public static final int MESSAGEQUEUESIZEINBYTES;
    public static final int MAXNBMESSAGESPERUPDATE;
    public static final int _MALLOC;
    public static final int REALLOC;
    public static final int _FREE;
    public static final int MM_CONTEXT;
    public static final int INPUT_HANDLER;
    public static final int INPUT_HANDLER_CONTEXT;
    public static final int LOGFILENAME;

    RMTSettings(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public RMTSettings(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), RMTSettings.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="rmtU16")
    public short port() {
        return RMTSettings.nport(this.address());
    }

    @NativeType(value="rmtBool")
    public int reuse_open_port() {
        return RMTSettings.nreuse_open_port(this.address());
    }

    @NativeType(value="rmtBool")
    public int limit_connections_to_localhost() {
        return RMTSettings.nlimit_connections_to_localhost(this.address());
    }

    @NativeType(value="rmtU32")
    public int msSleepBetweenServerUpdates() {
        return RMTSettings.nmsSleepBetweenServerUpdates(this.address());
    }

    @NativeType(value="rmtU32")
    public int messageQueueSizeInBytes() {
        return RMTSettings.nmessageQueueSizeInBytes(this.address());
    }

    @NativeType(value="rmtU32")
    public int maxNbMessagesPerUpdate() {
        return RMTSettings.nmaxNbMessagesPerUpdate(this.address());
    }

    @NativeType(value="rmtMallocPtr")
    public RMTMalloc _malloc() {
        return RMTSettings.n_malloc(this.address());
    }

    @NativeType(value="rmtReallocPtr")
    public RMTRealloc realloc() {
        return RMTSettings.nrealloc(this.address());
    }

    @NativeType(value="rmtFreePtr")
    public RMTFree _free() {
        return RMTSettings.n_free(this.address());
    }

    @NativeType(value="void *")
    public long mm_context() {
        return RMTSettings.nmm_context(this.address());
    }

    @NativeType(value="rmtInputHandlerPtr")
    public RMTInputHandler input_handler() {
        return RMTSettings.ninput_handler(this.address());
    }

    @NativeType(value="void *")
    public long input_handler_context() {
        return RMTSettings.ninput_handler_context(this.address());
    }

    @NativeType(value="rmtPStr")
    public ByteBuffer logFilename() {
        return RMTSettings.nlogFilename(this.address());
    }

    @NativeType(value="rmtPStr")
    public String logFilenameString() {
        return RMTSettings.nlogFilenameString(this.address());
    }

    public RMTSettings port(@NativeType(value="rmtU16") short value) {
        RMTSettings.nport(this.address(), value);
        return this;
    }

    public RMTSettings reuse_open_port(@NativeType(value="rmtBool") int value) {
        RMTSettings.nreuse_open_port(this.address(), value);
        return this;
    }

    public RMTSettings limit_connections_to_localhost(@NativeType(value="rmtBool") int value) {
        RMTSettings.nlimit_connections_to_localhost(this.address(), value);
        return this;
    }

    public RMTSettings msSleepBetweenServerUpdates(@NativeType(value="rmtU32") int value) {
        RMTSettings.nmsSleepBetweenServerUpdates(this.address(), value);
        return this;
    }

    public RMTSettings messageQueueSizeInBytes(@NativeType(value="rmtU32") int value) {
        RMTSettings.nmessageQueueSizeInBytes(this.address(), value);
        return this;
    }

    public RMTSettings maxNbMessagesPerUpdate(@NativeType(value="rmtU32") int value) {
        RMTSettings.nmaxNbMessagesPerUpdate(this.address(), value);
        return this;
    }

    public RMTSettings _malloc(@NativeType(value="rmtMallocPtr") RMTMallocI value) {
        RMTSettings.n_malloc(this.address(), value);
        return this;
    }

    public RMTSettings realloc(@NativeType(value="rmtReallocPtr") RMTReallocI value) {
        RMTSettings.nrealloc(this.address(), value);
        return this;
    }

    public RMTSettings _free(@NativeType(value="rmtFreePtr") RMTFreeI value) {
        RMTSettings.n_free(this.address(), value);
        return this;
    }

    public RMTSettings mm_context(@NativeType(value="void *") long value) {
        RMTSettings.nmm_context(this.address(), value);
        return this;
    }

    public RMTSettings input_handler(@NativeType(value="rmtInputHandlerPtr") RMTInputHandlerI value) {
        RMTSettings.ninput_handler(this.address(), value);
        return this;
    }

    public RMTSettings input_handler_context(@NativeType(value="void *") long value) {
        RMTSettings.ninput_handler_context(this.address(), value);
        return this;
    }

    public RMTSettings logFilename(@NativeType(value="rmtPStr") ByteBuffer value) {
        RMTSettings.nlogFilename(this.address(), value);
        return this;
    }

    public RMTSettings set(short port, int reuse_open_port, int limit_connections_to_localhost, int msSleepBetweenServerUpdates, int messageQueueSizeInBytes, int maxNbMessagesPerUpdate, RMTMallocI _malloc, RMTReallocI realloc, RMTFreeI _free, long mm_context, RMTInputHandlerI input_handler, long input_handler_context, ByteBuffer logFilename) {
        this.port(port);
        this.reuse_open_port(reuse_open_port);
        this.limit_connections_to_localhost(limit_connections_to_localhost);
        this.msSleepBetweenServerUpdates(msSleepBetweenServerUpdates);
        this.messageQueueSizeInBytes(messageQueueSizeInBytes);
        this.maxNbMessagesPerUpdate(maxNbMessagesPerUpdate);
        this._malloc(_malloc);
        this.realloc(realloc);
        this._free(_free);
        this.mm_context(mm_context);
        this.input_handler(input_handler);
        this.input_handler_context(input_handler_context);
        this.logFilename(logFilename);
        return this;
    }

    public RMTSettings set(RMTSettings src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static RMTSettings malloc() {
        return RMTSettings.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static RMTSettings calloc() {
        return RMTSettings.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static RMTSettings create() {
        return new RMTSettings(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static RMTSettings create(long address) {
        return new RMTSettings(address, null);
    }

    @Nullable
    public static RMTSettings createSafe(long address) {
        return address == 0L ? null : RMTSettings.create(address);
    }

    public static RMTSettings mallocStack() {
        return RMTSettings.mallocStack(MemoryStack.stackGet());
    }

    public static RMTSettings callocStack() {
        return RMTSettings.callocStack(MemoryStack.stackGet());
    }

    public static RMTSettings mallocStack(MemoryStack stack) {
        return RMTSettings.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static RMTSettings callocStack(MemoryStack stack) {
        return RMTSettings.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static short nport(long struct) {
        return MemoryUtil.memGetShort(struct + (long)PORT);
    }

    public static int nreuse_open_port(long struct) {
        return MemoryUtil.memGetInt(struct + (long)REUSE_OPEN_PORT);
    }

    public static int nlimit_connections_to_localhost(long struct) {
        return MemoryUtil.memGetInt(struct + (long)LIMIT_CONNECTIONS_TO_LOCALHOST);
    }

    public static int nmsSleepBetweenServerUpdates(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MSSLEEPBETWEENSERVERUPDATES);
    }

    public static int nmessageQueueSizeInBytes(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MESSAGEQUEUESIZEINBYTES);
    }

    public static int nmaxNbMessagesPerUpdate(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MAXNBMESSAGESPERUPDATE);
    }

    public static RMTMalloc n_malloc(long struct) {
        return RMTMalloc.create(MemoryUtil.memGetAddress(struct + (long)_MALLOC));
    }

    public static RMTRealloc nrealloc(long struct) {
        return RMTRealloc.create(MemoryUtil.memGetAddress(struct + (long)REALLOC));
    }

    public static RMTFree n_free(long struct) {
        return RMTFree.create(MemoryUtil.memGetAddress(struct + (long)_FREE));
    }

    public static long nmm_context(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)MM_CONTEXT);
    }

    public static RMTInputHandler ninput_handler(long struct) {
        return RMTInputHandler.create(MemoryUtil.memGetAddress(struct + (long)INPUT_HANDLER));
    }

    public static long ninput_handler_context(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)INPUT_HANDLER_CONTEXT);
    }

    public static ByteBuffer nlogFilename(long struct) {
        return MemoryUtil.memByteBufferNT1(MemoryUtil.memGetAddress(struct + (long)LOGFILENAME));
    }

    public static String nlogFilenameString(long struct) {
        return MemoryUtil.memASCII(MemoryUtil.memGetAddress(struct + (long)LOGFILENAME));
    }

    public static void nport(long struct, short value) {
        MemoryUtil.memPutShort(struct + (long)PORT, value);
    }

    public static void nreuse_open_port(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)REUSE_OPEN_PORT, value);
    }

    public static void nlimit_connections_to_localhost(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)LIMIT_CONNECTIONS_TO_LOCALHOST, value);
    }

    public static void nmsSleepBetweenServerUpdates(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)MSSLEEPBETWEENSERVERUPDATES, value);
    }

    public static void nmessageQueueSizeInBytes(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)MESSAGEQUEUESIZEINBYTES, value);
    }

    public static void nmaxNbMessagesPerUpdate(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)MAXNBMESSAGESPERUPDATE, value);
    }

    public static void n_malloc(long struct, RMTMallocI value) {
        MemoryUtil.memPutAddress(struct + (long)_MALLOC, value.address());
    }

    public static void nrealloc(long struct, RMTReallocI value) {
        MemoryUtil.memPutAddress(struct + (long)REALLOC, value.address());
    }

    public static void n_free(long struct, RMTFreeI value) {
        MemoryUtil.memPutAddress(struct + (long)_FREE, value.address());
    }

    public static void nmm_context(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)MM_CONTEXT, Checks.check(value));
    }

    public static void ninput_handler(long struct, RMTInputHandlerI value) {
        MemoryUtil.memPutAddress(struct + (long)INPUT_HANDLER, value.address());
    }

    public static void ninput_handler_context(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)INPUT_HANDLER_CONTEXT, Checks.check(value));
    }

    public static void nlogFilename(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1(value);
        }
        MemoryUtil.memPutAddress(struct + (long)LOGFILENAME, MemoryUtil.memAddress(value));
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)_MALLOC));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)REALLOC));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)_FREE));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)MM_CONTEXT));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)INPUT_HANDLER));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)INPUT_HANDLER_CONTEXT));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)LOGFILENAME));
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            RMTSettings.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = RMTSettings.__struct(RMTSettings.__member(2), RMTSettings.__member(4), RMTSettings.__member(4), RMTSettings.__member(4), RMTSettings.__member(4), RMTSettings.__member(4), RMTSettings.__member(POINTER_SIZE), RMTSettings.__member(POINTER_SIZE), RMTSettings.__member(POINTER_SIZE), RMTSettings.__member(POINTER_SIZE), RMTSettings.__member(POINTER_SIZE), RMTSettings.__member(POINTER_SIZE), RMTSettings.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        PORT = layout.offsetof(0);
        REUSE_OPEN_PORT = layout.offsetof(1);
        LIMIT_CONNECTIONS_TO_LOCALHOST = layout.offsetof(2);
        MSSLEEPBETWEENSERVERUPDATES = layout.offsetof(3);
        MESSAGEQUEUESIZEINBYTES = layout.offsetof(4);
        MAXNBMESSAGESPERUPDATE = layout.offsetof(5);
        _MALLOC = layout.offsetof(6);
        REALLOC = layout.offsetof(7);
        _FREE = layout.offsetof(8);
        MM_CONTEXT = layout.offsetof(9);
        INPUT_HANDLER = layout.offsetof(10);
        INPUT_HANDLER_CONTEXT = layout.offsetof(11);
        LOGFILENAME = layout.offsetof(12);
    }
}

