/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.par;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct par_shapes_mesh")
public class ParShapesMesh
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int POINTS;
    public static final int NPOINTS;
    public static final int TRIANGLES;
    public static final int NTRIANGLES;
    public static final int NORMALS;
    public static final int TCOORDS;

    ParShapesMesh(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public ParShapesMesh(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), ParShapesMesh.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="float *")
    public FloatBuffer points(int capacity) {
        return ParShapesMesh.npoints(this.address(), capacity);
    }

    public int npoints() {
        return ParShapesMesh.nnpoints(this.address());
    }

    @NativeType(value="PAR_SHAPES_T *")
    public IntBuffer triangles(int capacity) {
        return ParShapesMesh.ntriangles(this.address(), capacity);
    }

    public int ntriangles() {
        return ParShapesMesh.nntriangles(this.address());
    }

    @Nullable
    @NativeType(value="float *")
    public FloatBuffer normals(int capacity) {
        return ParShapesMesh.nnormals(this.address(), capacity);
    }

    @Nullable
    @NativeType(value="float *")
    public FloatBuffer tcoords(int capacity) {
        return ParShapesMesh.ntcoords(this.address(), capacity);
    }

    public static ParShapesMesh create(long address) {
        return new ParShapesMesh(address, null);
    }

    @Nullable
    public static ParShapesMesh createSafe(long address) {
        return address == 0L ? null : ParShapesMesh.create(address);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : ParShapesMesh.create(address, capacity);
    }

    public static FloatBuffer npoints(long struct, int capacity) {
        return MemoryUtil.memFloatBuffer(MemoryUtil.memGetAddress(struct + (long)POINTS), capacity);
    }

    public static int nnpoints(long struct) {
        return MemoryUtil.memGetInt(struct + (long)NPOINTS);
    }

    public static IntBuffer ntriangles(long struct, int capacity) {
        return MemoryUtil.memIntBuffer(MemoryUtil.memGetAddress(struct + (long)TRIANGLES), capacity);
    }

    public static int nntriangles(long struct) {
        return MemoryUtil.memGetInt(struct + (long)NTRIANGLES);
    }

    @Nullable
    public static FloatBuffer nnormals(long struct, int capacity) {
        return MemoryUtil.memFloatBufferSafe(MemoryUtil.memGetAddress(struct + (long)NORMALS), capacity);
    }

    @Nullable
    public static FloatBuffer ntcoords(long struct, int capacity) {
        return MemoryUtil.memFloatBufferSafe(MemoryUtil.memGetAddress(struct + (long)TCOORDS), capacity);
    }

    static {
        Struct.Layout layout = ParShapesMesh.__struct(ParShapesMesh.__member(POINTER_SIZE), ParShapesMesh.__member(4), ParShapesMesh.__member(POINTER_SIZE), ParShapesMesh.__member(4), ParShapesMesh.__member(POINTER_SIZE), ParShapesMesh.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        POINTS = layout.offsetof(0);
        NPOINTS = layout.offsetof(1);
        TRIANGLES = layout.offsetof(2);
        NTRIANGLES = layout.offsetof(3);
        NORMALS = layout.offsetof(4);
        TCOORDS = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<ParShapesMesh, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected ParShapesMesh newInstance(long address) {
            return new ParShapesMesh(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="float *")
        public FloatBuffer points(int capacity) {
            return ParShapesMesh.npoints(this.address(), capacity);
        }

        public int npoints() {
            return ParShapesMesh.nnpoints(this.address());
        }

        @NativeType(value="PAR_SHAPES_T *")
        public IntBuffer triangles(int capacity) {
            return ParShapesMesh.ntriangles(this.address(), capacity);
        }

        public int ntriangles() {
            return ParShapesMesh.nntriangles(this.address());
        }

        @Nullable
        @NativeType(value="float *")
        public FloatBuffer normals(int capacity) {
            return ParShapesMesh.nnormals(this.address(), capacity);
        }

        @Nullable
        @NativeType(value="float *")
        public FloatBuffer tcoords(int capacity) {
            return ParShapesMesh.ntcoords(this.address(), capacity);
        }
    }
}

