/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.nfd;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.util.nfd.LibNFD;

@NativeType(value="struct nfdpathset_t")
public class NFDPathSet
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;

    private static native int offsets(long var0);

    NFDPathSet(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public NFDPathSet(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), NFDPathSet.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public static NFDPathSet malloc() {
        return NFDPathSet.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static NFDPathSet calloc() {
        return NFDPathSet.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static NFDPathSet create() {
        return new NFDPathSet(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static NFDPathSet create(long address) {
        return new NFDPathSet(address, null);
    }

    @Nullable
    public static NFDPathSet createSafe(long address) {
        return address == 0L ? null : NFDPathSet.create(address);
    }

    public static Buffer malloc(int capacity) {
        return NFDPathSet.create(NFDPathSet.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return NFDPathSet.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(NFDPathSet.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : NFDPathSet.create(address, capacity);
    }

    public static NFDPathSet mallocStack() {
        return NFDPathSet.mallocStack(MemoryStack.stackGet());
    }

    public static NFDPathSet callocStack() {
        return NFDPathSet.callocStack(MemoryStack.stackGet());
    }

    public static NFDPathSet mallocStack(MemoryStack stack) {
        return NFDPathSet.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static NFDPathSet callocStack(MemoryStack stack) {
        return NFDPathSet.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return NFDPathSet.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return NFDPathSet.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return NFDPathSet.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return NFDPathSet.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    static {
        LibNFD.initialize();
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer offsets = stack.mallocInt(1);
            SIZEOF = NFDPathSet.offsets(MemoryUtil.memAddress(offsets));
            ALIGNOF = offsets.get(0);
        }
    }

    public static class Buffer
    extends StructBuffer<NFDPathSet, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected NFDPathSet newInstance(long address) {
            return new NFDPathSet(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }
    }
}

