/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.lz4;

import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import javax.annotation.Nullable;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.util.lz4.LZ4StreamDecodeInternal;

@NativeType(value="union LZ4_streamDecode_t")
public class LZ4StreamDecode
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TABLE;
    public static final int INTERNAL_DONOTUSE;

    LZ4StreamDecode(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public LZ4StreamDecode(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), LZ4StreamDecode.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="unsigned long long[LZ4_STREAMDECODESIZE_U64]")
    public LongBuffer table() {
        return LZ4StreamDecode.ntable(this.address());
    }

    @NativeType(value="unsigned long long")
    public long table(int index) {
        return LZ4StreamDecode.ntable(this.address(), index);
    }

    @NativeType(value="LZ4_streamDecode_t_internal")
    public LZ4StreamDecodeInternal internal_donotuse() {
        return LZ4StreamDecode.ninternal_donotuse(this.address());
    }

    public static LZ4StreamDecode create(long address) {
        return new LZ4StreamDecode(address, null);
    }

    @Nullable
    public static LZ4StreamDecode createSafe(long address) {
        return address == 0L ? null : LZ4StreamDecode.create(address);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : LZ4StreamDecode.create(address, capacity);
    }

    public static LongBuffer ntable(long struct) {
        return MemoryUtil.memLongBuffer(struct + (long)TABLE, 4);
    }

    public static long ntable(long struct, int index) {
        return MemoryUtil.memGetLong(struct + (long)TABLE + Checks.check(index, 4) * 8L);
    }

    public static LZ4StreamDecodeInternal ninternal_donotuse(long struct) {
        return LZ4StreamDecodeInternal.create(struct + (long)INTERNAL_DONOTUSE);
    }

    static {
        Struct.Layout layout = LZ4StreamDecode.__union(LZ4StreamDecode.__array(8, 4), LZ4StreamDecode.__member(LZ4StreamDecodeInternal.SIZEOF, LZ4StreamDecodeInternal.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TABLE = layout.offsetof(0);
        INTERNAL_DONOTUSE = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<LZ4StreamDecode, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected LZ4StreamDecode newInstance(long address) {
            return new LZ4StreamDecode(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="unsigned long long[LZ4_STREAMDECODESIZE_U64]")
        public LongBuffer table() {
            return LZ4StreamDecode.ntable(this.address());
        }

        @NativeType(value="unsigned long long")
        public long table(int index) {
            return LZ4StreamDecode.ntable(this.address(), index);
        }

        @NativeType(value="LZ4_streamDecode_t_internal")
        public LZ4StreamDecodeInternal internal_donotuse() {
            return LZ4StreamDecode.ninternal_donotuse(this.address());
        }
    }
}

