/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.lz4;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.util.lz4.LibLZ4;

public class LZ4 {
    public static final int LZ4_VERSION_MAJOR = 1;
    public static final int LZ4_VERSION_MINOR = 8;
    public static final int LZ4_VERSION_RELEASE = 2;
    public static final int LZ4_VERSION_NUMBER = 10802;
    public static final String LZ4_VERSION_STRING = "1.8.2";
    public static final int LZ4_MAX_INPUT_SIZE = 0x7E000000;
    public static final int LZ4_MEMORY_USAGE = 14;
    public static final int LZ4_HASHLOG = 12;
    public static final int LZ4_HASHTABLESIZE = 16384;
    public static final int LZ4_HASH_SIZE_U32 = 4096;
    public static final int LZ4_STREAMSIZE_U64 = 2052;
    public static final int LZ4_STREAMSIZE = 16416;
    public static final int LZ4_STREAMDECODESIZE_U64 = 4;
    public static final int LZ4_STREAMDECODESIZE = 32;

    protected LZ4() {
        throw new UnsupportedOperationException();
    }

    public static native int LZ4_versionNumber();

    public static native long nLZ4_versionString();

    @NativeType(value="char const *")
    public static String LZ4_versionString() {
        long __result = LZ4.nLZ4_versionString();
        return MemoryUtil.memASCII(__result);
    }

    public static native int nLZ4_compress_default(long var0, long var2, int var4, int var5);

    public static int LZ4_compress_default(@NativeType(value="char const *") ByteBuffer src, @NativeType(value="char *") ByteBuffer dst) {
        return LZ4.nLZ4_compress_default(MemoryUtil.memAddress(src), MemoryUtil.memAddress(dst), src.remaining(), dst.remaining());
    }

    public static native int nLZ4_decompress_safe(long var0, long var2, int var4, int var5);

    public static int LZ4_decompress_safe(@NativeType(value="char const *") ByteBuffer src, @NativeType(value="char *") ByteBuffer dst) {
        return LZ4.nLZ4_decompress_safe(MemoryUtil.memAddress(src), MemoryUtil.memAddress(dst), src.remaining(), dst.remaining());
    }

    public static int LZ4_COMPRESSBOUND(int isize) {
        return 0x7E000000 < isize ? 0 : isize + isize / 255 + 16;
    }

    public static native int LZ4_compressBound(int var0);

    public static native int nLZ4_compress_fast(long var0, long var2, int var4, int var5, int var6);

    public static int LZ4_compress_fast(@NativeType(value="char const *") ByteBuffer src, @NativeType(value="char *") ByteBuffer dst, int acceleration) {
        return LZ4.nLZ4_compress_fast(MemoryUtil.memAddress(src), MemoryUtil.memAddress(dst), src.remaining(), dst.remaining(), acceleration);
    }

    public static native int LZ4_sizeofState();

    public static native int nLZ4_compress_fast_extState(long var0, long var2, long var4, int var6, int var7, int var8);

    public static int LZ4_compress_fast_extState(@NativeType(value="void *") ByteBuffer state, @NativeType(value="char const *") ByteBuffer src, @NativeType(value="char *") ByteBuffer dst, int acceleration) {
        return LZ4.nLZ4_compress_fast_extState(MemoryUtil.memAddress(state), MemoryUtil.memAddress(src), MemoryUtil.memAddress(dst), src.remaining(), dst.remaining(), acceleration);
    }

    public static native int nLZ4_compress_destSize(long var0, long var2, long var4, int var6);

    public static int LZ4_compress_destSize(@NativeType(value="char const *") ByteBuffer src, @NativeType(value="char *") ByteBuffer dst, @NativeType(value="int *") IntBuffer srcSizePtr) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)srcSizePtr, 1);
            Checks.check((Buffer)src, srcSizePtr.get(srcSizePtr.position()));
        }
        return LZ4.nLZ4_compress_destSize(MemoryUtil.memAddress(src), MemoryUtil.memAddress(dst), MemoryUtil.memAddress(srcSizePtr), dst.remaining());
    }

    public static native int nLZ4_decompress_fast(long var0, long var2, int var4);

    public static int LZ4_decompress_fast(@NativeType(value="char const *") ByteBuffer src, @NativeType(value="char *") ByteBuffer dst) {
        return LZ4.nLZ4_decompress_fast(MemoryUtil.memAddress(src), MemoryUtil.memAddress(dst), dst.remaining());
    }

    public static native int nLZ4_decompress_safe_partial(long var0, long var2, int var4, int var5, int var6);

    public static int LZ4_decompress_safe_partial(@NativeType(value="char const *") ByteBuffer src, @NativeType(value="char *") ByteBuffer dst, int targetOutputSize) {
        return LZ4.nLZ4_decompress_safe_partial(MemoryUtil.memAddress(src), MemoryUtil.memAddress(dst), src.remaining(), targetOutputSize, dst.remaining());
    }

    @NativeType(value="LZ4_stream_t *")
    public static native long LZ4_createStream();

    public static native int nLZ4_freeStream(long var0);

    public static int LZ4_freeStream(@NativeType(value="LZ4_stream_t *") long streamPtr) {
        if (Checks.CHECKS) {
            Checks.check(streamPtr);
        }
        return LZ4.nLZ4_freeStream(streamPtr);
    }

    public static native void nLZ4_resetStream(long var0);

    public static void LZ4_resetStream(@NativeType(value="LZ4_stream_t *") long streamPtr) {
        if (Checks.CHECKS) {
            Checks.check(streamPtr);
        }
        LZ4.nLZ4_resetStream(streamPtr);
    }

    public static native int nLZ4_loadDict(long var0, long var2, int var4);

    public static int LZ4_loadDict(@NativeType(value="LZ4_stream_t *") long streamPtr, @Nullable @NativeType(value="char const *") ByteBuffer dictionary) {
        if (Checks.CHECKS) {
            Checks.check(streamPtr);
        }
        return LZ4.nLZ4_loadDict(streamPtr, MemoryUtil.memAddressSafe(dictionary), Checks.remainingSafe(dictionary));
    }

    public static native int nLZ4_compress_fast_continue(long var0, long var2, long var4, int var6, int var7, int var8);

    public static int LZ4_compress_fast_continue(@NativeType(value="LZ4_stream_t *") long streamPtr, @NativeType(value="char const *") ByteBuffer src, @NativeType(value="char *") ByteBuffer dst, int acceleration) {
        if (Checks.CHECKS) {
            Checks.check(streamPtr);
        }
        return LZ4.nLZ4_compress_fast_continue(streamPtr, MemoryUtil.memAddress(src), MemoryUtil.memAddress(dst), src.remaining(), dst.remaining(), acceleration);
    }

    public static native int nLZ4_saveDict(long var0, long var2, int var4);

    public static int LZ4_saveDict(@NativeType(value="LZ4_stream_t *") long streamPtr, @NativeType(value="char *") ByteBuffer safeBuffer) {
        if (Checks.CHECKS) {
            Checks.check(streamPtr);
        }
        return LZ4.nLZ4_saveDict(streamPtr, MemoryUtil.memAddress(safeBuffer), safeBuffer.remaining());
    }

    @NativeType(value="LZ4_streamDecode_t *")
    public static native long LZ4_createStreamDecode();

    public static native int nLZ4_freeStreamDecode(long var0);

    public static int LZ4_freeStreamDecode(@NativeType(value="LZ4_streamDecode_t *") long LZ4_stream) {
        if (Checks.CHECKS) {
            Checks.check(LZ4_stream);
        }
        return LZ4.nLZ4_freeStreamDecode(LZ4_stream);
    }

    public static native int nLZ4_setStreamDecode(long var0, long var2, int var4);

    @NativeType(value="int")
    public static boolean LZ4_setStreamDecode(@NativeType(value="LZ4_streamDecode_t *") long LZ4_streamDecode, @NativeType(value="char const *") ByteBuffer dictionary) {
        if (Checks.CHECKS) {
            Checks.check(LZ4_streamDecode);
        }
        return LZ4.nLZ4_setStreamDecode(LZ4_streamDecode, MemoryUtil.memAddress(dictionary), dictionary.remaining()) != 0;
    }

    public static native int LZ4_decoderRingBufferSize(int var0);

    public static native int nLZ4_decompress_safe_continue(long var0, long var2, long var4, int var6, int var7);

    public static int LZ4_decompress_safe_continue(@NativeType(value="LZ4_streamDecode_t *") long LZ4_streamDecode, @NativeType(value="char const *") ByteBuffer src, @NativeType(value="char *") ByteBuffer dst) {
        if (Checks.CHECKS) {
            Checks.check(LZ4_streamDecode);
        }
        return LZ4.nLZ4_decompress_safe_continue(LZ4_streamDecode, MemoryUtil.memAddress(src), MemoryUtil.memAddress(dst), src.remaining(), dst.remaining());
    }

    public static native int nLZ4_decompress_fast_continue(long var0, long var2, long var4, int var6);

    public static int LZ4_decompress_fast_continue(@NativeType(value="LZ4_streamDecode_t *") long LZ4_streamDecode, @NativeType(value="char const *") ByteBuffer src, @NativeType(value="char *") ByteBuffer dst) {
        if (Checks.CHECKS) {
            Checks.check(LZ4_streamDecode);
        }
        return LZ4.nLZ4_decompress_fast_continue(LZ4_streamDecode, MemoryUtil.memAddress(src), MemoryUtil.memAddress(dst), dst.remaining());
    }

    public static native int nLZ4_decompress_safe_usingDict(long var0, long var2, int var4, int var5, long var6, int var8);

    public static int LZ4_decompress_safe_usingDict(@NativeType(value="char const *") ByteBuffer src, @NativeType(value="char *") ByteBuffer dst, @NativeType(value="char const *") ByteBuffer dictStart) {
        return LZ4.nLZ4_decompress_safe_usingDict(MemoryUtil.memAddress(src), MemoryUtil.memAddress(dst), src.remaining(), dst.remaining(), MemoryUtil.memAddress(dictStart), dictStart.remaining());
    }

    public static native int nLZ4_decompress_fast_usingDict(long var0, long var2, int var4, long var5, int var7);

    public static int LZ4_decompress_fast_usingDict(@NativeType(value="char const *") ByteBuffer src, @NativeType(value="char *") ByteBuffer dst, @NativeType(value="char const *") ByteBuffer dictStart) {
        return LZ4.nLZ4_decompress_fast_usingDict(MemoryUtil.memAddress(src), MemoryUtil.memAddress(dst), dst.remaining(), MemoryUtil.memAddress(dictStart), dictStart.remaining());
    }

    public static native void nLZ4_resetStream_fast(long var0);

    public static void LZ4_resetStream_fast(@NativeType(value="LZ4_stream_t *") long streamPtr) {
        if (Checks.CHECKS) {
            Checks.check(streamPtr);
        }
        LZ4.nLZ4_resetStream_fast(streamPtr);
    }

    public static native int nLZ4_compress_fast_extState_fastReset(long var0, long var2, long var4, int var6, int var7, int var8);

    public static int LZ4_compress_fast_extState_fastReset(@NativeType(value="void *") ByteBuffer state, @NativeType(value="char const *") ByteBuffer src, @NativeType(value="char *") ByteBuffer dst, int acceleration) {
        return LZ4.nLZ4_compress_fast_extState_fastReset(MemoryUtil.memAddress(state), MemoryUtil.memAddress(src), MemoryUtil.memAddress(dst), src.remaining(), dst.remaining(), acceleration);
    }

    public static native void nLZ4_attach_dictionary(long var0, long var2);

    public static void LZ4_attach_dictionary(@NativeType(value="LZ4_stream_t *") long working_stream, @NativeType(value="LZ4_stream_t const *") long dictionary_stream) {
        if (Checks.CHECKS) {
            Checks.check(working_stream);
        }
        LZ4.nLZ4_attach_dictionary(working_stream, dictionary_stream);
    }

    public static int LZ4_DECODER_RING_BUFFER_SIZE(int mbs) {
        return 65550 + mbs;
    }

    static {
        LibLZ4.initialize();
    }
}

