/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.Objects;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Library;
import org.lwjgl.system.MathUtil;
import org.lwjgl.system.MemoryAccessJNI;
import org.lwjgl.system.MemoryTextUtil;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.jni.JNINativeInterface;
import org.lwjgl.system.libc.LibCString;
import sun.misc.Unsafe;

final class MemoryAccess {
    private MemoryAccess() {
    }

    static MemoryAccessor getInstance() {
        try {
            return new MemoryAccessorUnsafe();
        }
        catch (Throwable t) {
            t.printStackTrace(APIUtil.DEBUG_STREAM);
            APIUtil.DEBUG_STREAM.println("[LWJGL] [MemoryAccessor] Unsupported JVM detected, this will likely result in low performance. Please inform LWJGL developers.");
            return new MemoryAccessorJNI();
        }
    }

    static Unsafe getUnsafeInstance() {
        Field[] fields;
        for (Field field : fields = Unsafe.class.getDeclaredFields()) {
            int modifiers;
            if (!field.getType().equals(Unsafe.class) || !Modifier.isStatic(modifiers = field.getModifiers()) || !Modifier.isFinal(modifiers)) continue;
            field.setAccessible(true);
            try {
                return (Unsafe)field.get(null);
            }
            catch (IllegalAccessException illegalAccessException) {
                break;
            }
        }
        throw new UnsupportedOperationException();
    }

    static {
        Library.initialize();
    }

    private static final class MemoryAccessorUnsafe
    implements MemoryAccessor {
        private static final Class<? extends ByteBuffer> BYTE_BUFFER;
        private static final Class<? extends ShortBuffer> SHORT_BUFFER;
        private static final Class<? extends CharBuffer> CHAR_BUFFER;
        private static final Class<? extends IntBuffer> INT_BUFFER;
        private static final Class<? extends LongBuffer> LONG_BUFFER;
        private static final Class<? extends FloatBuffer> FLOAT_BUFFER;
        private static final Class<? extends DoubleBuffer> DOUBLE_BUFFER;
        private static final Unsafe UNSAFE;
        private static final long ADDRESS;
        private static final long CAPACITY;

        private static long getAddressOffset() {
            long MAGIC_ADDRESS = -2401053090268712947L;
            if (Pointer.BITS32) {
                MAGIC_ADDRESS &= 0xFFFFFFFFL;
            }
            ByteBuffer bb = Objects.requireNonNull(JNINativeInterface.NewDirectByteBuffer(MAGIC_ADDRESS, 0L));
            long offset = 8L;
            while (UNSAFE.getLong(bb, offset) != MAGIC_ADDRESS) {
                offset += 8L;
            }
            return offset;
        }

        private static long getCapacityOffset() {
            int MAGIC_CAPACITY = 219540062;
            ByteBuffer bb = Objects.requireNonNull(JNINativeInterface.NewDirectByteBuffer(-1L, MAGIC_CAPACITY));
            bb.limit(0);
            long offset = 4L;
            while (UNSAFE.getInt(bb, offset) != MAGIC_CAPACITY) {
                offset += 4L;
            }
            return offset;
        }

        MemoryAccessorUnsafe() {
        }

        @Override
        public int getPageSize() {
            return UNSAFE.pageSize();
        }

        @Override
        public long memAddress0(Buffer buffer) {
            return UNSAFE.getLong(buffer, ADDRESS);
        }

        @Override
        public ByteBuffer memByteBuffer(long address, int capacity) {
            return MemoryAccessorUnsafe.setup(BYTE_BUFFER, address, capacity).order(ByteOrder.nativeOrder());
        }

        @Override
        public ShortBuffer memShortBuffer(long address, int capacity) {
            return MemoryAccessorUnsafe.setup(SHORT_BUFFER, address, capacity);
        }

        @Override
        public CharBuffer memCharBuffer(long address, int capacity) {
            return MemoryAccessorUnsafe.setup(CHAR_BUFFER, address, capacity);
        }

        @Override
        public IntBuffer memIntBuffer(long address, int capacity) {
            return MemoryAccessorUnsafe.setup(INT_BUFFER, address, capacity);
        }

        @Override
        public LongBuffer memLongBuffer(long address, int capacity) {
            return MemoryAccessorUnsafe.setup(LONG_BUFFER, address, capacity);
        }

        @Override
        public FloatBuffer memFloatBuffer(long address, int capacity) {
            return MemoryAccessorUnsafe.setup(FLOAT_BUFFER, address, capacity);
        }

        @Override
        public DoubleBuffer memDoubleBuffer(long address, int capacity) {
            return MemoryAccessorUnsafe.setup(DOUBLE_BUFFER, address, capacity);
        }

        private static <T extends Buffer> T setup(Class<T> clazz, long address, int capacity) {
            Buffer buffer;
            try {
                buffer = (Buffer)UNSAFE.allocateInstance(clazz);
            }
            catch (InstantiationException e) {
                throw new UnsupportedOperationException(e);
            }
            UNSAFE.putLong(buffer, ADDRESS, address);
            UNSAFE.putInt(buffer, CAPACITY, capacity);
            buffer.clear();
            return (T)buffer;
        }

        private static long shl(long value, int bytes) {
            if (ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN) {
                return value << (bytes << 3);
            }
            return value >>> (bytes << 3);
        }

        private static long shr(long value, int bytes) {
            if (ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN) {
                return value >>> (bytes << 3);
            }
            return value << (bytes << 3);
        }

        private static long merge(long a, long b, long mask) {
            return a ^ (a ^ b) & mask;
        }

        private static long fill(byte value) {
            long fill = value;
            if (value != 0) {
                fill |= fill << 8;
                fill |= fill << 16;
                fill |= fill << 32;
            }
            return fill;
        }

        @Override
        public void memSet(long dst, int value, long bytes) {
            if (bytes < 192L) {
                this.memSetLoop(dst, (byte)(value & 0xFF), (int)bytes);
            } else {
                LibCString.nmemset(dst, value, bytes);
            }
        }

        private void memSetLoop(long dst, byte value, int bytes) {
            int i = 0;
            int misalignment = (int)dst & 7;
            long fill = MemoryAccessorUnsafe.fill(value);
            if (8 <= bytes) {
                if (misalignment != 0) {
                    this.memPutLong(dst - (long)misalignment, MemoryAccessorUnsafe.merge(this.memGetLong(dst - (long)misalignment), fill, MemoryAccessorUnsafe.shr(-1L, misalignment)));
                    i += 8 - misalignment;
                }
                while (i <= bytes - 8) {
                    this.memPutLong(dst + (long)i, fill);
                    i += 8;
                }
            } else if (misalignment != 0 && 0 < bytes) {
                this.memPutLong(dst - (long)misalignment, MemoryAccessorUnsafe.merge(this.memGetLong(dst - (long)misalignment), fill, MemoryAccessorUnsafe.shr(MemoryAccessorUnsafe.shl(-1L, 8 - bytes), misalignment)));
                i += 8 - misalignment;
            }
            if (i < bytes) {
                this.memPutLong(dst + (long)i, MemoryAccessorUnsafe.merge(this.memGetLong(dst + (long)i), fill, MemoryAccessorUnsafe.shl(-1L, 8 - (bytes - i))));
            }
        }

        @Override
        public void memCopy(long src, long dst, long bytes) {
            if (bytes < 64L && ((int)src & 7) == 0 && ((int)dst & 7) == 0) {
                this.memCopyAligned(src, dst, (int)bytes);
            } else if (bytes < 384L) {
                UNSAFE.copyMemory(src, dst, bytes);
            } else {
                LibCString.nmemcpy(dst, src, bytes);
            }
        }

        private void memCopyAligned(long src, long dst, int bytes) {
            int i;
            for (i = 0; i <= bytes - 8; i += 8) {
                this.memPutLong(dst + (long)i, this.memGetLong(src + (long)i));
            }
            if (i < bytes) {
                this.memPutLong(dst + (long)i, MemoryAccessorUnsafe.merge(this.memGetLong(dst + (long)i), this.memGetLong(src + (long)i), MemoryAccessorUnsafe.shl(-1L, 8 - (bytes - i))));
            }
        }

        @Override
        public byte memGetByte(long ptr) {
            return UNSAFE.getByte(null, ptr);
        }

        @Override
        public short memGetShort(long ptr) {
            return UNSAFE.getShort(null, ptr);
        }

        @Override
        public int memGetInt(long ptr) {
            return UNSAFE.getInt(null, ptr);
        }

        @Override
        public long memGetLong(long ptr) {
            return UNSAFE.getLong(null, ptr);
        }

        @Override
        public float memGetFloat(long ptr) {
            return UNSAFE.getFloat(null, ptr);
        }

        @Override
        public double memGetDouble(long ptr) {
            return UNSAFE.getDouble(null, ptr);
        }

        @Override
        public void memPutByte(long ptr, byte value) {
            UNSAFE.putByte(null, ptr, value);
        }

        @Override
        public void memPutShort(long ptr, short value) {
            UNSAFE.putShort(null, ptr, value);
        }

        @Override
        public void memPutInt(long ptr, int value) {
            UNSAFE.putInt(null, ptr, value);
        }

        @Override
        public void memPutLong(long ptr, long value) {
            UNSAFE.putLong(null, ptr, value);
        }

        @Override
        public void memPutFloat(long ptr, float value) {
            UNSAFE.putFloat(null, ptr, value);
        }

        @Override
        public void memPutDouble(long ptr, double value) {
            UNSAFE.putDouble(null, ptr, value);
        }

        @Override
        public MemoryTextUtil getTextUtil() {
            return new MemoryTextUtilUnsafe();
        }

        static {
            ByteBuffer bb = ByteBuffer.allocateDirect(0).order(ByteOrder.nativeOrder());
            BYTE_BUFFER = bb.getClass();
            SHORT_BUFFER = bb.asShortBuffer().getClass();
            CHAR_BUFFER = bb.asCharBuffer().getClass();
            INT_BUFFER = bb.asIntBuffer().getClass();
            LONG_BUFFER = bb.asLongBuffer().getClass();
            FLOAT_BUFFER = bb.asFloatBuffer().getClass();
            DOUBLE_BUFFER = bb.asDoubleBuffer().getClass();
            try {
                UNSAFE = MemoryAccess.getUnsafeInstance();
                ADDRESS = MemoryAccessorUnsafe.getAddressOffset();
                CAPACITY = MemoryAccessorUnsafe.getCapacityOffset();
            }
            catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }

        private static class MemoryTextUtilUnsafe
        extends MemoryTextUtil {
            private MemoryTextUtilUnsafe() {
            }

            @Override
            int strlen64NT1(long address, int maxLength) {
                int i;
                if (8 <= maxLength) {
                    int misalignment = (int)address & 7;
                    if (misalignment != 0) {
                        int len = 8 - misalignment;
                        for (i = 0; i < len; ++i) {
                            if (UNSAFE.getByte(null, address + (long)i) != 0) continue;
                            return i;
                        }
                    }
                    while (i <= maxLength - 8 && !MathUtil.mathHasZeroByte(UNSAFE.getLong(null, address + (long)i))) {
                        i += 8;
                    }
                }
                while (i < maxLength && UNSAFE.getByte(null, address + (long)i) != 0) {
                    ++i;
                }
                return i;
            }

            @Override
            int strlen64NT2(long address, int maxLength) {
                int i;
                if (8 <= maxLength) {
                    int misalignment = (int)address & 7;
                    if (misalignment != 0) {
                        int len = 8 - misalignment;
                        for (i = 0; i < len; i += 2) {
                            if (UNSAFE.getShort(null, address + (long)i) != 0) continue;
                            return i;
                        }
                    }
                    while (i <= maxLength - 8 && !MathUtil.mathHasZeroShort(UNSAFE.getLong(null, address + (long)i))) {
                        i += 8;
                    }
                }
                while (i < maxLength && UNSAFE.getShort(null, address + (long)i) != 0) {
                    i += 2;
                }
                return i;
            }

            @Override
            int strlen32NT1(long address, int maxLength) {
                int i;
                if (4 <= maxLength) {
                    int misalignment = (int)address & 3;
                    if (misalignment != 0) {
                        int len = 4 - misalignment;
                        for (i = 0; i < len; ++i) {
                            if (UNSAFE.getByte(null, address + (long)i) != 0) continue;
                            return i;
                        }
                    }
                    while (i <= maxLength - 4 && !MathUtil.mathHasZeroByte(UNSAFE.getInt(null, address + (long)i))) {
                        i += 4;
                    }
                }
                while (i < maxLength && UNSAFE.getByte(null, address + (long)i) != 0) {
                    ++i;
                }
                return i;
            }

            @Override
            int strlen32NT2(long address, int maxLength) {
                int i;
                if (4 <= maxLength) {
                    int misalignment = (int)address & 3;
                    if (misalignment != 0) {
                        int len = 4 - misalignment;
                        for (i = 0; i < len; i += 2) {
                            if (UNSAFE.getShort(null, address + (long)i) != 0) continue;
                            return i;
                        }
                    }
                    while (i <= maxLength - 4 && !MathUtil.mathHasZeroShort(UNSAFE.getInt(null, address + (long)i))) {
                        i += 4;
                    }
                }
                while (i < maxLength && UNSAFE.getShort(null, address + (long)i) != 0) {
                    i += 2;
                }
                return i;
            }

            @Override
            int encodeASCII(CharSequence text, boolean nullTerminated, ByteBuffer target, int offset) {
                return MemoryTextUtilUnsafe.encodeASCII(text, nullTerminated, MemoryUtil.memAddress(target) + (long)offset);
            }

            private static int encodeASCII(CharSequence text, boolean nullTerminated, long target) {
                int p;
                int len = text.length();
                for (p = 0; p < len; ++p) {
                    UNSAFE.putByte(target + (long)p, (byte)text.charAt(p));
                }
                if (nullTerminated) {
                    UNSAFE.putByte(target + (long)p++, (byte)0);
                }
                return p;
            }

            @Override
            int encodeUTF8(CharSequence text, boolean nullTerminated, ByteBuffer target, int offset) {
                return MemoryTextUtilUnsafe.encodeUTF8(text, nullTerminated, MemoryUtil.memAddress(target) + (long)offset);
            }

            private static int encodeUTF8(CharSequence text, boolean nullTerminated, long target) {
                int c;
                int i;
                int len = text.length();
                int p = 0;
                for (i = 0; i < len && (c = text.charAt(i)) < 128; ++i) {
                    UNSAFE.putByte(target + (long)p++, (byte)c);
                }
                while (i < len) {
                    if ((c = text.charAt(i++)) < 128) {
                        UNSAFE.putByte(target + (long)p++, (byte)c);
                        continue;
                    }
                    int cp = c;
                    if (c < 2048) {
                        UNSAFE.putByte(target + (long)p++, (byte)(0xC0 | cp >> 6));
                    } else {
                        if (!Character.isHighSurrogate((char)c)) {
                            UNSAFE.putByte(target + (long)p++, (byte)(0xE0 | cp >> 12));
                        } else {
                            cp = Character.toCodePoint((char)c, text.charAt(i++));
                            UNSAFE.putByte(target + (long)p++, (byte)(0xF0 | cp >> 18));
                            UNSAFE.putByte(target + (long)p++, (byte)(0x80 | cp >> 12 & 0x3F));
                        }
                        UNSAFE.putByte(target + (long)p++, (byte)(0x80 | cp >> 6 & 0x3F));
                    }
                    UNSAFE.putByte(target + (long)p++, (byte)(0x80 | cp & 0x3F));
                }
                if (nullTerminated) {
                    UNSAFE.putByte(target + (long)p, (byte)0);
                }
                return p;
            }

            @Override
            int encodeUTF16(CharSequence text, boolean nullTerminated, ByteBuffer target, int offset) {
                return MemoryTextUtilUnsafe.encodeUTF16(text, nullTerminated, MemoryUtil.memAddress(target) + (long)offset);
            }

            private static int encodeUTF16(CharSequence text, boolean nullTerminated, long target) {
                int len = text.length();
                for (int i = 0; i < len; ++i) {
                    UNSAFE.putShort(target + (long)(2 * i), (short)text.charAt(i));
                }
                if (nullTerminated) {
                    UNSAFE.putShort(target + (long)(2 * len), (short)0);
                }
                return 2 * (len + (nullTerminated ? 1 : 0));
            }
        }
    }

    private static final class MemoryAccessorJNI
    implements MemoryAccessor {
        private MemoryAccessorJNI() {
        }
    }

    static interface MemoryAccessor {
        default public int getPageSize() {
            return 4096;
        }

        default public int getCacheLineSize() {
            return 64;
        }

        default public long memAddress0(Buffer buffer) {
            return JNINativeInterface.GetDirectBufferAddress(buffer);
        }

        default public ByteBuffer memByteBuffer(long address, int capacity) {
            return Objects.requireNonNull(JNINativeInterface.NewDirectByteBuffer(address, capacity)).order(ByteOrder.nativeOrder());
        }

        default public ShortBuffer memShortBuffer(long address, int capacity) {
            return this.memByteBuffer(address, capacity << 1).asShortBuffer();
        }

        default public CharBuffer memCharBuffer(long address, int capacity) {
            return this.memByteBuffer(address, capacity << 1).asCharBuffer();
        }

        default public IntBuffer memIntBuffer(long address, int capacity) {
            return this.memByteBuffer(address, capacity << 2).asIntBuffer();
        }

        default public LongBuffer memLongBuffer(long address, int capacity) {
            return this.memByteBuffer(address, capacity << 3).asLongBuffer();
        }

        default public FloatBuffer memFloatBuffer(long address, int capacity) {
            return this.memByteBuffer(address, capacity << 2).asFloatBuffer();
        }

        default public DoubleBuffer memDoubleBuffer(long address, int capacity) {
            return this.memByteBuffer(address, capacity << 3).asDoubleBuffer();
        }

        default public void memSet(long dst, int value, long bytes) {
            LibCString.nmemset(dst, value, bytes);
        }

        default public void memCopy(long src, long dst, long bytes) {
            LibCString.nmemcpy(dst, src, bytes);
        }

        default public byte memGetByte(long ptr) {
            return MemoryAccessJNI.getByte(ptr);
        }

        default public short memGetShort(long ptr) {
            return MemoryAccessJNI.getShort(ptr);
        }

        default public int memGetInt(long ptr) {
            return MemoryAccessJNI.getInt(ptr);
        }

        default public long memGetLong(long ptr) {
            return MemoryAccessJNI.getLong(ptr);
        }

        default public float memGetFloat(long ptr) {
            return MemoryAccessJNI.getFloat(ptr);
        }

        default public double memGetDouble(long ptr) {
            return MemoryAccessJNI.getDouble(ptr);
        }

        default public void memPutByte(long ptr, byte value) {
            MemoryAccessJNI.putByte(ptr, value);
        }

        default public void memPutShort(long ptr, short value) {
            MemoryAccessJNI.putShort(ptr, value);
        }

        default public void memPutInt(long ptr, int value) {
            MemoryAccessJNI.putInt(ptr, value);
        }

        default public void memPutLong(long ptr, long value) {
            MemoryAccessJNI.putLong(ptr, value);
        }

        default public void memPutFloat(long ptr, float value) {
            MemoryAccessJNI.putFloat(ptr, value);
        }

        default public void memPutDouble(long ptr, double value) {
            MemoryAccessJNI.putDouble(ptr, value);
        }

        default public MemoryTextUtil getTextUtil() {
            return new MemoryTextUtil();
        }
    }
}

