/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.ovr.OVRSizei;
import org.lwjgl.ovr.OVRVector2i;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct ovrRecti")
public class OVRRecti
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int POS;
    public static final int SIZE;

    OVRRecti(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public OVRRecti(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), OVRRecti.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="ovrVector2i")
    public OVRVector2i Pos() {
        return OVRRecti.nPos(this.address());
    }

    public OVRRecti Pos(Consumer<OVRVector2i> consumer) {
        consumer.accept(this.Pos());
        return this;
    }

    @NativeType(value="ovrSizei")
    public OVRSizei Size() {
        return OVRRecti.nSize(this.address());
    }

    public OVRRecti Size(Consumer<OVRSizei> consumer) {
        consumer.accept(this.Size());
        return this;
    }

    public OVRRecti Pos(@NativeType(value="ovrVector2i") OVRVector2i value) {
        OVRRecti.nPos(this.address(), value);
        return this;
    }

    public OVRRecti Size(@NativeType(value="ovrSizei") OVRSizei value) {
        OVRRecti.nSize(this.address(), value);
        return this;
    }

    public OVRRecti set(OVRVector2i Pos2, OVRSizei Size) {
        this.Pos(Pos2);
        this.Size(Size);
        return this;
    }

    public OVRRecti set(OVRRecti src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static OVRRecti malloc() {
        return OVRRecti.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static OVRRecti calloc() {
        return OVRRecti.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static OVRRecti create() {
        return new OVRRecti(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static OVRRecti create(long address) {
        return new OVRRecti(address, null);
    }

    @Nullable
    public static OVRRecti createSafe(long address) {
        return address == 0L ? null : OVRRecti.create(address);
    }

    public static Buffer malloc(int capacity) {
        return OVRRecti.create(OVRRecti.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return OVRRecti.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(OVRRecti.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : OVRRecti.create(address, capacity);
    }

    public static OVRRecti mallocStack() {
        return OVRRecti.mallocStack(MemoryStack.stackGet());
    }

    public static OVRRecti callocStack() {
        return OVRRecti.callocStack(MemoryStack.stackGet());
    }

    public static OVRRecti mallocStack(MemoryStack stack) {
        return OVRRecti.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static OVRRecti callocStack(MemoryStack stack) {
        return OVRRecti.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return OVRRecti.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return OVRRecti.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return OVRRecti.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return OVRRecti.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static OVRVector2i nPos(long struct) {
        return OVRVector2i.create(struct + (long)POS);
    }

    public static OVRSizei nSize(long struct) {
        return OVRSizei.create(struct + (long)SIZE);
    }

    public static void nPos(long struct, OVRVector2i value) {
        MemoryUtil.memCopy(value.address(), struct + (long)POS, OVRVector2i.SIZEOF);
    }

    public static void nSize(long struct, OVRSizei value) {
        MemoryUtil.memCopy(value.address(), struct + (long)SIZE, OVRSizei.SIZEOF);
    }

    static {
        Struct.Layout layout = OVRRecti.__struct(OVRRecti.__member(OVRVector2i.SIZEOF, OVRVector2i.ALIGNOF), OVRRecti.__member(OVRSizei.SIZEOF, OVRSizei.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        POS = layout.offsetof(0);
        SIZE = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<OVRRecti, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected OVRRecti newInstance(long address) {
            return new OVRRecti(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="ovrVector2i")
        public OVRVector2i Pos() {
            return OVRRecti.nPos(this.address());
        }

        public Buffer Pos(Consumer<OVRVector2i> consumer) {
            consumer.accept(this.Pos());
            return this;
        }

        @NativeType(value="ovrSizei")
        public OVRSizei Size() {
            return OVRRecti.nSize(this.address());
        }

        public Buffer Size(Consumer<OVRSizei> consumer) {
            consumer.accept(this.Size());
            return this;
        }

        public Buffer Pos(@NativeType(value="ovrVector2i") OVRVector2i value) {
            OVRRecti.nPos(this.address(), value);
            return this;
        }

        public Buffer Size(@NativeType(value="ovrSizei") OVRSizei value) {
            OVRRecti.nSize(this.address(), value);
            return this;
        }
    }
}

