/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct ovrMirrorTextureDesc")
public class OVRMirrorTextureDesc
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int FORMAT;
    public static final int WIDTH;
    public static final int HEIGHT;
    public static final int MISCFLAGS;

    OVRMirrorTextureDesc(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public OVRMirrorTextureDesc(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), OVRMirrorTextureDesc.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="ovrTextureFormat")
    public int Format() {
        return OVRMirrorTextureDesc.nFormat(this.address());
    }

    public int Width() {
        return OVRMirrorTextureDesc.nWidth(this.address());
    }

    public int Height() {
        return OVRMirrorTextureDesc.nHeight(this.address());
    }

    @NativeType(value="unsigned int")
    public int MiscFlags() {
        return OVRMirrorTextureDesc.nMiscFlags(this.address());
    }

    public OVRMirrorTextureDesc Format(@NativeType(value="ovrTextureFormat") int value) {
        OVRMirrorTextureDesc.nFormat(this.address(), value);
        return this;
    }

    public OVRMirrorTextureDesc Width(int value) {
        OVRMirrorTextureDesc.nWidth(this.address(), value);
        return this;
    }

    public OVRMirrorTextureDesc Height(int value) {
        OVRMirrorTextureDesc.nHeight(this.address(), value);
        return this;
    }

    public OVRMirrorTextureDesc MiscFlags(@NativeType(value="unsigned int") int value) {
        OVRMirrorTextureDesc.nMiscFlags(this.address(), value);
        return this;
    }

    public OVRMirrorTextureDesc set(int Format2, int Width, int Height, int MiscFlags) {
        this.Format(Format2);
        this.Width(Width);
        this.Height(Height);
        this.MiscFlags(MiscFlags);
        return this;
    }

    public OVRMirrorTextureDesc set(OVRMirrorTextureDesc src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static OVRMirrorTextureDesc malloc() {
        return OVRMirrorTextureDesc.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static OVRMirrorTextureDesc calloc() {
        return OVRMirrorTextureDesc.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static OVRMirrorTextureDesc create() {
        return new OVRMirrorTextureDesc(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static OVRMirrorTextureDesc create(long address) {
        return new OVRMirrorTextureDesc(address, null);
    }

    @Nullable
    public static OVRMirrorTextureDesc createSafe(long address) {
        return address == 0L ? null : OVRMirrorTextureDesc.create(address);
    }

    public static Buffer malloc(int capacity) {
        return OVRMirrorTextureDesc.create(OVRMirrorTextureDesc.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return OVRMirrorTextureDesc.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(OVRMirrorTextureDesc.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : OVRMirrorTextureDesc.create(address, capacity);
    }

    public static OVRMirrorTextureDesc mallocStack() {
        return OVRMirrorTextureDesc.mallocStack(MemoryStack.stackGet());
    }

    public static OVRMirrorTextureDesc callocStack() {
        return OVRMirrorTextureDesc.callocStack(MemoryStack.stackGet());
    }

    public static OVRMirrorTextureDesc mallocStack(MemoryStack stack) {
        return OVRMirrorTextureDesc.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static OVRMirrorTextureDesc callocStack(MemoryStack stack) {
        return OVRMirrorTextureDesc.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return OVRMirrorTextureDesc.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return OVRMirrorTextureDesc.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return OVRMirrorTextureDesc.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return OVRMirrorTextureDesc.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nFormat(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FORMAT);
    }

    public static int nWidth(long struct) {
        return MemoryUtil.memGetInt(struct + (long)WIDTH);
    }

    public static int nHeight(long struct) {
        return MemoryUtil.memGetInt(struct + (long)HEIGHT);
    }

    public static int nMiscFlags(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MISCFLAGS);
    }

    public static void nFormat(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FORMAT, value);
    }

    public static void nWidth(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)WIDTH, value);
    }

    public static void nHeight(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)HEIGHT, value);
    }

    public static void nMiscFlags(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)MISCFLAGS, value);
    }

    static {
        Struct.Layout layout = OVRMirrorTextureDesc.__struct(OVRMirrorTextureDesc.__member(4), OVRMirrorTextureDesc.__member(4), OVRMirrorTextureDesc.__member(4), OVRMirrorTextureDesc.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        FORMAT = layout.offsetof(0);
        WIDTH = layout.offsetof(1);
        HEIGHT = layout.offsetof(2);
        MISCFLAGS = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<OVRMirrorTextureDesc, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected OVRMirrorTextureDesc newInstance(long address) {
            return new OVRMirrorTextureDesc(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="ovrTextureFormat")
        public int Format() {
            return OVRMirrorTextureDesc.nFormat(this.address());
        }

        public int Width() {
            return OVRMirrorTextureDesc.nWidth(this.address());
        }

        public int Height() {
            return OVRMirrorTextureDesc.nHeight(this.address());
        }

        @NativeType(value="unsigned int")
        public int MiscFlags() {
            return OVRMirrorTextureDesc.nMiscFlags(this.address());
        }

        public Buffer Format(@NativeType(value="ovrTextureFormat") int value) {
            OVRMirrorTextureDesc.nFormat(this.address(), value);
            return this;
        }

        public Buffer Width(int value) {
            OVRMirrorTextureDesc.nWidth(this.address(), value);
            return this;
        }

        public Buffer Height(int value) {
            OVRMirrorTextureDesc.nHeight(this.address(), value);
            return this;
        }

        public Buffer MiscFlags(@NativeType(value="unsigned int") int value) {
            OVRMirrorTextureDesc.nMiscFlags(this.address(), value);
            return this;
        }
    }
}

