/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.ovr.OVRLogCallback;
import org.lwjgl.ovr.OVRLogCallbackI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;

@NativeType(value="struct ovrInitParams")
public class OVRInitParams
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int FLAGS;
    public static final int REQUESTEDMINORVERSION;
    public static final int LOGCALLBACK;
    public static final int USERDATA;
    public static final int CONNECTIONTIMEOUTMS;

    OVRInitParams(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public OVRInitParams(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), OVRInitParams.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint32_t")
    public int Flags() {
        return OVRInitParams.nFlags(this.address());
    }

    @NativeType(value="uint32_t")
    public int RequestedMinorVersion() {
        return OVRInitParams.nRequestedMinorVersion(this.address());
    }

    @Nullable
    @NativeType(value="ovrLogCallback")
    public OVRLogCallback LogCallback() {
        return OVRInitParams.nLogCallback(this.address());
    }

    @NativeType(value="uintptr_t")
    public long UserData() {
        return OVRInitParams.nUserData(this.address());
    }

    @NativeType(value="uint32_t")
    public int ConnectionTimeoutMS() {
        return OVRInitParams.nConnectionTimeoutMS(this.address());
    }

    public OVRInitParams Flags(@NativeType(value="uint32_t") int value) {
        OVRInitParams.nFlags(this.address(), value);
        return this;
    }

    public OVRInitParams RequestedMinorVersion(@NativeType(value="uint32_t") int value) {
        OVRInitParams.nRequestedMinorVersion(this.address(), value);
        return this;
    }

    public OVRInitParams LogCallback(@Nullable @NativeType(value="ovrLogCallback") OVRLogCallbackI value) {
        OVRInitParams.nLogCallback(this.address(), value);
        return this;
    }

    public OVRInitParams UserData(@NativeType(value="uintptr_t") long value) {
        OVRInitParams.nUserData(this.address(), value);
        return this;
    }

    public OVRInitParams ConnectionTimeoutMS(@NativeType(value="uint32_t") int value) {
        OVRInitParams.nConnectionTimeoutMS(this.address(), value);
        return this;
    }

    public OVRInitParams set(int Flags, int RequestedMinorVersion, OVRLogCallbackI LogCallback, long UserData, int ConnectionTimeoutMS) {
        this.Flags(Flags);
        this.RequestedMinorVersion(RequestedMinorVersion);
        this.LogCallback(LogCallback);
        this.UserData(UserData);
        this.ConnectionTimeoutMS(ConnectionTimeoutMS);
        return this;
    }

    public OVRInitParams set(OVRInitParams src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static OVRInitParams malloc() {
        return OVRInitParams.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static OVRInitParams calloc() {
        return OVRInitParams.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static OVRInitParams create() {
        return new OVRInitParams(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static OVRInitParams create(long address) {
        return new OVRInitParams(address, null);
    }

    @Nullable
    public static OVRInitParams createSafe(long address) {
        return address == 0L ? null : OVRInitParams.create(address);
    }

    public static OVRInitParams mallocStack() {
        return OVRInitParams.mallocStack(MemoryStack.stackGet());
    }

    public static OVRInitParams callocStack() {
        return OVRInitParams.callocStack(MemoryStack.stackGet());
    }

    public static OVRInitParams mallocStack(MemoryStack stack) {
        return OVRInitParams.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static OVRInitParams callocStack(MemoryStack stack) {
        return OVRInitParams.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static int nFlags(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FLAGS);
    }

    public static int nRequestedMinorVersion(long struct) {
        return MemoryUtil.memGetInt(struct + (long)REQUESTEDMINORVERSION);
    }

    @Nullable
    public static OVRLogCallback nLogCallback(long struct) {
        return OVRLogCallback.createSafe(MemoryUtil.memGetAddress(struct + (long)LOGCALLBACK));
    }

    public static long nUserData(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)USERDATA);
    }

    public static int nConnectionTimeoutMS(long struct) {
        return MemoryUtil.memGetInt(struct + (long)CONNECTIONTIMEOUTMS);
    }

    public static void nFlags(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FLAGS, value);
    }

    public static void nRequestedMinorVersion(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)REQUESTEDMINORVERSION, value);
    }

    public static void nLogCallback(long struct, @Nullable OVRLogCallbackI value) {
        MemoryUtil.memPutAddress(struct + (long)LOGCALLBACK, MemoryUtil.memAddressSafe(value));
    }

    public static void nUserData(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)USERDATA, value);
    }

    public static void nConnectionTimeoutMS(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)CONNECTIONTIMEOUTMS, value);
    }

    static {
        Struct.Layout layout = OVRInitParams.__struct(OVRInitParams.__member(4), OVRInitParams.__member(4), OVRInitParams.__member(POINTER_SIZE), OVRInitParams.__member(POINTER_SIZE), OVRInitParams.__member(4), OVRInitParams.__padding(4, Pointer.BITS64));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        FLAGS = layout.offsetof(0);
        REQUESTEDMINORVERSION = layout.offsetof(1);
        LOGCALLBACK = layout.offsetof(2);
        USERDATA = layout.offsetof(3);
        CONNECTIONTIMEOUTMS = layout.offsetof(4);
    }
}

