/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct ovrHapticsClip")
public class OVRHapticsClip
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int SAMPLES;
    public static final int SAMPLESCOUNT;

    OVRHapticsClip(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public OVRHapticsClip(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), OVRHapticsClip.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="void const *")
    public ByteBuffer Samples(int capacity) {
        return OVRHapticsClip.nSamples(this.address(), capacity);
    }

    public int SamplesCount() {
        return OVRHapticsClip.nSamplesCount(this.address());
    }

    public static OVRHapticsClip malloc() {
        return OVRHapticsClip.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static OVRHapticsClip calloc() {
        return OVRHapticsClip.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static OVRHapticsClip create() {
        return new OVRHapticsClip(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static OVRHapticsClip create(long address) {
        return new OVRHapticsClip(address, null);
    }

    @Nullable
    public static OVRHapticsClip createSafe(long address) {
        return address == 0L ? null : OVRHapticsClip.create(address);
    }

    public static Buffer malloc(int capacity) {
        return OVRHapticsClip.create(OVRHapticsClip.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return OVRHapticsClip.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(OVRHapticsClip.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : OVRHapticsClip.create(address, capacity);
    }

    public static OVRHapticsClip mallocStack() {
        return OVRHapticsClip.mallocStack(MemoryStack.stackGet());
    }

    public static OVRHapticsClip callocStack() {
        return OVRHapticsClip.callocStack(MemoryStack.stackGet());
    }

    public static OVRHapticsClip mallocStack(MemoryStack stack) {
        return OVRHapticsClip.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static OVRHapticsClip callocStack(MemoryStack stack) {
        return OVRHapticsClip.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return OVRHapticsClip.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return OVRHapticsClip.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return OVRHapticsClip.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return OVRHapticsClip.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static ByteBuffer nSamples(long struct, int capacity) {
        return MemoryUtil.memByteBuffer(MemoryUtil.memGetAddress(struct + (long)SAMPLES), capacity);
    }

    public static int nSamplesCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SAMPLESCOUNT);
    }

    static {
        Struct.Layout layout = OVRHapticsClip.__struct(OVRHapticsClip.__member(POINTER_SIZE), OVRHapticsClip.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        SAMPLES = layout.offsetof(0);
        SAMPLESCOUNT = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<OVRHapticsClip, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected OVRHapticsClip newInstance(long address) {
            return new OVRHapticsClip(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="void const *")
        public ByteBuffer Samples(int capacity) {
            return OVRHapticsClip.nSamples(this.address(), capacity);
        }

        public int SamplesCount() {
            return OVRHapticsClip.nSamplesCount(this.address());
        }
    }
}

