/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct ovrHapticsBuffer")
public class OVRHapticsBuffer
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int SAMPLES;
    public static final int SAMPLESCOUNT;
    public static final int SUBMITMODE;

    OVRHapticsBuffer(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public OVRHapticsBuffer(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), OVRHapticsBuffer.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="void *")
    public ByteBuffer Samples(int capacity) {
        return OVRHapticsBuffer.nSamples(this.address(), capacity);
    }

    public int SamplesCount() {
        return OVRHapticsBuffer.nSamplesCount(this.address());
    }

    @NativeType(value="ovrHapticsBufferSubmitMode")
    public int SubmitMode() {
        return OVRHapticsBuffer.nSubmitMode(this.address());
    }

    public OVRHapticsBuffer Samples(@NativeType(value="void *") ByteBuffer value) {
        OVRHapticsBuffer.nSamples(this.address(), value);
        return this;
    }

    public OVRHapticsBuffer SamplesCount(int value) {
        OVRHapticsBuffer.nSamplesCount(this.address(), value);
        return this;
    }

    public OVRHapticsBuffer SubmitMode(@NativeType(value="ovrHapticsBufferSubmitMode") int value) {
        OVRHapticsBuffer.nSubmitMode(this.address(), value);
        return this;
    }

    public OVRHapticsBuffer set(ByteBuffer Samples, int SamplesCount, int SubmitMode) {
        this.Samples(Samples);
        this.SamplesCount(SamplesCount);
        this.SubmitMode(SubmitMode);
        return this;
    }

    public OVRHapticsBuffer set(OVRHapticsBuffer src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static OVRHapticsBuffer malloc() {
        return OVRHapticsBuffer.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static OVRHapticsBuffer calloc() {
        return OVRHapticsBuffer.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static OVRHapticsBuffer create() {
        return new OVRHapticsBuffer(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static OVRHapticsBuffer create(long address) {
        return new OVRHapticsBuffer(address, null);
    }

    @Nullable
    public static OVRHapticsBuffer createSafe(long address) {
        return address == 0L ? null : OVRHapticsBuffer.create(address);
    }

    public static Buffer malloc(int capacity) {
        return OVRHapticsBuffer.create(OVRHapticsBuffer.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return OVRHapticsBuffer.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(OVRHapticsBuffer.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : OVRHapticsBuffer.create(address, capacity);
    }

    public static OVRHapticsBuffer mallocStack() {
        return OVRHapticsBuffer.mallocStack(MemoryStack.stackGet());
    }

    public static OVRHapticsBuffer callocStack() {
        return OVRHapticsBuffer.callocStack(MemoryStack.stackGet());
    }

    public static OVRHapticsBuffer mallocStack(MemoryStack stack) {
        return OVRHapticsBuffer.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static OVRHapticsBuffer callocStack(MemoryStack stack) {
        return OVRHapticsBuffer.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return OVRHapticsBuffer.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return OVRHapticsBuffer.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return OVRHapticsBuffer.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return OVRHapticsBuffer.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static ByteBuffer nSamples(long struct, int capacity) {
        return MemoryUtil.memByteBuffer(MemoryUtil.memGetAddress(struct + (long)SAMPLES), capacity);
    }

    public static int nSamplesCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SAMPLESCOUNT);
    }

    public static int nSubmitMode(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SUBMITMODE);
    }

    public static void nSamples(long struct, ByteBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)SAMPLES, MemoryUtil.memAddress(value));
    }

    public static void nSamplesCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SAMPLESCOUNT, value);
    }

    public static void nSubmitMode(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SUBMITMODE, value);
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)SAMPLES));
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            OVRHapticsBuffer.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = OVRHapticsBuffer.__struct(OVRHapticsBuffer.__member(POINTER_SIZE), OVRHapticsBuffer.__member(4), OVRHapticsBuffer.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        SAMPLES = layout.offsetof(0);
        SAMPLESCOUNT = layout.offsetof(1);
        SUBMITMODE = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<OVRHapticsBuffer, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected OVRHapticsBuffer newInstance(long address) {
            return new OVRHapticsBuffer(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="void *")
        public ByteBuffer Samples(int capacity) {
            return OVRHapticsBuffer.nSamples(this.address(), capacity);
        }

        public int SamplesCount() {
            return OVRHapticsBuffer.nSamplesCount(this.address());
        }

        @NativeType(value="ovrHapticsBufferSubmitMode")
        public int SubmitMode() {
            return OVRHapticsBuffer.nSubmitMode(this.address());
        }

        public Buffer Samples(@NativeType(value="void *") ByteBuffer value) {
            OVRHapticsBuffer.nSamples(this.address(), value);
            return this;
        }

        public Buffer SamplesCount(int value) {
            OVRHapticsBuffer.nSamplesCount(this.address(), value);
            return this;
        }

        public Buffer SubmitMode(@NativeType(value="ovrHapticsBufferSubmitMode") int value) {
            OVRHapticsBuffer.nSubmitMode(this.address(), value);
            return this;
        }
    }
}

