/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.ovr.OVRPosef;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct ovrCameraExtrinsics")
public class OVRCameraExtrinsics
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int LASTCHANGEDTIMESECONDS;
    public static final int CAMERASTATUSFLAGS;
    public static final int ATTACHEDTODEVICE;
    public static final int RELATIVEPOSE;
    public static final int LASTEXPOSURETIMESECONDS;
    public static final int EXPOSURELATENCYSECONDS;
    public static final int ADDITIONALLATENCYSECONDS;

    OVRCameraExtrinsics(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public OVRCameraExtrinsics(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), OVRCameraExtrinsics.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public double LastChangedTimeSeconds() {
        return OVRCameraExtrinsics.nLastChangedTimeSeconds(this.address());
    }

    @NativeType(value="unsigned int")
    public int CameraStatusFlags() {
        return OVRCameraExtrinsics.nCameraStatusFlags(this.address());
    }

    @NativeType(value="ovrTrackedDeviceType")
    public int AttachedToDevice() {
        return OVRCameraExtrinsics.nAttachedToDevice(this.address());
    }

    @NativeType(value="ovrPosef")
    public OVRPosef RelativePose() {
        return OVRCameraExtrinsics.nRelativePose(this.address());
    }

    public OVRCameraExtrinsics RelativePose(Consumer<OVRPosef> consumer) {
        consumer.accept(this.RelativePose());
        return this;
    }

    public double LastExposureTimeSeconds() {
        return OVRCameraExtrinsics.nLastExposureTimeSeconds(this.address());
    }

    public double ExposureLatencySeconds() {
        return OVRCameraExtrinsics.nExposureLatencySeconds(this.address());
    }

    public double AdditionalLatencySeconds() {
        return OVRCameraExtrinsics.nAdditionalLatencySeconds(this.address());
    }

    public OVRCameraExtrinsics LastChangedTimeSeconds(double value) {
        OVRCameraExtrinsics.nLastChangedTimeSeconds(this.address(), value);
        return this;
    }

    public OVRCameraExtrinsics CameraStatusFlags(@NativeType(value="unsigned int") int value) {
        OVRCameraExtrinsics.nCameraStatusFlags(this.address(), value);
        return this;
    }

    public OVRCameraExtrinsics AttachedToDevice(@NativeType(value="ovrTrackedDeviceType") int value) {
        OVRCameraExtrinsics.nAttachedToDevice(this.address(), value);
        return this;
    }

    public OVRCameraExtrinsics RelativePose(@NativeType(value="ovrPosef") OVRPosef value) {
        OVRCameraExtrinsics.nRelativePose(this.address(), value);
        return this;
    }

    public OVRCameraExtrinsics LastExposureTimeSeconds(double value) {
        OVRCameraExtrinsics.nLastExposureTimeSeconds(this.address(), value);
        return this;
    }

    public OVRCameraExtrinsics ExposureLatencySeconds(double value) {
        OVRCameraExtrinsics.nExposureLatencySeconds(this.address(), value);
        return this;
    }

    public OVRCameraExtrinsics AdditionalLatencySeconds(double value) {
        OVRCameraExtrinsics.nAdditionalLatencySeconds(this.address(), value);
        return this;
    }

    public OVRCameraExtrinsics set(double LastChangedTimeSeconds, int CameraStatusFlags, int AttachedToDevice, OVRPosef RelativePose, double LastExposureTimeSeconds, double ExposureLatencySeconds, double AdditionalLatencySeconds) {
        this.LastChangedTimeSeconds(LastChangedTimeSeconds);
        this.CameraStatusFlags(CameraStatusFlags);
        this.AttachedToDevice(AttachedToDevice);
        this.RelativePose(RelativePose);
        this.LastExposureTimeSeconds(LastExposureTimeSeconds);
        this.ExposureLatencySeconds(ExposureLatencySeconds);
        this.AdditionalLatencySeconds(AdditionalLatencySeconds);
        return this;
    }

    public OVRCameraExtrinsics set(OVRCameraExtrinsics src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static OVRCameraExtrinsics malloc() {
        return OVRCameraExtrinsics.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static OVRCameraExtrinsics calloc() {
        return OVRCameraExtrinsics.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static OVRCameraExtrinsics create() {
        return new OVRCameraExtrinsics(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static OVRCameraExtrinsics create(long address) {
        return new OVRCameraExtrinsics(address, null);
    }

    @Nullable
    public static OVRCameraExtrinsics createSafe(long address) {
        return address == 0L ? null : OVRCameraExtrinsics.create(address);
    }

    public static Buffer malloc(int capacity) {
        return OVRCameraExtrinsics.create(OVRCameraExtrinsics.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return OVRCameraExtrinsics.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(OVRCameraExtrinsics.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : OVRCameraExtrinsics.create(address, capacity);
    }

    public static OVRCameraExtrinsics mallocStack() {
        return OVRCameraExtrinsics.mallocStack(MemoryStack.stackGet());
    }

    public static OVRCameraExtrinsics callocStack() {
        return OVRCameraExtrinsics.callocStack(MemoryStack.stackGet());
    }

    public static OVRCameraExtrinsics mallocStack(MemoryStack stack) {
        return OVRCameraExtrinsics.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static OVRCameraExtrinsics callocStack(MemoryStack stack) {
        return OVRCameraExtrinsics.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return OVRCameraExtrinsics.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return OVRCameraExtrinsics.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return OVRCameraExtrinsics.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return OVRCameraExtrinsics.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static double nLastChangedTimeSeconds(long struct) {
        return MemoryUtil.memGetDouble(struct + (long)LASTCHANGEDTIMESECONDS);
    }

    public static int nCameraStatusFlags(long struct) {
        return MemoryUtil.memGetInt(struct + (long)CAMERASTATUSFLAGS);
    }

    public static int nAttachedToDevice(long struct) {
        return MemoryUtil.memGetInt(struct + (long)ATTACHEDTODEVICE);
    }

    public static OVRPosef nRelativePose(long struct) {
        return OVRPosef.create(struct + (long)RELATIVEPOSE);
    }

    public static double nLastExposureTimeSeconds(long struct) {
        return MemoryUtil.memGetDouble(struct + (long)LASTEXPOSURETIMESECONDS);
    }

    public static double nExposureLatencySeconds(long struct) {
        return MemoryUtil.memGetDouble(struct + (long)EXPOSURELATENCYSECONDS);
    }

    public static double nAdditionalLatencySeconds(long struct) {
        return MemoryUtil.memGetDouble(struct + (long)ADDITIONALLATENCYSECONDS);
    }

    public static void nLastChangedTimeSeconds(long struct, double value) {
        MemoryUtil.memPutDouble(struct + (long)LASTCHANGEDTIMESECONDS, value);
    }

    public static void nCameraStatusFlags(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)CAMERASTATUSFLAGS, value);
    }

    public static void nAttachedToDevice(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)ATTACHEDTODEVICE, value);
    }

    public static void nRelativePose(long struct, OVRPosef value) {
        MemoryUtil.memCopy(value.address(), struct + (long)RELATIVEPOSE, OVRPosef.SIZEOF);
    }

    public static void nLastExposureTimeSeconds(long struct, double value) {
        MemoryUtil.memPutDouble(struct + (long)LASTEXPOSURETIMESECONDS, value);
    }

    public static void nExposureLatencySeconds(long struct, double value) {
        MemoryUtil.memPutDouble(struct + (long)EXPOSURELATENCYSECONDS, value);
    }

    public static void nAdditionalLatencySeconds(long struct, double value) {
        MemoryUtil.memPutDouble(struct + (long)ADDITIONALLATENCYSECONDS, value);
    }

    static {
        Struct.Layout layout = OVRCameraExtrinsics.__struct(OVRCameraExtrinsics.__member(8), OVRCameraExtrinsics.__member(4), OVRCameraExtrinsics.__member(4), OVRCameraExtrinsics.__member(OVRPosef.SIZEOF, OVRPosef.ALIGNOF), OVRCameraExtrinsics.__member(8), OVRCameraExtrinsics.__member(8), OVRCameraExtrinsics.__member(8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        LASTCHANGEDTIMESECONDS = layout.offsetof(0);
        CAMERASTATUSFLAGS = layout.offsetof(1);
        ATTACHEDTODEVICE = layout.offsetof(2);
        RELATIVEPOSE = layout.offsetof(3);
        LASTEXPOSURETIMESECONDS = layout.offsetof(4);
        EXPOSURELATENCYSECONDS = layout.offsetof(5);
        ADDITIONALLATENCYSECONDS = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<OVRCameraExtrinsics, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected OVRCameraExtrinsics newInstance(long address) {
            return new OVRCameraExtrinsics(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        public double LastChangedTimeSeconds() {
            return OVRCameraExtrinsics.nLastChangedTimeSeconds(this.address());
        }

        @NativeType(value="unsigned int")
        public int CameraStatusFlags() {
            return OVRCameraExtrinsics.nCameraStatusFlags(this.address());
        }

        @NativeType(value="ovrTrackedDeviceType")
        public int AttachedToDevice() {
            return OVRCameraExtrinsics.nAttachedToDevice(this.address());
        }

        @NativeType(value="ovrPosef")
        public OVRPosef RelativePose() {
            return OVRCameraExtrinsics.nRelativePose(this.address());
        }

        public Buffer RelativePose(Consumer<OVRPosef> consumer) {
            consumer.accept(this.RelativePose());
            return this;
        }

        public double LastExposureTimeSeconds() {
            return OVRCameraExtrinsics.nLastExposureTimeSeconds(this.address());
        }

        public double ExposureLatencySeconds() {
            return OVRCameraExtrinsics.nExposureLatencySeconds(this.address());
        }

        public double AdditionalLatencySeconds() {
            return OVRCameraExtrinsics.nAdditionalLatencySeconds(this.address());
        }

        public Buffer LastChangedTimeSeconds(double value) {
            OVRCameraExtrinsics.nLastChangedTimeSeconds(this.address(), value);
            return this;
        }

        public Buffer CameraStatusFlags(@NativeType(value="unsigned int") int value) {
            OVRCameraExtrinsics.nCameraStatusFlags(this.address(), value);
            return this;
        }

        public Buffer AttachedToDevice(@NativeType(value="ovrTrackedDeviceType") int value) {
            OVRCameraExtrinsics.nAttachedToDevice(this.address(), value);
            return this;
        }

        public Buffer RelativePose(@NativeType(value="ovrPosef") OVRPosef value) {
            OVRCameraExtrinsics.nRelativePose(this.address(), value);
            return this;
        }

        public Buffer LastExposureTimeSeconds(double value) {
            OVRCameraExtrinsics.nLastExposureTimeSeconds(this.address(), value);
            return this;
        }

        public Buffer ExposureLatencySeconds(double value) {
            OVRCameraExtrinsics.nExposureLatencySeconds(this.address(), value);
            return this;
        }

        public Buffer AdditionalLatencySeconds(double value) {
            OVRCameraExtrinsics.nAdditionalLatencySeconds(this.address(), value);
            return this;
        }
    }
}

