/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import javax.annotation.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.openvr.CameraVideoStreamFrameHeader;
import org.lwjgl.openvr.HmdMatrix44;
import org.lwjgl.openvr.HmdVector2;
import org.lwjgl.openvr.OpenVR;
import org.lwjgl.openvr.VRTextureBounds;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class VRTrackedCamera {
    protected VRTrackedCamera() {
        throw new UnsupportedOperationException();
    }

    public static long nVRTrackedCamera_GetCameraErrorNameFromEnum(int eCameraError) {
        long __functionAddress = OpenVR.VRTrackedCamera.GetCameraErrorNameFromEnum;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callP(__functionAddress, eCameraError);
    }

    @Nullable
    @NativeType(value="char const *")
    public static String VRTrackedCamera_GetCameraErrorNameFromEnum(@NativeType(value="EVRTrackedCameraError") int eCameraError) {
        long __result = VRTrackedCamera.nVRTrackedCamera_GetCameraErrorNameFromEnum(eCameraError);
        return MemoryUtil.memASCIISafe(__result);
    }

    public static int nVRTrackedCamera_HasCamera(int nDeviceIndex, long pHasCamera) {
        long __functionAddress = OpenVR.VRTrackedCamera.HasCamera;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPI(__functionAddress, nDeviceIndex, pHasCamera);
    }

    @NativeType(value="EVRTrackedCameraError")
    public static int VRTrackedCamera_HasCamera(@NativeType(value="TrackedDeviceIndex_t") int nDeviceIndex, @NativeType(value="bool *") ByteBuffer pHasCamera) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pHasCamera, 1);
        }
        return VRTrackedCamera.nVRTrackedCamera_HasCamera(nDeviceIndex, MemoryUtil.memAddress(pHasCamera));
    }

    public static int nVRTrackedCamera_GetCameraFrameSize(int nDeviceIndex, int eFrameType, long pnWidth, long pnHeight, long pnFrameBufferSize) {
        long __functionAddress = OpenVR.VRTrackedCamera.GetCameraFrameSize;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPPI(__functionAddress, nDeviceIndex, eFrameType, pnWidth, pnHeight, pnFrameBufferSize);
    }

    @NativeType(value="EVRTrackedCameraError")
    public static int VRTrackedCamera_GetCameraFrameSize(@NativeType(value="TrackedDeviceIndex_t") int nDeviceIndex, @NativeType(value="EVRTrackedCameraFrameType") int eFrameType, @NativeType(value="uint32_t *") IntBuffer pnWidth, @NativeType(value="uint32_t *") IntBuffer pnHeight, @NativeType(value="uint32_t *") IntBuffer pnFrameBufferSize) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pnWidth, 1);
            Checks.check((Buffer)pnHeight, 1);
            Checks.check((Buffer)pnFrameBufferSize, 1);
        }
        return VRTrackedCamera.nVRTrackedCamera_GetCameraFrameSize(nDeviceIndex, eFrameType, MemoryUtil.memAddress(pnWidth), MemoryUtil.memAddress(pnHeight), MemoryUtil.memAddress(pnFrameBufferSize));
    }

    public static int nVRTrackedCamera_GetCameraIntrinsics(int nDeviceIndex, int eFrameType, long pFocalLength, long pCenter) {
        long __functionAddress = OpenVR.VRTrackedCamera.GetCameraIntrinsics;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPI(__functionAddress, nDeviceIndex, eFrameType, pFocalLength, pCenter);
    }

    @NativeType(value="EVRTrackedCameraError")
    public static int VRTrackedCamera_GetCameraIntrinsics(@NativeType(value="TrackedDeviceIndex_t") int nDeviceIndex, @NativeType(value="EVRTrackedCameraFrameType") int eFrameType, @NativeType(value="HmdVector2_t *") HmdVector2.Buffer pFocalLength, @NativeType(value="HmdVector2_t *") HmdVector2.Buffer pCenter) {
        if (Checks.CHECKS) {
            Checks.check(pFocalLength, 1);
            Checks.check(pCenter, 1);
        }
        return VRTrackedCamera.nVRTrackedCamera_GetCameraIntrinsics(nDeviceIndex, eFrameType, pFocalLength.address(), pCenter.address());
    }

    public static int nVRTrackedCamera_GetCameraProjection(int nDeviceIndex, int eFrameType, float flZNear, float flZFar, long pProjection) {
        long __functionAddress = OpenVR.VRTrackedCamera.GetCameraProjection;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPI(__functionAddress, nDeviceIndex, eFrameType, flZNear, flZFar, pProjection);
    }

    @NativeType(value="EVRTrackedCameraError")
    public static int VRTrackedCamera_GetCameraProjection(@NativeType(value="TrackedDeviceIndex_t") int nDeviceIndex, @NativeType(value="EVRTrackedCameraFrameType") int eFrameType, float flZNear, float flZFar, @NativeType(value="HmdMatrix44_t *") HmdMatrix44 pProjection) {
        return VRTrackedCamera.nVRTrackedCamera_GetCameraProjection(nDeviceIndex, eFrameType, flZNear, flZFar, pProjection.address());
    }

    public static int nVRTrackedCamera_AcquireVideoStreamingService(int nDeviceIndex, long pHandle) {
        long __functionAddress = OpenVR.VRTrackedCamera.AcquireVideoStreamingService;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPI(__functionAddress, nDeviceIndex, pHandle);
    }

    @NativeType(value="EVRTrackedCameraError")
    public static int VRTrackedCamera_AcquireVideoStreamingService(@NativeType(value="TrackedDeviceIndex_t") int nDeviceIndex, @NativeType(value="TrackedCameraHandle_t *") LongBuffer pHandle) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pHandle, 1);
        }
        return VRTrackedCamera.nVRTrackedCamera_AcquireVideoStreamingService(nDeviceIndex, MemoryUtil.memAddress(pHandle));
    }

    @NativeType(value="EVRTrackedCameraError")
    public static int VRTrackedCamera_ReleaseVideoStreamingService(@NativeType(value="TrackedCameraHandle_t") long hTrackedCamera) {
        long __functionAddress = OpenVR.VRTrackedCamera.ReleaseVideoStreamingService;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callJI(__functionAddress, hTrackedCamera);
    }

    public static int nVRTrackedCamera_GetVideoStreamFrameBuffer(long hTrackedCamera, int eFrameType, long pFrameBuffer, int nFrameBufferSize, long pFrameHeader, int nFrameHeaderSize) {
        long __functionAddress = OpenVR.VRTrackedCamera.GetVideoStreamFrameBuffer;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callJPPI(__functionAddress, hTrackedCamera, eFrameType, pFrameBuffer, nFrameBufferSize, pFrameHeader, nFrameHeaderSize);
    }

    @NativeType(value="EVRTrackedCameraError")
    public static int VRTrackedCamera_GetVideoStreamFrameBuffer(@NativeType(value="TrackedCameraHandle_t") long hTrackedCamera, @NativeType(value="EVRTrackedCameraFrameType") int eFrameType, @NativeType(value="void *") ByteBuffer pFrameBuffer, @NativeType(value="CameraVideoStreamFrameHeader_t *") CameraVideoStreamFrameHeader pFrameHeader) {
        return VRTrackedCamera.nVRTrackedCamera_GetVideoStreamFrameBuffer(hTrackedCamera, eFrameType, MemoryUtil.memAddress(pFrameBuffer), pFrameBuffer.remaining(), pFrameHeader.address(), CameraVideoStreamFrameHeader.SIZEOF);
    }

    public static int nVRTrackedCamera_GetVideoStreamTextureSize(int nDeviceIndex, int eFrameType, long pTextureBounds, long pnWidth, long pnHeight) {
        long __functionAddress = OpenVR.VRTrackedCamera.GetVideoStreamTextureSize;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPPI(__functionAddress, nDeviceIndex, eFrameType, pTextureBounds, pnWidth, pnHeight);
    }

    @NativeType(value="EVRTrackedCameraError")
    public static int VRTrackedCamera_GetVideoStreamTextureSize(@NativeType(value="TrackedDeviceIndex_t") int nDeviceIndex, @NativeType(value="EVRTrackedCameraFrameType") int eFrameType, @NativeType(value="VRTextureBounds_t *") VRTextureBounds pTextureBounds, @NativeType(value="uint32_t *") IntBuffer pnWidth, @NativeType(value="uint32_t *") IntBuffer pnHeight) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pnWidth, 1);
            Checks.check((Buffer)pnHeight, 1);
        }
        return VRTrackedCamera.nVRTrackedCamera_GetVideoStreamTextureSize(nDeviceIndex, eFrameType, pTextureBounds.address(), MemoryUtil.memAddress(pnWidth), MemoryUtil.memAddress(pnHeight));
    }

    public static int nVRTrackedCamera_GetVideoStreamTextureD3D11(long hTrackedCamera, int eFrameType, long pD3D11DeviceOrResource, long ppD3D11ShaderResourceView, long pFrameHeader, int nFrameHeaderSize) {
        long __functionAddress = OpenVR.VRTrackedCamera.GetVideoStreamTextureD3D11;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(pD3D11DeviceOrResource);
        }
        return JNI.callJPPPI(__functionAddress, hTrackedCamera, eFrameType, pD3D11DeviceOrResource, ppD3D11ShaderResourceView, pFrameHeader, nFrameHeaderSize);
    }

    @NativeType(value="EVRTrackedCameraError")
    public static int VRTrackedCamera_GetVideoStreamTextureD3D11(@NativeType(value="TrackedCameraHandle_t") long hTrackedCamera, @NativeType(value="EVRTrackedCameraFrameType") int eFrameType, @NativeType(value="void *") long pD3D11DeviceOrResource, @NativeType(value="void **") PointerBuffer ppD3D11ShaderResourceView, @NativeType(value="CameraVideoStreamFrameHeader_t *") CameraVideoStreamFrameHeader pFrameHeader, @NativeType(value="uint32_t") int nFrameHeaderSize) {
        if (Checks.CHECKS) {
            Checks.check(ppD3D11ShaderResourceView, 1);
        }
        return VRTrackedCamera.nVRTrackedCamera_GetVideoStreamTextureD3D11(hTrackedCamera, eFrameType, pD3D11DeviceOrResource, MemoryUtil.memAddress(ppD3D11ShaderResourceView), pFrameHeader.address(), nFrameHeaderSize);
    }

    @NativeType(value="EVRTrackedCameraError")
    public static int VRTrackedCamera_GetVideoStreamTextureD3D11(@NativeType(value="TrackedCameraHandle_t") long hTrackedCamera, @NativeType(value="EVRTrackedCameraFrameType") int eFrameType, @NativeType(value="void *") long pD3D11DeviceOrResource, @NativeType(value="void **") PointerBuffer ppD3D11ShaderResourceView, @NativeType(value="CameraVideoStreamFrameHeader_t *") CameraVideoStreamFrameHeader pFrameHeader) {
        if (Checks.CHECKS) {
            Checks.check(ppD3D11ShaderResourceView, 1);
        }
        return VRTrackedCamera.nVRTrackedCamera_GetVideoStreamTextureD3D11(hTrackedCamera, eFrameType, pD3D11DeviceOrResource, MemoryUtil.memAddress(ppD3D11ShaderResourceView), pFrameHeader.address(), CameraVideoStreamFrameHeader.SIZEOF);
    }

    public static int nVRTrackedCamera_GetVideoStreamTextureGL(long hTrackedCamera, int eFrameType, long pglTextureId, long pFrameHeader, int nFrameHeaderSize) {
        long __functionAddress = OpenVR.VRTrackedCamera.GetVideoStreamTextureGL;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callJPPI(__functionAddress, hTrackedCamera, eFrameType, pglTextureId, pFrameHeader, nFrameHeaderSize);
    }

    @NativeType(value="EVRTrackedCameraError")
    public static int VRTrackedCamera_GetVideoStreamTextureGL(@NativeType(value="TrackedCameraHandle_t") long hTrackedCamera, @NativeType(value="EVRTrackedCameraFrameType") int eFrameType, @NativeType(value="glUInt_t *") IntBuffer pglTextureId, @NativeType(value="CameraVideoStreamFrameHeader_t *") CameraVideoStreamFrameHeader pFrameHeader, @NativeType(value="uint32_t") int nFrameHeaderSize) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pglTextureId, 1);
        }
        return VRTrackedCamera.nVRTrackedCamera_GetVideoStreamTextureGL(hTrackedCamera, eFrameType, MemoryUtil.memAddress(pglTextureId), pFrameHeader.address(), nFrameHeaderSize);
    }

    @NativeType(value="EVRTrackedCameraError")
    public static int VRTrackedCamera_GetVideoStreamTextureGL(@NativeType(value="TrackedCameraHandle_t") long hTrackedCamera, @NativeType(value="EVRTrackedCameraFrameType") int eFrameType, @NativeType(value="glUInt_t *") IntBuffer pglTextureId, @NativeType(value="CameraVideoStreamFrameHeader_t *") CameraVideoStreamFrameHeader pFrameHeader) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pglTextureId, 1);
        }
        return VRTrackedCamera.nVRTrackedCamera_GetVideoStreamTextureGL(hTrackedCamera, eFrameType, MemoryUtil.memAddress(pglTextureId), pFrameHeader.address(), CameraVideoStreamFrameHeader.SIZEOF);
    }

    @NativeType(value="EVRTrackedCameraError")
    public static int VRTrackedCamera_ReleaseVideoStreamTextureGL(@NativeType(value="TrackedCameraHandle_t") long hTrackedCamera, @NativeType(value="glUInt_t") int glTextureId) {
        long __functionAddress = OpenVR.VRTrackedCamera.ReleaseVideoStreamTextureGL;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callJI(__functionAddress, hTrackedCamera, glTextureId);
    }
}

