/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openvr.VRTextureDepthInfo;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct VRTextureWithDepth_t")
public class VRTextureWithDepth
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int DEPTH;

    VRTextureWithDepth(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VRTextureWithDepth(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VRTextureWithDepth.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VRTextureDepthInfo_t")
    public VRTextureDepthInfo depth() {
        return VRTextureWithDepth.ndepth(this.address());
    }

    public VRTextureWithDepth depth(Consumer<VRTextureDepthInfo> consumer) {
        consumer.accept(this.depth());
        return this;
    }

    public VRTextureWithDepth depth(@NativeType(value="VRTextureDepthInfo_t") VRTextureDepthInfo value) {
        VRTextureWithDepth.ndepth(this.address(), value);
        return this;
    }

    public VRTextureWithDepth set(VRTextureWithDepth src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VRTextureWithDepth malloc() {
        return VRTextureWithDepth.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VRTextureWithDepth calloc() {
        return VRTextureWithDepth.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VRTextureWithDepth create() {
        return new VRTextureWithDepth(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VRTextureWithDepth create(long address) {
        return new VRTextureWithDepth(address, null);
    }

    @Nullable
    public static VRTextureWithDepth createSafe(long address) {
        return address == 0L ? null : VRTextureWithDepth.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VRTextureWithDepth.create(VRTextureWithDepth.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VRTextureWithDepth.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VRTextureWithDepth.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VRTextureWithDepth.create(address, capacity);
    }

    public static VRTextureWithDepth mallocStack() {
        return VRTextureWithDepth.mallocStack(MemoryStack.stackGet());
    }

    public static VRTextureWithDepth callocStack() {
        return VRTextureWithDepth.callocStack(MemoryStack.stackGet());
    }

    public static VRTextureWithDepth mallocStack(MemoryStack stack) {
        return VRTextureWithDepth.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VRTextureWithDepth callocStack(MemoryStack stack) {
        return VRTextureWithDepth.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VRTextureWithDepth.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VRTextureWithDepth.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VRTextureWithDepth.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VRTextureWithDepth.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static VRTextureDepthInfo ndepth(long struct) {
        return VRTextureDepthInfo.create(struct + (long)DEPTH);
    }

    public static void ndepth(long struct, VRTextureDepthInfo value) {
        MemoryUtil.memCopy(value.address(), struct + (long)DEPTH, VRTextureDepthInfo.SIZEOF);
    }

    public static void validate(long struct) {
        VRTextureDepthInfo.validate(struct + (long)DEPTH);
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            VRTextureWithDepth.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = VRTextureWithDepth.__struct(VRTextureWithDepth.__member(VRTextureDepthInfo.SIZEOF, VRTextureDepthInfo.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        DEPTH = layout.offsetof(0);
    }

    public static class Buffer
    extends StructBuffer<VRTextureWithDepth, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VRTextureWithDepth newInstance(long address) {
            return new VRTextureWithDepth(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="VRTextureDepthInfo_t")
        public VRTextureDepthInfo depth() {
            return VRTextureWithDepth.ndepth(this.address());
        }

        public Buffer depth(Consumer<VRTextureDepthInfo> consumer) {
            consumer.accept(this.depth());
            return this;
        }

        public Buffer depth(@NativeType(value="VRTextureDepthInfo_t") VRTextureDepthInfo value) {
            VRTextureWithDepth.ndepth(this.address(), value);
            return this;
        }
    }
}

