/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.openvr.OpenVR;
import org.lwjgl.openvr.SpatialAnchorPose;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class VRSpatialAnchors {
    protected VRSpatialAnchors() {
        throw new UnsupportedOperationException();
    }

    public static int nVRSpatialAnchors_CreateSpatialAnchorFromDescriptor(long pchDescriptor, long pHandleOut) {
        long __functionAddress = OpenVR.VRSpatialAnchors.CreateSpatialAnchorFromDescriptor;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPI(__functionAddress, pchDescriptor, pHandleOut);
    }

    @NativeType(value="EVRSpatialAnchorError")
    public static int VRSpatialAnchors_CreateSpatialAnchorFromDescriptor(@NativeType(value="char const *") ByteBuffer pchDescriptor, @NativeType(value="SpatialAnchorHandle_t *") IntBuffer pHandleOut) {
        if (Checks.CHECKS) {
            Checks.checkNT1(pchDescriptor);
            Checks.check((Buffer)pHandleOut, 1);
        }
        return VRSpatialAnchors.nVRSpatialAnchors_CreateSpatialAnchorFromDescriptor(MemoryUtil.memAddress(pchDescriptor), MemoryUtil.memAddress(pHandleOut));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="EVRSpatialAnchorError")
    public static int VRSpatialAnchors_CreateSpatialAnchorFromDescriptor(@NativeType(value="char const *") CharSequence pchDescriptor, @NativeType(value="SpatialAnchorHandle_t *") IntBuffer pHandleOut) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pHandleOut, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer pchDescriptorEncoded = stack.ASCII(pchDescriptor);
            int n = VRSpatialAnchors.nVRSpatialAnchors_CreateSpatialAnchorFromDescriptor(MemoryUtil.memAddress(pchDescriptorEncoded), MemoryUtil.memAddress(pHandleOut));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nVRSpatialAnchors_CreateSpatialAnchorFromPose(int unDeviceIndex, int eOrigin, long pPose, long pHandleOut) {
        long __functionAddress = OpenVR.VRSpatialAnchors.CreateSpatialAnchorFromPose;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPI(__functionAddress, unDeviceIndex, eOrigin, pPose, pHandleOut);
    }

    @NativeType(value="EVRSpatialAnchorError")
    public static int VRSpatialAnchors_CreateSpatialAnchorFromPose(@NativeType(value="TrackedDeviceIndex_t") int unDeviceIndex, @NativeType(value="ETrackingUniverseOrigin") int eOrigin, @NativeType(value="SpatialAnchorPose_t *") SpatialAnchorPose pPose, @NativeType(value="SpatialAnchorHandle_t *") IntBuffer pHandleOut) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pHandleOut, 1);
        }
        return VRSpatialAnchors.nVRSpatialAnchors_CreateSpatialAnchorFromPose(unDeviceIndex, eOrigin, pPose.address(), MemoryUtil.memAddress(pHandleOut));
    }

    public static int nVRSpatialAnchors_GetSpatialAnchorPose(int unHandle, int eOrigin, long pPoseOut) {
        long __functionAddress = OpenVR.VRSpatialAnchors.GetSpatialAnchorPose;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPI(__functionAddress, unHandle, eOrigin, pPoseOut);
    }

    @NativeType(value="EVRSpatialAnchorError")
    public static int VRSpatialAnchors_GetSpatialAnchorPose(@NativeType(value="SpatialAnchorHandle_t") int unHandle, @NativeType(value="ETrackingUniverseOrigin") int eOrigin, @NativeType(value="SpatialAnchorPose_t *") SpatialAnchorPose pPoseOut) {
        return VRSpatialAnchors.nVRSpatialAnchors_GetSpatialAnchorPose(unHandle, eOrigin, pPoseOut.address());
    }

    public static int nVRSpatialAnchors_GetSpatialAnchorDescriptor(int unHandle, long pchDescriptorOut, long punDescriptorBufferLenInOut) {
        long __functionAddress = OpenVR.VRSpatialAnchors.GetSpatialAnchorDescriptor;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPI(__functionAddress, unHandle, pchDescriptorOut, punDescriptorBufferLenInOut);
    }

    @NativeType(value="EVRSpatialAnchorError")
    public static int VRSpatialAnchors_GetSpatialAnchorDescriptor(@NativeType(value="SpatialAnchorHandle_t") int unHandle, @NativeType(value="char *") ByteBuffer pchDescriptorOut, @NativeType(value="uint32_t *") IntBuffer punDescriptorBufferLenInOut) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)punDescriptorBufferLenInOut, 1);
            Checks.check((Buffer)pchDescriptorOut, punDescriptorBufferLenInOut.get(punDescriptorBufferLenInOut.position()));
        }
        return VRSpatialAnchors.nVRSpatialAnchors_GetSpatialAnchorDescriptor(unHandle, MemoryUtil.memAddress(pchDescriptorOut), MemoryUtil.memAddress(punDescriptorBufferLenInOut));
    }
}

