/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.openvr.OpenVR;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class VRSettings {
    protected VRSettings() {
        throw new UnsupportedOperationException();
    }

    public static long nVRSettings_GetSettingsErrorNameFromEnum(int eError) {
        long __functionAddress = OpenVR.VRSettings.GetSettingsErrorNameFromEnum;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callP(__functionAddress, eError);
    }

    @Nullable
    @NativeType(value="char const *")
    public static String VRSettings_GetSettingsErrorNameFromEnum(@NativeType(value="EVRSettingsError") int eError) {
        long __result = VRSettings.nVRSettings_GetSettingsErrorNameFromEnum(eError);
        return MemoryUtil.memASCIISafe(__result);
    }

    public static boolean nVRSettings_Sync(boolean bForce, long peError) {
        long __functionAddress = OpenVR.VRSettings.Sync;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPZ(__functionAddress, bForce, peError);
    }

    @NativeType(value="bool")
    public static boolean VRSettings_Sync(@NativeType(value="bool") boolean bForce, @NativeType(value="EVRSettingsError *") IntBuffer peError) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)peError, 1);
        }
        return VRSettings.nVRSettings_Sync(bForce, MemoryUtil.memAddress(peError));
    }

    public static void nVRSettings_SetBool(long pchSection, long pchSettingsKey, boolean bValue, long peError) {
        long __functionAddress = OpenVR.VRSettings.SetBool;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPPPV(__functionAddress, pchSection, pchSettingsKey, bValue, peError);
    }

    public static void VRSettings_SetBool(@NativeType(value="char const *") ByteBuffer pchSection, @NativeType(value="char const *") ByteBuffer pchSettingsKey, @NativeType(value="bool") boolean bValue, @NativeType(value="EVRSettingsError *") IntBuffer peError) {
        if (Checks.CHECKS) {
            Checks.checkNT1(pchSection);
            Checks.checkNT1(pchSettingsKey);
            Checks.check((Buffer)peError, 1);
        }
        VRSettings.nVRSettings_SetBool(MemoryUtil.memAddress(pchSection), MemoryUtil.memAddress(pchSettingsKey), bValue, MemoryUtil.memAddress(peError));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void VRSettings_SetBool(@NativeType(value="char const *") CharSequence pchSection, @NativeType(value="char const *") CharSequence pchSettingsKey, @NativeType(value="bool") boolean bValue, @NativeType(value="EVRSettingsError *") IntBuffer peError) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)peError, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer pchSectionEncoded = stack.ASCII(pchSection);
            ByteBuffer pchSettingsKeyEncoded = stack.ASCII(pchSettingsKey);
            VRSettings.nVRSettings_SetBool(MemoryUtil.memAddress(pchSectionEncoded), MemoryUtil.memAddress(pchSettingsKeyEncoded), bValue, MemoryUtil.memAddress(peError));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nVRSettings_SetInt32(long pchSection, long pchSettingsKey, int nValue, long peError) {
        long __functionAddress = OpenVR.VRSettings.SetInt32;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPPPV(__functionAddress, pchSection, pchSettingsKey, nValue, peError);
    }

    public static void VRSettings_SetInt32(@NativeType(value="char const *") ByteBuffer pchSection, @NativeType(value="char const *") ByteBuffer pchSettingsKey, @NativeType(value="int32_t") int nValue, @NativeType(value="EVRSettingsError *") IntBuffer peError) {
        if (Checks.CHECKS) {
            Checks.checkNT1(pchSection);
            Checks.checkNT1(pchSettingsKey);
            Checks.check((Buffer)peError, 1);
        }
        VRSettings.nVRSettings_SetInt32(MemoryUtil.memAddress(pchSection), MemoryUtil.memAddress(pchSettingsKey), nValue, MemoryUtil.memAddress(peError));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void VRSettings_SetInt32(@NativeType(value="char const *") CharSequence pchSection, @NativeType(value="char const *") CharSequence pchSettingsKey, @NativeType(value="int32_t") int nValue, @NativeType(value="EVRSettingsError *") IntBuffer peError) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)peError, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer pchSectionEncoded = stack.ASCII(pchSection);
            ByteBuffer pchSettingsKeyEncoded = stack.ASCII(pchSettingsKey);
            VRSettings.nVRSettings_SetInt32(MemoryUtil.memAddress(pchSectionEncoded), MemoryUtil.memAddress(pchSettingsKeyEncoded), nValue, MemoryUtil.memAddress(peError));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nVRSettings_SetFloat(long pchSection, long pchSettingsKey, float flValue, long peError) {
        long __functionAddress = OpenVR.VRSettings.SetFloat;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPPPV(__functionAddress, pchSection, pchSettingsKey, flValue, peError);
    }

    public static void VRSettings_SetFloat(@NativeType(value="char const *") ByteBuffer pchSection, @NativeType(value="char const *") ByteBuffer pchSettingsKey, float flValue, @NativeType(value="EVRSettingsError *") IntBuffer peError) {
        if (Checks.CHECKS) {
            Checks.checkNT1(pchSection);
            Checks.checkNT1(pchSettingsKey);
            Checks.check((Buffer)peError, 1);
        }
        VRSettings.nVRSettings_SetFloat(MemoryUtil.memAddress(pchSection), MemoryUtil.memAddress(pchSettingsKey), flValue, MemoryUtil.memAddress(peError));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void VRSettings_SetFloat(@NativeType(value="char const *") CharSequence pchSection, @NativeType(value="char const *") CharSequence pchSettingsKey, float flValue, @NativeType(value="EVRSettingsError *") IntBuffer peError) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)peError, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer pchSectionEncoded = stack.ASCII(pchSection);
            ByteBuffer pchSettingsKeyEncoded = stack.ASCII(pchSettingsKey);
            VRSettings.nVRSettings_SetFloat(MemoryUtil.memAddress(pchSectionEncoded), MemoryUtil.memAddress(pchSettingsKeyEncoded), flValue, MemoryUtil.memAddress(peError));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nVRSettings_SetString(long pchSection, long pchSettingsKey, long pchValue, long peError) {
        long __functionAddress = OpenVR.VRSettings.SetString;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPPPPV(__functionAddress, pchSection, pchSettingsKey, pchValue, peError);
    }

    public static void VRSettings_SetString(@NativeType(value="char const *") ByteBuffer pchSection, @NativeType(value="char const *") ByteBuffer pchSettingsKey, @NativeType(value="char const *") ByteBuffer pchValue, @NativeType(value="EVRSettingsError *") IntBuffer peError) {
        if (Checks.CHECKS) {
            Checks.checkNT1(pchSection);
            Checks.checkNT1(pchSettingsKey);
            Checks.checkNT1(pchValue);
            Checks.check((Buffer)peError, 1);
        }
        VRSettings.nVRSettings_SetString(MemoryUtil.memAddress(pchSection), MemoryUtil.memAddress(pchSettingsKey), MemoryUtil.memAddress(pchValue), MemoryUtil.memAddress(peError));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void VRSettings_SetString(@NativeType(value="char const *") CharSequence pchSection, @NativeType(value="char const *") CharSequence pchSettingsKey, @NativeType(value="char const *") CharSequence pchValue, @NativeType(value="EVRSettingsError *") IntBuffer peError) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)peError, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer pchSectionEncoded = stack.ASCII(pchSection);
            ByteBuffer pchSettingsKeyEncoded = stack.ASCII(pchSettingsKey);
            ByteBuffer pchValueEncoded = stack.ASCII(pchValue);
            VRSettings.nVRSettings_SetString(MemoryUtil.memAddress(pchSectionEncoded), MemoryUtil.memAddress(pchSettingsKeyEncoded), MemoryUtil.memAddress(pchValueEncoded), MemoryUtil.memAddress(peError));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static boolean nVRSettings_GetBool(long pchSection, long pchSettingsKey, long peError) {
        long __functionAddress = OpenVR.VRSettings.GetBool;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPPZ(__functionAddress, pchSection, pchSettingsKey, peError);
    }

    @NativeType(value="bool")
    public static boolean VRSettings_GetBool(@NativeType(value="char const *") ByteBuffer pchSection, @NativeType(value="char const *") ByteBuffer pchSettingsKey, @NativeType(value="EVRSettingsError *") IntBuffer peError) {
        if (Checks.CHECKS) {
            Checks.checkNT1(pchSection);
            Checks.checkNT1(pchSettingsKey);
            Checks.check((Buffer)peError, 1);
        }
        return VRSettings.nVRSettings_GetBool(MemoryUtil.memAddress(pchSection), MemoryUtil.memAddress(pchSettingsKey), MemoryUtil.memAddress(peError));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="bool")
    public static boolean VRSettings_GetBool(@NativeType(value="char const *") CharSequence pchSection, @NativeType(value="char const *") CharSequence pchSettingsKey, @NativeType(value="EVRSettingsError *") IntBuffer peError) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)peError, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer pchSectionEncoded = stack.ASCII(pchSection);
            ByteBuffer pchSettingsKeyEncoded = stack.ASCII(pchSettingsKey);
            boolean bl = VRSettings.nVRSettings_GetBool(MemoryUtil.memAddress(pchSectionEncoded), MemoryUtil.memAddress(pchSettingsKeyEncoded), MemoryUtil.memAddress(peError));
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nVRSettings_GetInt32(long pchSection, long pchSettingsKey, long peError) {
        long __functionAddress = OpenVR.VRSettings.GetInt32;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPPI(__functionAddress, pchSection, pchSettingsKey, peError);
    }

    @NativeType(value="int32_t")
    public static int VRSettings_GetInt32(@NativeType(value="char const *") ByteBuffer pchSection, @NativeType(value="char const *") ByteBuffer pchSettingsKey, @NativeType(value="EVRSettingsError *") IntBuffer peError) {
        if (Checks.CHECKS) {
            Checks.checkNT1(pchSection);
            Checks.checkNT1(pchSettingsKey);
            Checks.check((Buffer)peError, 1);
        }
        return VRSettings.nVRSettings_GetInt32(MemoryUtil.memAddress(pchSection), MemoryUtil.memAddress(pchSettingsKey), MemoryUtil.memAddress(peError));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="int32_t")
    public static int VRSettings_GetInt32(@NativeType(value="char const *") CharSequence pchSection, @NativeType(value="char const *") CharSequence pchSettingsKey, @NativeType(value="EVRSettingsError *") IntBuffer peError) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)peError, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer pchSectionEncoded = stack.ASCII(pchSection);
            ByteBuffer pchSettingsKeyEncoded = stack.ASCII(pchSettingsKey);
            int n = VRSettings.nVRSettings_GetInt32(MemoryUtil.memAddress(pchSectionEncoded), MemoryUtil.memAddress(pchSettingsKeyEncoded), MemoryUtil.memAddress(peError));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static float nVRSettings_GetFloat(long pchSection, long pchSettingsKey, long peError) {
        long __functionAddress = OpenVR.VRSettings.GetFloat;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPPF(__functionAddress, pchSection, pchSettingsKey, peError);
    }

    public static float VRSettings_GetFloat(@NativeType(value="char const *") ByteBuffer pchSection, @NativeType(value="char const *") ByteBuffer pchSettingsKey, @NativeType(value="EVRSettingsError *") IntBuffer peError) {
        if (Checks.CHECKS) {
            Checks.checkNT1(pchSection);
            Checks.checkNT1(pchSettingsKey);
            Checks.check((Buffer)peError, 1);
        }
        return VRSettings.nVRSettings_GetFloat(MemoryUtil.memAddress(pchSection), MemoryUtil.memAddress(pchSettingsKey), MemoryUtil.memAddress(peError));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static float VRSettings_GetFloat(@NativeType(value="char const *") CharSequence pchSection, @NativeType(value="char const *") CharSequence pchSettingsKey, @NativeType(value="EVRSettingsError *") IntBuffer peError) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)peError, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer pchSectionEncoded = stack.ASCII(pchSection);
            ByteBuffer pchSettingsKeyEncoded = stack.ASCII(pchSettingsKey);
            float f = VRSettings.nVRSettings_GetFloat(MemoryUtil.memAddress(pchSectionEncoded), MemoryUtil.memAddress(pchSettingsKeyEncoded), MemoryUtil.memAddress(peError));
            return f;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nVRSettings_GetString(long pchSection, long pchSettingsKey, long pchValue, int unValueLen, long peError) {
        long __functionAddress = OpenVR.VRSettings.GetString;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPPPPV(__functionAddress, pchSection, pchSettingsKey, pchValue, unValueLen, peError);
    }

    public static void VRSettings_GetString(@NativeType(value="char const *") ByteBuffer pchSection, @NativeType(value="char const *") ByteBuffer pchSettingsKey, @NativeType(value="char *") ByteBuffer pchValue, @NativeType(value="EVRSettingsError *") IntBuffer peError) {
        if (Checks.CHECKS) {
            Checks.checkNT1(pchSection);
            Checks.checkNT1(pchSettingsKey);
            Checks.check((Buffer)peError, 1);
        }
        VRSettings.nVRSettings_GetString(MemoryUtil.memAddress(pchSection), MemoryUtil.memAddress(pchSettingsKey), MemoryUtil.memAddress(pchValue), pchValue.remaining(), MemoryUtil.memAddress(peError));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void VRSettings_GetString(@NativeType(value="char const *") CharSequence pchSection, @NativeType(value="char const *") CharSequence pchSettingsKey, @NativeType(value="char *") ByteBuffer pchValue, @NativeType(value="EVRSettingsError *") IntBuffer peError) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)peError, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer pchSectionEncoded = stack.ASCII(pchSection);
            ByteBuffer pchSettingsKeyEncoded = stack.ASCII(pchSettingsKey);
            VRSettings.nVRSettings_GetString(MemoryUtil.memAddress(pchSectionEncoded), MemoryUtil.memAddress(pchSettingsKeyEncoded), MemoryUtil.memAddress(pchValue), pchValue.remaining(), MemoryUtil.memAddress(peError));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nVRSettings_RemoveSection(long pchSection, long peError) {
        long __functionAddress = OpenVR.VRSettings.RemoveSection;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPPV(__functionAddress, pchSection, peError);
    }

    public static void VRSettings_RemoveSection(@NativeType(value="char const *") ByteBuffer pchSection, @NativeType(value="EVRSettingsError *") IntBuffer peError) {
        if (Checks.CHECKS) {
            Checks.checkNT1(pchSection);
            Checks.check((Buffer)peError, 1);
        }
        VRSettings.nVRSettings_RemoveSection(MemoryUtil.memAddress(pchSection), MemoryUtil.memAddress(peError));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void VRSettings_RemoveSection(@NativeType(value="char const *") CharSequence pchSection, @NativeType(value="EVRSettingsError *") IntBuffer peError) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)peError, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer pchSectionEncoded = stack.ASCII(pchSection);
            VRSettings.nVRSettings_RemoveSection(MemoryUtil.memAddress(pchSectionEncoded), MemoryUtil.memAddress(peError));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nVRSettings_RemoveKeyInSection(long pchSection, long pchSettingsKey, long peError) {
        long __functionAddress = OpenVR.VRSettings.RemoveKeyInSection;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPPPV(__functionAddress, pchSection, pchSettingsKey, peError);
    }

    public static void VRSettings_RemoveKeyInSection(@NativeType(value="char const *") ByteBuffer pchSection, @NativeType(value="char const *") ByteBuffer pchSettingsKey, @NativeType(value="EVRSettingsError *") IntBuffer peError) {
        if (Checks.CHECKS) {
            Checks.checkNT1(pchSection);
            Checks.checkNT1(pchSettingsKey);
            Checks.check((Buffer)peError, 1);
        }
        VRSettings.nVRSettings_RemoveKeyInSection(MemoryUtil.memAddress(pchSection), MemoryUtil.memAddress(pchSettingsKey), MemoryUtil.memAddress(peError));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void VRSettings_RemoveKeyInSection(@NativeType(value="char const *") CharSequence pchSection, @NativeType(value="char const *") CharSequence pchSettingsKey, @NativeType(value="EVRSettingsError *") IntBuffer peError) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)peError, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer pchSectionEncoded = stack.ASCII(pchSection);
            ByteBuffer pchSettingsKeyEncoded = stack.ASCII(pchSettingsKey);
            VRSettings.nVRSettings_RemoveKeyInSection(MemoryUtil.memAddress(pchSectionEncoded), MemoryUtil.memAddress(pchSettingsKeyEncoded), MemoryUtil.memAddress(peError));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }
}

