/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openvr.HmdVector2;
import org.lwjgl.openvr.HmdVector3;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct VROverlayIntersectionResults_t")
public class VROverlayIntersectionResults
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int VPOINT;
    public static final int VNORMAL;
    public static final int VUVS;
    public static final int FDISTANCE;

    VROverlayIntersectionResults(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VROverlayIntersectionResults(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VROverlayIntersectionResults.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="HmdVector3_t")
    public HmdVector3 vPoint() {
        return VROverlayIntersectionResults.nvPoint(this.address());
    }

    public VROverlayIntersectionResults vPoint(Consumer<HmdVector3> consumer) {
        consumer.accept(this.vPoint());
        return this;
    }

    @NativeType(value="HmdVector3_t")
    public HmdVector3 vNormal() {
        return VROverlayIntersectionResults.nvNormal(this.address());
    }

    public VROverlayIntersectionResults vNormal(Consumer<HmdVector3> consumer) {
        consumer.accept(this.vNormal());
        return this;
    }

    @NativeType(value="HmdVector2_t")
    public HmdVector2 vUVs() {
        return VROverlayIntersectionResults.nvUVs(this.address());
    }

    public VROverlayIntersectionResults vUVs(Consumer<HmdVector2> consumer) {
        consumer.accept(this.vUVs());
        return this;
    }

    public float fDistance() {
        return VROverlayIntersectionResults.nfDistance(this.address());
    }

    public static VROverlayIntersectionResults malloc() {
        return VROverlayIntersectionResults.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VROverlayIntersectionResults calloc() {
        return VROverlayIntersectionResults.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VROverlayIntersectionResults create() {
        return new VROverlayIntersectionResults(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VROverlayIntersectionResults create(long address) {
        return new VROverlayIntersectionResults(address, null);
    }

    @Nullable
    public static VROverlayIntersectionResults createSafe(long address) {
        return address == 0L ? null : VROverlayIntersectionResults.create(address);
    }

    public static Buffer malloc(int capacity) {
        return VROverlayIntersectionResults.create(VROverlayIntersectionResults.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VROverlayIntersectionResults.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(VROverlayIntersectionResults.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VROverlayIntersectionResults.create(address, capacity);
    }

    public static VROverlayIntersectionResults mallocStack() {
        return VROverlayIntersectionResults.mallocStack(MemoryStack.stackGet());
    }

    public static VROverlayIntersectionResults callocStack() {
        return VROverlayIntersectionResults.callocStack(MemoryStack.stackGet());
    }

    public static VROverlayIntersectionResults mallocStack(MemoryStack stack) {
        return VROverlayIntersectionResults.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VROverlayIntersectionResults callocStack(MemoryStack stack) {
        return VROverlayIntersectionResults.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VROverlayIntersectionResults.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VROverlayIntersectionResults.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VROverlayIntersectionResults.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VROverlayIntersectionResults.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static HmdVector3 nvPoint(long struct) {
        return HmdVector3.create(struct + (long)VPOINT);
    }

    public static HmdVector3 nvNormal(long struct) {
        return HmdVector3.create(struct + (long)VNORMAL);
    }

    public static HmdVector2 nvUVs(long struct) {
        return HmdVector2.create(struct + (long)VUVS);
    }

    public static float nfDistance(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)FDISTANCE);
    }

    static {
        Struct.Layout layout = VROverlayIntersectionResults.__struct(VROverlayIntersectionResults.__member(HmdVector3.SIZEOF, HmdVector3.ALIGNOF), VROverlayIntersectionResults.__member(HmdVector3.SIZEOF, HmdVector3.ALIGNOF), VROverlayIntersectionResults.__member(HmdVector2.SIZEOF, HmdVector2.ALIGNOF), VROverlayIntersectionResults.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        VPOINT = layout.offsetof(0);
        VNORMAL = layout.offsetof(1);
        VUVS = layout.offsetof(2);
        FDISTANCE = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VROverlayIntersectionResults, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VROverlayIntersectionResults newInstance(long address) {
            return new VROverlayIntersectionResults(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="HmdVector3_t")
        public HmdVector3 vPoint() {
            return VROverlayIntersectionResults.nvPoint(this.address());
        }

        public Buffer vPoint(Consumer<HmdVector3> consumer) {
            consumer.accept(this.vPoint());
            return this;
        }

        @NativeType(value="HmdVector3_t")
        public HmdVector3 vNormal() {
            return VROverlayIntersectionResults.nvNormal(this.address());
        }

        public Buffer vNormal(Consumer<HmdVector3> consumer) {
            consumer.accept(this.vNormal());
            return this;
        }

        @NativeType(value="HmdVector2_t")
        public HmdVector2 vUVs() {
            return VROverlayIntersectionResults.nvUVs(this.address());
        }

        public Buffer vUVs(Consumer<HmdVector2> consumer) {
            consumer.accept(this.vUVs());
            return this;
        }

        public float fDistance() {
            return VROverlayIntersectionResults.nfDistance(this.address());
        }
    }
}

