/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import org.lwjgl.openvr.OpenVR;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class VRIOBuffer {
    protected VRIOBuffer() {
        throw new UnsupportedOperationException();
    }

    public static int nVRIOBuffer_Open(long pchPath, int mode, int unElementSize, int unElements, long pulBuffer) {
        long __functionAddress = OpenVR.VRIOBuffer.Open;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPI(__functionAddress, pchPath, mode, unElementSize, unElements, pulBuffer);
    }

    @NativeType(value="EIOBufferError")
    public static int VRIOBuffer_Open(@NativeType(value="char const *") ByteBuffer pchPath, @NativeType(value="EIOBufferMode") int mode, @NativeType(value="uint32_t") int unElementSize, @NativeType(value="uint32_t") int unElements, @NativeType(value="IOBufferHandle_t *") LongBuffer pulBuffer) {
        if (Checks.CHECKS) {
            Checks.checkNT1(pchPath);
            Checks.check((Buffer)pulBuffer, 1);
        }
        return VRIOBuffer.nVRIOBuffer_Open(MemoryUtil.memAddress(pchPath), mode, unElementSize, unElements, MemoryUtil.memAddress(pulBuffer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="EIOBufferError")
    public static int VRIOBuffer_Open(@NativeType(value="char const *") CharSequence pchPath, @NativeType(value="EIOBufferMode") int mode, @NativeType(value="uint32_t") int unElementSize, @NativeType(value="uint32_t") int unElements, @NativeType(value="IOBufferHandle_t *") LongBuffer pulBuffer) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pulBuffer, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer pchPathEncoded = stack.ASCII(pchPath);
            int n = VRIOBuffer.nVRIOBuffer_Open(MemoryUtil.memAddress(pchPathEncoded), mode, unElementSize, unElements, MemoryUtil.memAddress(pulBuffer));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="EIOBufferError")
    public static int VRIOBuffer_Close(@NativeType(value="IOBufferHandle_t") long ulBuffer) {
        long __functionAddress = OpenVR.VRIOBuffer.Close;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callJI(__functionAddress, ulBuffer);
    }

    public static int nVRIOBuffer_Read(long ulBuffer, long pDst, int unBytes, long punRead) {
        long __functionAddress = OpenVR.VRIOBuffer.Read;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callJPPI(__functionAddress, ulBuffer, pDst, unBytes, punRead);
    }

    @NativeType(value="EIOBufferError")
    public static int VRIOBuffer_Read(@NativeType(value="IOBufferHandle_t") long ulBuffer, @NativeType(value="void *") ByteBuffer pDst, @NativeType(value="uint32_t *") IntBuffer punRead) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)punRead, 1);
        }
        return VRIOBuffer.nVRIOBuffer_Read(ulBuffer, MemoryUtil.memAddress(pDst), pDst.remaining(), MemoryUtil.memAddress(punRead));
    }

    public static int nVRIOBuffer_Write(long ulBuffer, long pSrc, int unBytes) {
        long __functionAddress = OpenVR.VRIOBuffer.Write;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callJPI(__functionAddress, ulBuffer, pSrc, unBytes);
    }

    @NativeType(value="EIOBufferError")
    public static int VRIOBuffer_Write(@NativeType(value="IOBufferHandle_t") long ulBuffer, @NativeType(value="void *") ByteBuffer pSrc) {
        return VRIOBuffer.nVRIOBuffer_Write(ulBuffer, MemoryUtil.memAddress(pSrc), pSrc.remaining());
    }

    @NativeType(value="PropertyContainerHandle_t")
    public static long VRIOBuffer_PropertyContainer(@NativeType(value="IOBufferHandle_t") long ulBuffer) {
        long __functionAddress = OpenVR.VRIOBuffer.PropertyContainer;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callJJ(__functionAddress, ulBuffer);
    }
}

