/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct VREvent_Scroll_t")
public class VREventScroll
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int XDELTA;
    public static final int YDELTA;
    public static final int REPEATCOUNT;

    VREventScroll(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VREventScroll(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VREventScroll.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public float xdelta() {
        return VREventScroll.nxdelta(this.address());
    }

    public float ydelta() {
        return VREventScroll.nydelta(this.address());
    }

    @NativeType(value="uint32_t")
    public int repeatCount() {
        return VREventScroll.nrepeatCount(this.address());
    }

    public static VREventScroll create(long address) {
        return new VREventScroll(address, null);
    }

    @Nullable
    public static VREventScroll createSafe(long address) {
        return address == 0L ? null : VREventScroll.create(address);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VREventScroll.create(address, capacity);
    }

    public static float nxdelta(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)XDELTA);
    }

    public static float nydelta(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)YDELTA);
    }

    public static int nrepeatCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)REPEATCOUNT);
    }

    static {
        Struct.Layout layout = VREventScroll.__struct(VREventScroll.__member(4), VREventScroll.__member(4), VREventScroll.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        XDELTA = layout.offsetof(0);
        YDELTA = layout.offsetof(1);
        REPEATCOUNT = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VREventScroll, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VREventScroll newInstance(long address) {
            return new VREventScroll(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        public float xdelta() {
            return VREventScroll.nxdelta(this.address());
        }

        public float ydelta() {
            return VREventScroll.nydelta(this.address());
        }

        @NativeType(value="uint32_t")
        public int repeatCount() {
            return VREventScroll.nrepeatCount(this.address());
        }
    }
}

