/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct VREvent_Property_t")
public class VREventProperty
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int CONTAINER;
    public static final int PROP;

    VREventProperty(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VREventProperty(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VREventProperty.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="PropertyContainerHandle_t")
    public long container() {
        return VREventProperty.ncontainer(this.address());
    }

    @NativeType(value="ETrackedDeviceProperty")
    public int prop() {
        return VREventProperty.nprop(this.address());
    }

    public static VREventProperty create(long address) {
        return new VREventProperty(address, null);
    }

    @Nullable
    public static VREventProperty createSafe(long address) {
        return address == 0L ? null : VREventProperty.create(address);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VREventProperty.create(address, capacity);
    }

    public static long ncontainer(long struct) {
        return MemoryUtil.memGetLong(struct + (long)CONTAINER);
    }

    public static int nprop(long struct) {
        return MemoryUtil.memGetInt(struct + (long)PROP);
    }

    static {
        Struct.Layout layout = VREventProperty.__struct(VREventProperty.__member(8), VREventProperty.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        CONTAINER = layout.offsetof(0);
        PROP = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<VREventProperty, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VREventProperty newInstance(long address) {
            return new VREventProperty(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="PropertyContainerHandle_t")
        public long container() {
            return VREventProperty.ncontainer(this.address());
        }

        @NativeType(value="ETrackedDeviceProperty")
        public int prop() {
            return VREventProperty.nprop(this.address());
        }
    }
}

