/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct VREvent_Process_t")
public class VREventProcess
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int PID;
    public static final int OLDPID;
    public static final int BFORCED;

    VREventProcess(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VREventProcess(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VREventProcess.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint32_t")
    public int pid() {
        return VREventProcess.npid(this.address());
    }

    @NativeType(value="uint32_t")
    public int oldPid() {
        return VREventProcess.noldPid(this.address());
    }

    @NativeType(value="bool")
    public boolean bForced() {
        return VREventProcess.nbForced(this.address());
    }

    public static VREventProcess create(long address) {
        return new VREventProcess(address, null);
    }

    @Nullable
    public static VREventProcess createSafe(long address) {
        return address == 0L ? null : VREventProcess.create(address);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VREventProcess.create(address, capacity);
    }

    public static int npid(long struct) {
        return MemoryUtil.memGetInt(struct + (long)PID);
    }

    public static int noldPid(long struct) {
        return MemoryUtil.memGetInt(struct + (long)OLDPID);
    }

    public static boolean nbForced(long struct) {
        return MemoryUtil.memGetByte(struct + (long)BFORCED) != 0;
    }

    static {
        Struct.Layout layout = VREventProcess.__struct(VREventProcess.__member(4), VREventProcess.__member(4), VREventProcess.__member(1));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        PID = layout.offsetof(0);
        OLDPID = layout.offsetof(1);
        BFORCED = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VREventProcess, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VREventProcess newInstance(long address) {
            return new VREventProcess(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="uint32_t")
        public int pid() {
            return VREventProcess.npid(this.address());
        }

        @NativeType(value="uint32_t")
        public int oldPid() {
            return VREventProcess.noldPid(this.address());
        }

        @NativeType(value="bool")
        public boolean bForced() {
            return VREventProcess.nbForced(this.address());
        }
    }
}

