/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct VREvent_Overlay_t")
public class VREventOverlay
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int OVERLAYHANDLE;
    public static final int DEVICEPATH;

    VREventOverlay(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public VREventOverlay(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VREventOverlay.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint64_t")
    public long overlayHandle() {
        return VREventOverlay.noverlayHandle(this.address());
    }

    @NativeType(value="uint64_t")
    public long devicePath() {
        return VREventOverlay.ndevicePath(this.address());
    }

    public static VREventOverlay create(long address) {
        return new VREventOverlay(address, null);
    }

    @Nullable
    public static VREventOverlay createSafe(long address) {
        return address == 0L ? null : VREventOverlay.create(address);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VREventOverlay.create(address, capacity);
    }

    public static long noverlayHandle(long struct) {
        return MemoryUtil.memGetLong(struct + (long)OVERLAYHANDLE);
    }

    public static long ndevicePath(long struct) {
        return MemoryUtil.memGetLong(struct + (long)DEVICEPATH);
    }

    static {
        Struct.Layout layout = VREventOverlay.__struct(VREventOverlay.__member(8), VREventOverlay.__member(8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        OVERLAYHANDLE = layout.offsetof(0);
        DEVICEPATH = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<VREventOverlay, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VREventOverlay newInstance(long address) {
            return new VREventOverlay(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="uint64_t")
        public long overlayHandle() {
            return VREventOverlay.noverlayHandle(this.address());
        }

        @NativeType(value="uint64_t")
        public long devicePath() {
            return VREventOverlay.ndevicePath(this.address());
        }
    }
}

