/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct Texture_t")
public class Texture
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int HANDLE;
    public static final int ETYPE;
    public static final int ECOLORSPACE;

    Texture(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public Texture(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), Texture.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="void *")
    public long handle() {
        return Texture.nhandle(this.address());
    }

    @NativeType(value="ETextureType")
    public int eType() {
        return Texture.neType(this.address());
    }

    @NativeType(value="EColorSpace")
    public int eColorSpace() {
        return Texture.neColorSpace(this.address());
    }

    public Texture handle(@NativeType(value="void *") long value) {
        Texture.nhandle(this.address(), value);
        return this;
    }

    public Texture eType(@NativeType(value="ETextureType") int value) {
        Texture.neType(this.address(), value);
        return this;
    }

    public Texture eColorSpace(@NativeType(value="EColorSpace") int value) {
        Texture.neColorSpace(this.address(), value);
        return this;
    }

    public Texture set(long handle, int eType, int eColorSpace) {
        this.handle(handle);
        this.eType(eType);
        this.eColorSpace(eColorSpace);
        return this;
    }

    public Texture set(Texture src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static Texture malloc() {
        return Texture.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static Texture calloc() {
        return Texture.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static Texture create() {
        return new Texture(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static Texture create(long address) {
        return new Texture(address, null);
    }

    @Nullable
    public static Texture createSafe(long address) {
        return address == 0L ? null : Texture.create(address);
    }

    public static Buffer malloc(int capacity) {
        return Texture.create(Texture.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return Texture.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(Texture.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : Texture.create(address, capacity);
    }

    public static Texture mallocStack() {
        return Texture.mallocStack(MemoryStack.stackGet());
    }

    public static Texture callocStack() {
        return Texture.callocStack(MemoryStack.stackGet());
    }

    public static Texture mallocStack(MemoryStack stack) {
        return Texture.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static Texture callocStack(MemoryStack stack) {
        return Texture.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return Texture.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return Texture.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return Texture.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return Texture.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nhandle(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)HANDLE);
    }

    public static int neType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)ETYPE);
    }

    public static int neColorSpace(long struct) {
        return MemoryUtil.memGetInt(struct + (long)ECOLORSPACE);
    }

    public static void nhandle(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)HANDLE, Checks.check(value));
    }

    public static void neType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)ETYPE, value);
    }

    public static void neColorSpace(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)ECOLORSPACE, value);
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)HANDLE));
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            Texture.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = Texture.__struct(Texture.__member(POINTER_SIZE), Texture.__member(4), Texture.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        HANDLE = layout.offsetof(0);
        ETYPE = layout.offsetof(1);
        ECOLORSPACE = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<Texture, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Texture newInstance(long address) {
            return new Texture(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="void *")
        public long handle() {
            return Texture.nhandle(this.address());
        }

        @NativeType(value="ETextureType")
        public int eType() {
            return Texture.neType(this.address());
        }

        @NativeType(value="EColorSpace")
        public int eColorSpace() {
            return Texture.neColorSpace(this.address());
        }

        public Buffer handle(@NativeType(value="void *") long value) {
            Texture.nhandle(this.address(), value);
            return this;
        }

        public Buffer eType(@NativeType(value="ETextureType") int value) {
            Texture.neType(this.address(), value);
            return this;
        }

        public Buffer eColorSpace(@NativeType(value="EColorSpace") int value) {
            Texture.neColorSpace(this.address(), value);
            return this;
        }
    }
}

