/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct RenderModel_TextureMap_t")
public class RenderModelTextureMap
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int UNWIDTH;
    public static final int UNHEIGHT;
    public static final int RUBTEXTUREMAPDATA;

    RenderModelTextureMap(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public RenderModelTextureMap(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), RenderModelTextureMap.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint16_t")
    public short unWidth() {
        return RenderModelTextureMap.nunWidth(this.address());
    }

    @NativeType(value="uint16_t")
    public short unHeight() {
        return RenderModelTextureMap.nunHeight(this.address());
    }

    @NativeType(value="uint8_t const *")
    public ByteBuffer rubTextureMapData(int capacity) {
        return RenderModelTextureMap.nrubTextureMapData(this.address(), capacity);
    }

    public static RenderModelTextureMap malloc() {
        return RenderModelTextureMap.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static RenderModelTextureMap calloc() {
        return RenderModelTextureMap.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static RenderModelTextureMap create() {
        return new RenderModelTextureMap(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static RenderModelTextureMap create(long address) {
        return new RenderModelTextureMap(address, null);
    }

    @Nullable
    public static RenderModelTextureMap createSafe(long address) {
        return address == 0L ? null : RenderModelTextureMap.create(address);
    }

    public static Buffer malloc(int capacity) {
        return RenderModelTextureMap.create(RenderModelTextureMap.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return RenderModelTextureMap.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(RenderModelTextureMap.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : RenderModelTextureMap.create(address, capacity);
    }

    public static RenderModelTextureMap mallocStack() {
        return RenderModelTextureMap.mallocStack(MemoryStack.stackGet());
    }

    public static RenderModelTextureMap callocStack() {
        return RenderModelTextureMap.callocStack(MemoryStack.stackGet());
    }

    public static RenderModelTextureMap mallocStack(MemoryStack stack) {
        return RenderModelTextureMap.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static RenderModelTextureMap callocStack(MemoryStack stack) {
        return RenderModelTextureMap.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return RenderModelTextureMap.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return RenderModelTextureMap.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return RenderModelTextureMap.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return RenderModelTextureMap.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static short nunWidth(long struct) {
        return MemoryUtil.memGetShort(struct + (long)UNWIDTH);
    }

    public static short nunHeight(long struct) {
        return MemoryUtil.memGetShort(struct + (long)UNHEIGHT);
    }

    public static ByteBuffer nrubTextureMapData(long struct, int capacity) {
        return MemoryUtil.memByteBuffer(MemoryUtil.memGetAddress(struct + (long)RUBTEXTUREMAPDATA), capacity);
    }

    static {
        Struct.Layout layout = RenderModelTextureMap.__struct(RenderModelTextureMap.__member(2), RenderModelTextureMap.__member(2), RenderModelTextureMap.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        UNWIDTH = layout.offsetof(0);
        UNHEIGHT = layout.offsetof(1);
        RUBTEXTUREMAPDATA = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<RenderModelTextureMap, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected RenderModelTextureMap newInstance(long address) {
            return new RenderModelTextureMap(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="uint16_t")
        public short unWidth() {
            return RenderModelTextureMap.nunWidth(this.address());
        }

        @NativeType(value="uint16_t")
        public short unHeight() {
            return RenderModelTextureMap.nunHeight(this.address());
        }

        @NativeType(value="uint8_t const *")
        public ByteBuffer rubTextureMapData(int capacity) {
            return RenderModelTextureMap.nrubTextureMapData(this.address(), capacity);
        }
    }
}

