/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct NotificationBitmap_t")
public class NotificationBitmap
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int M_PIMAGEDATA;
    public static final int M_NWIDTH;
    public static final int M_NHEIGHT;
    public static final int M_NBYTESPERPIXEL;

    NotificationBitmap(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public NotificationBitmap(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), NotificationBitmap.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="void *")
    public ByteBuffer m_pImageData(int capacity) {
        return NotificationBitmap.nm_pImageData(this.address(), capacity);
    }

    @NativeType(value="int32_t")
    public int m_nWidth() {
        return NotificationBitmap.nm_nWidth(this.address());
    }

    @NativeType(value="int32_t")
    public int m_nHeight() {
        return NotificationBitmap.nm_nHeight(this.address());
    }

    @NativeType(value="int32_t")
    public int m_nBytesPerPixel() {
        return NotificationBitmap.nm_nBytesPerPixel(this.address());
    }

    public NotificationBitmap m_pImageData(@NativeType(value="void *") ByteBuffer value) {
        NotificationBitmap.nm_pImageData(this.address(), value);
        return this;
    }

    public NotificationBitmap m_nWidth(@NativeType(value="int32_t") int value) {
        NotificationBitmap.nm_nWidth(this.address(), value);
        return this;
    }

    public NotificationBitmap m_nHeight(@NativeType(value="int32_t") int value) {
        NotificationBitmap.nm_nHeight(this.address(), value);
        return this;
    }

    public NotificationBitmap m_nBytesPerPixel(@NativeType(value="int32_t") int value) {
        NotificationBitmap.nm_nBytesPerPixel(this.address(), value);
        return this;
    }

    public NotificationBitmap set(ByteBuffer m_pImageData, int m_nWidth, int m_nHeight, int m_nBytesPerPixel) {
        this.m_pImageData(m_pImageData);
        this.m_nWidth(m_nWidth);
        this.m_nHeight(m_nHeight);
        this.m_nBytesPerPixel(m_nBytesPerPixel);
        return this;
    }

    public NotificationBitmap set(NotificationBitmap src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static NotificationBitmap malloc() {
        return NotificationBitmap.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static NotificationBitmap calloc() {
        return NotificationBitmap.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static NotificationBitmap create() {
        return new NotificationBitmap(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static NotificationBitmap create(long address) {
        return new NotificationBitmap(address, null);
    }

    @Nullable
    public static NotificationBitmap createSafe(long address) {
        return address == 0L ? null : NotificationBitmap.create(address);
    }

    public static Buffer malloc(int capacity) {
        return NotificationBitmap.create(NotificationBitmap.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return NotificationBitmap.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(NotificationBitmap.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : NotificationBitmap.create(address, capacity);
    }

    public static NotificationBitmap mallocStack() {
        return NotificationBitmap.mallocStack(MemoryStack.stackGet());
    }

    public static NotificationBitmap callocStack() {
        return NotificationBitmap.callocStack(MemoryStack.stackGet());
    }

    public static NotificationBitmap mallocStack(MemoryStack stack) {
        return NotificationBitmap.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static NotificationBitmap callocStack(MemoryStack stack) {
        return NotificationBitmap.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return NotificationBitmap.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return NotificationBitmap.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return NotificationBitmap.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return NotificationBitmap.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static ByteBuffer nm_pImageData(long struct, int capacity) {
        return MemoryUtil.memByteBuffer(MemoryUtil.memGetAddress(struct + (long)M_PIMAGEDATA), capacity);
    }

    public static int nm_nWidth(long struct) {
        return MemoryUtil.memGetInt(struct + (long)M_NWIDTH);
    }

    public static int nm_nHeight(long struct) {
        return MemoryUtil.memGetInt(struct + (long)M_NHEIGHT);
    }

    public static int nm_nBytesPerPixel(long struct) {
        return MemoryUtil.memGetInt(struct + (long)M_NBYTESPERPIXEL);
    }

    public static void nm_pImageData(long struct, ByteBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)M_PIMAGEDATA, MemoryUtil.memAddress(value));
    }

    public static void nm_nWidth(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)M_NWIDTH, value);
    }

    public static void nm_nHeight(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)M_NHEIGHT, value);
    }

    public static void nm_nBytesPerPixel(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)M_NBYTESPERPIXEL, value);
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)M_PIMAGEDATA));
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            NotificationBitmap.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = NotificationBitmap.__struct(NotificationBitmap.__member(POINTER_SIZE), NotificationBitmap.__member(4), NotificationBitmap.__member(4), NotificationBitmap.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        M_PIMAGEDATA = layout.offsetof(0);
        M_NWIDTH = layout.offsetof(1);
        M_NHEIGHT = layout.offsetof(2);
        M_NBYTESPERPIXEL = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<NotificationBitmap, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected NotificationBitmap newInstance(long address) {
            return new NotificationBitmap(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="void *")
        public ByteBuffer m_pImageData(int capacity) {
            return NotificationBitmap.nm_pImageData(this.address(), capacity);
        }

        @NativeType(value="int32_t")
        public int m_nWidth() {
            return NotificationBitmap.nm_nWidth(this.address());
        }

        @NativeType(value="int32_t")
        public int m_nHeight() {
            return NotificationBitmap.nm_nHeight(this.address());
        }

        @NativeType(value="int32_t")
        public int m_nBytesPerPixel() {
            return NotificationBitmap.nm_nBytesPerPixel(this.address());
        }

        public Buffer m_pImageData(@NativeType(value="void *") ByteBuffer value) {
            NotificationBitmap.nm_pImageData(this.address(), value);
            return this;
        }

        public Buffer m_nWidth(@NativeType(value="int32_t") int value) {
            NotificationBitmap.nm_nWidth(this.address(), value);
            return this;
        }

        public Buffer m_nHeight(@NativeType(value="int32_t") int value) {
            NotificationBitmap.nm_nHeight(this.address(), value);
            return this;
        }

        public Buffer m_nBytesPerPixel(@NativeType(value="int32_t") int value) {
            NotificationBitmap.nm_nBytesPerPixel(this.address(), value);
            return this;
        }
    }
}

