/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.openvr.HmdVector3d;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct ImuSample_t")
public class ImuSample
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int FSAMPLETIME;
    public static final int VACCEL;
    public static final int VGYRO;
    public static final int UNOFFSCALEFLAGS;

    ImuSample(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public ImuSample(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), ImuSample.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public double fSampleTime() {
        return ImuSample.nfSampleTime(this.address());
    }

    @NativeType(value="HmdVector3d_t")
    public HmdVector3d vAccel() {
        return ImuSample.nvAccel(this.address());
    }

    public ImuSample vAccel(Consumer<HmdVector3d> consumer) {
        consumer.accept(this.vAccel());
        return this;
    }

    @NativeType(value="HmdVector3d_t")
    public HmdVector3d vGyro() {
        return ImuSample.nvGyro(this.address());
    }

    public ImuSample vGyro(Consumer<HmdVector3d> consumer) {
        consumer.accept(this.vGyro());
        return this;
    }

    @NativeType(value="uint32_t")
    public int unOffScaleFlags() {
        return ImuSample.nunOffScaleFlags(this.address());
    }

    public static ImuSample create(long address) {
        return new ImuSample(address, null);
    }

    @Nullable
    public static ImuSample createSafe(long address) {
        return address == 0L ? null : ImuSample.create(address);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : ImuSample.create(address, capacity);
    }

    public static double nfSampleTime(long struct) {
        return MemoryUtil.memGetDouble(struct + (long)FSAMPLETIME);
    }

    public static HmdVector3d nvAccel(long struct) {
        return HmdVector3d.create(struct + (long)VACCEL);
    }

    public static HmdVector3d nvGyro(long struct) {
        return HmdVector3d.create(struct + (long)VGYRO);
    }

    public static int nunOffScaleFlags(long struct) {
        return MemoryUtil.memGetInt(struct + (long)UNOFFSCALEFLAGS);
    }

    static {
        Struct.Layout layout = ImuSample.__struct(ImuSample.__member(8), ImuSample.__member(HmdVector3d.SIZEOF, HmdVector3d.ALIGNOF), ImuSample.__member(HmdVector3d.SIZEOF, HmdVector3d.ALIGNOF), ImuSample.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        FSAMPLETIME = layout.offsetof(0);
        VACCEL = layout.offsetof(1);
        VGYRO = layout.offsetof(2);
        UNOFFSCALEFLAGS = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<ImuSample, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected ImuSample newInstance(long address) {
            return new ImuSample(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        public double fSampleTime() {
            return ImuSample.nfSampleTime(this.address());
        }

        @NativeType(value="HmdVector3d_t")
        public HmdVector3d vAccel() {
            return ImuSample.nvAccel(this.address());
        }

        public Buffer vAccel(Consumer<HmdVector3d> consumer) {
            consumer.accept(this.vAccel());
            return this;
        }

        @NativeType(value="HmdVector3d_t")
        public HmdVector3d vGyro() {
            return ImuSample.nvGyro(this.address());
        }

        public Buffer vGyro(Consumer<HmdVector3d> consumer) {
            consumer.accept(this.vGyro());
            return this;
        }

        @NativeType(value="uint32_t")
        public int unOffScaleFlags() {
            return ImuSample.nunOffScaleFlags(this.address());
        }
    }
}

