/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openvr.HmdVector3;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct HmdQuad_t")
public class HmdQuad
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int VCORNERS;

    HmdQuad(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public HmdQuad(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), HmdQuad.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="HmdVector3_t[4]")
    public HmdVector3.Buffer vCorners() {
        return HmdQuad.nvCorners(this.address());
    }

    @NativeType(value="HmdVector3_t")
    public HmdVector3 vCorners(int index) {
        return HmdQuad.nvCorners(this.address(), index);
    }

    public HmdQuad vCorners(@NativeType(value="HmdVector3_t[4]") HmdVector3.Buffer value) {
        HmdQuad.nvCorners(this.address(), value);
        return this;
    }

    public HmdQuad vCorners(int index, @NativeType(value="HmdVector3_t") HmdVector3 value) {
        HmdQuad.nvCorners(this.address(), index, value);
        return this;
    }

    public HmdQuad set(HmdQuad src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static HmdQuad malloc() {
        return HmdQuad.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static HmdQuad calloc() {
        return HmdQuad.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static HmdQuad create() {
        return new HmdQuad(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static HmdQuad create(long address) {
        return new HmdQuad(address, null);
    }

    @Nullable
    public static HmdQuad createSafe(long address) {
        return address == 0L ? null : HmdQuad.create(address);
    }

    public static Buffer malloc(int capacity) {
        return HmdQuad.create(HmdQuad.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return HmdQuad.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(HmdQuad.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : HmdQuad.create(address, capacity);
    }

    public static HmdQuad mallocStack() {
        return HmdQuad.mallocStack(MemoryStack.stackGet());
    }

    public static HmdQuad callocStack() {
        return HmdQuad.callocStack(MemoryStack.stackGet());
    }

    public static HmdQuad mallocStack(MemoryStack stack) {
        return HmdQuad.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static HmdQuad callocStack(MemoryStack stack) {
        return HmdQuad.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return HmdQuad.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return HmdQuad.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return HmdQuad.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return HmdQuad.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static HmdVector3.Buffer nvCorners(long struct) {
        return HmdVector3.create(struct + (long)VCORNERS, 4);
    }

    public static HmdVector3 nvCorners(long struct, int index) {
        return HmdVector3.create(struct + (long)VCORNERS + Checks.check(index, 4) * (long)HmdVector3.SIZEOF);
    }

    public static void nvCorners(long struct, HmdVector3.Buffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 4);
        }
        MemoryUtil.memCopy(value.address(), struct + (long)VCORNERS, value.remaining() * HmdVector3.SIZEOF);
    }

    public static void nvCorners(long struct, int index, HmdVector3 value) {
        MemoryUtil.memCopy(value.address(), struct + (long)VCORNERS + Checks.check(index, 4) * (long)HmdVector3.SIZEOF, HmdVector3.SIZEOF);
    }

    static {
        Struct.Layout layout = HmdQuad.__struct(HmdQuad.__array(HmdVector3.SIZEOF, HmdVector3.ALIGNOF, 4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        VCORNERS = layout.offsetof(0);
    }

    public static class Buffer
    extends StructBuffer<HmdQuad, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected HmdQuad newInstance(long address) {
            return new HmdQuad(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="HmdVector3_t[4]")
        public HmdVector3.Buffer vCorners() {
            return HmdQuad.nvCorners(this.address());
        }

        @NativeType(value="HmdVector3_t")
        public HmdVector3 vCorners(int index) {
            return HmdQuad.nvCorners(this.address(), index);
        }

        public Buffer vCorners(@NativeType(value="HmdVector3_t[4]") HmdVector3.Buffer value) {
            HmdQuad.nvCorners(this.address(), value);
            return this;
        }

        public Buffer vCorners(int index, @NativeType(value="HmdVector3_t") HmdVector3 value) {
            HmdQuad.nvCorners(this.address(), index, value);
            return this;
        }
    }
}

