/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openvr.HmdVector2;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct HiddenAreaMesh_t")
public class HiddenAreaMesh
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int PVERTEXDATA;
    public static final int UNTRIANGLECOUNT;

    HiddenAreaMesh(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public HiddenAreaMesh(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), HiddenAreaMesh.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @Nullable
    @NativeType(value="HmdVector2_t *")
    public HmdVector2.Buffer pVertexData() {
        return HiddenAreaMesh.npVertexData(this.address());
    }

    @NativeType(value="uint32_t")
    public int unTriangleCount() {
        return HiddenAreaMesh.nunTriangleCount(this.address());
    }

    public static HiddenAreaMesh malloc() {
        return HiddenAreaMesh.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static HiddenAreaMesh calloc() {
        return HiddenAreaMesh.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static HiddenAreaMesh create() {
        return new HiddenAreaMesh(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static HiddenAreaMesh create(long address) {
        return new HiddenAreaMesh(address, null);
    }

    @Nullable
    public static HiddenAreaMesh createSafe(long address) {
        return address == 0L ? null : HiddenAreaMesh.create(address);
    }

    public static Buffer malloc(int capacity) {
        return HiddenAreaMesh.create(HiddenAreaMesh.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return HiddenAreaMesh.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(HiddenAreaMesh.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : HiddenAreaMesh.create(address, capacity);
    }

    public static HiddenAreaMesh mallocStack() {
        return HiddenAreaMesh.mallocStack(MemoryStack.stackGet());
    }

    public static HiddenAreaMesh callocStack() {
        return HiddenAreaMesh.callocStack(MemoryStack.stackGet());
    }

    public static HiddenAreaMesh mallocStack(MemoryStack stack) {
        return HiddenAreaMesh.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static HiddenAreaMesh callocStack(MemoryStack stack) {
        return HiddenAreaMesh.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return HiddenAreaMesh.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return HiddenAreaMesh.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return HiddenAreaMesh.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return HiddenAreaMesh.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    @Nullable
    public static HmdVector2.Buffer npVertexData(long struct) {
        return HmdVector2.createSafe(MemoryUtil.memGetAddress(struct + (long)PVERTEXDATA), HiddenAreaMesh.nunTriangleCount(struct));
    }

    public static int nunTriangleCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)UNTRIANGLECOUNT);
    }

    static {
        Struct.Layout layout = HiddenAreaMesh.__struct(HiddenAreaMesh.__member(POINTER_SIZE), HiddenAreaMesh.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        PVERTEXDATA = layout.offsetof(0);
        UNTRIANGLECOUNT = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<HiddenAreaMesh, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected HiddenAreaMesh newInstance(long address) {
            return new HiddenAreaMesh(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @Nullable
        @NativeType(value="HmdVector2_t *")
        public HmdVector2.Buffer pVertexData() {
            return HiddenAreaMesh.npVertexData(this.address());
        }

        @NativeType(value="uint32_t")
        public int unTriangleCount() {
            return HiddenAreaMesh.nunTriangleCount(this.address());
        }
    }
}

