/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openvr.TrackedDevicePose;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct CameraVideoStreamFrameHeader_t")
public class CameraVideoStreamFrameHeader
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int EFRAMETYPE;
    public static final int NWIDTH;
    public static final int NHEIGHT;
    public static final int NBYTESPERPIXEL;
    public static final int NFRAMESEQUENCE;
    public static final int STANDINGTRACKEDDEVICEPOSE;

    CameraVideoStreamFrameHeader(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public CameraVideoStreamFrameHeader(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), CameraVideoStreamFrameHeader.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="EVRTrackedCameraFrameType")
    public int eFrameType() {
        return CameraVideoStreamFrameHeader.neFrameType(this.address());
    }

    @NativeType(value="uint32_t")
    public int nWidth() {
        return CameraVideoStreamFrameHeader.nnWidth(this.address());
    }

    @NativeType(value="uint32_t")
    public int nHeight() {
        return CameraVideoStreamFrameHeader.nnHeight(this.address());
    }

    @NativeType(value="uint32_t")
    public int nBytesPerPixel() {
        return CameraVideoStreamFrameHeader.nnBytesPerPixel(this.address());
    }

    @NativeType(value="uint32_t")
    public int nFrameSequence() {
        return CameraVideoStreamFrameHeader.nnFrameSequence(this.address());
    }

    @NativeType(value="TrackedDevicePose_t")
    public TrackedDevicePose standingTrackedDevicePose() {
        return CameraVideoStreamFrameHeader.nstandingTrackedDevicePose(this.address());
    }

    public CameraVideoStreamFrameHeader standingTrackedDevicePose(Consumer<TrackedDevicePose> consumer) {
        consumer.accept(this.standingTrackedDevicePose());
        return this;
    }

    public static CameraVideoStreamFrameHeader malloc() {
        return CameraVideoStreamFrameHeader.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static CameraVideoStreamFrameHeader calloc() {
        return CameraVideoStreamFrameHeader.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static CameraVideoStreamFrameHeader create() {
        return new CameraVideoStreamFrameHeader(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static CameraVideoStreamFrameHeader create(long address) {
        return new CameraVideoStreamFrameHeader(address, null);
    }

    @Nullable
    public static CameraVideoStreamFrameHeader createSafe(long address) {
        return address == 0L ? null : CameraVideoStreamFrameHeader.create(address);
    }

    public static Buffer malloc(int capacity) {
        return CameraVideoStreamFrameHeader.create(CameraVideoStreamFrameHeader.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return CameraVideoStreamFrameHeader.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(CameraVideoStreamFrameHeader.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : CameraVideoStreamFrameHeader.create(address, capacity);
    }

    public static CameraVideoStreamFrameHeader mallocStack() {
        return CameraVideoStreamFrameHeader.mallocStack(MemoryStack.stackGet());
    }

    public static CameraVideoStreamFrameHeader callocStack() {
        return CameraVideoStreamFrameHeader.callocStack(MemoryStack.stackGet());
    }

    public static CameraVideoStreamFrameHeader mallocStack(MemoryStack stack) {
        return CameraVideoStreamFrameHeader.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static CameraVideoStreamFrameHeader callocStack(MemoryStack stack) {
        return CameraVideoStreamFrameHeader.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return CameraVideoStreamFrameHeader.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return CameraVideoStreamFrameHeader.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return CameraVideoStreamFrameHeader.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return CameraVideoStreamFrameHeader.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int neFrameType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)EFRAMETYPE);
    }

    public static int nnWidth(long struct) {
        return MemoryUtil.memGetInt(struct + (long)NWIDTH);
    }

    public static int nnHeight(long struct) {
        return MemoryUtil.memGetInt(struct + (long)NHEIGHT);
    }

    public static int nnBytesPerPixel(long struct) {
        return MemoryUtil.memGetInt(struct + (long)NBYTESPERPIXEL);
    }

    public static int nnFrameSequence(long struct) {
        return MemoryUtil.memGetInt(struct + (long)NFRAMESEQUENCE);
    }

    public static TrackedDevicePose nstandingTrackedDevicePose(long struct) {
        return TrackedDevicePose.create(struct + (long)STANDINGTRACKEDDEVICEPOSE);
    }

    static {
        Struct.Layout layout = CameraVideoStreamFrameHeader.__struct(CameraVideoStreamFrameHeader.__member(4), CameraVideoStreamFrameHeader.__member(4), CameraVideoStreamFrameHeader.__member(4), CameraVideoStreamFrameHeader.__member(4), CameraVideoStreamFrameHeader.__member(4), CameraVideoStreamFrameHeader.__member(TrackedDevicePose.SIZEOF, TrackedDevicePose.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        EFRAMETYPE = layout.offsetof(0);
        NWIDTH = layout.offsetof(1);
        NHEIGHT = layout.offsetof(2);
        NBYTESPERPIXEL = layout.offsetof(3);
        NFRAMESEQUENCE = layout.offsetof(4);
        STANDINGTRACKEDDEVICEPOSE = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<CameraVideoStreamFrameHeader, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected CameraVideoStreamFrameHeader newInstance(long address) {
            return new CameraVideoStreamFrameHeader(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="EVRTrackedCameraFrameType")
        public int eFrameType() {
            return CameraVideoStreamFrameHeader.neFrameType(this.address());
        }

        @NativeType(value="uint32_t")
        public int nWidth() {
            return CameraVideoStreamFrameHeader.nnWidth(this.address());
        }

        @NativeType(value="uint32_t")
        public int nHeight() {
            return CameraVideoStreamFrameHeader.nnHeight(this.address());
        }

        @NativeType(value="uint32_t")
        public int nBytesPerPixel() {
            return CameraVideoStreamFrameHeader.nnBytesPerPixel(this.address());
        }

        @NativeType(value="uint32_t")
        public int nFrameSequence() {
            return CameraVideoStreamFrameHeader.nnFrameSequence(this.address());
        }

        @NativeType(value="TrackedDevicePose_t")
        public TrackedDevicePose standingTrackedDevicePose() {
            return CameraVideoStreamFrameHeader.nstandingTrackedDevicePose(this.address());
        }

        public Buffer standingTrackedDevicePose(Consumer<TrackedDevicePose> consumer) {
            consumer.accept(this.standingTrackedDevicePose());
            return this;
        }
    }
}

