/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct AppOverrideKeys_t")
public class AppOverrideKeys
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int PCHKEY;
    public static final int PCHVALUE;

    AppOverrideKeys(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public AppOverrideKeys(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), AppOverrideKeys.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="char *")
    public ByteBuffer pchKey() {
        return AppOverrideKeys.npchKey(this.address());
    }

    @NativeType(value="char *")
    public String pchKeyString() {
        return AppOverrideKeys.npchKeyString(this.address());
    }

    @NativeType(value="char *")
    public ByteBuffer pchValue(int capacity) {
        return AppOverrideKeys.npchValue(this.address(), capacity);
    }

    public AppOverrideKeys pchKey(@NativeType(value="char *") ByteBuffer value) {
        AppOverrideKeys.npchKey(this.address(), value);
        return this;
    }

    public AppOverrideKeys pchValue(@NativeType(value="char *") ByteBuffer value) {
        AppOverrideKeys.npchValue(this.address(), value);
        return this;
    }

    public AppOverrideKeys set(ByteBuffer pchKey, ByteBuffer pchValue) {
        this.pchKey(pchKey);
        this.pchValue(pchValue);
        return this;
    }

    public AppOverrideKeys set(AppOverrideKeys src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static AppOverrideKeys malloc() {
        return AppOverrideKeys.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static AppOverrideKeys calloc() {
        return AppOverrideKeys.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static AppOverrideKeys create() {
        return new AppOverrideKeys(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static AppOverrideKeys create(long address) {
        return new AppOverrideKeys(address, null);
    }

    @Nullable
    public static AppOverrideKeys createSafe(long address) {
        return address == 0L ? null : AppOverrideKeys.create(address);
    }

    public static Buffer malloc(int capacity) {
        return AppOverrideKeys.create(AppOverrideKeys.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return AppOverrideKeys.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(AppOverrideKeys.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : AppOverrideKeys.create(address, capacity);
    }

    public static AppOverrideKeys mallocStack() {
        return AppOverrideKeys.mallocStack(MemoryStack.stackGet());
    }

    public static AppOverrideKeys callocStack() {
        return AppOverrideKeys.callocStack(MemoryStack.stackGet());
    }

    public static AppOverrideKeys mallocStack(MemoryStack stack) {
        return AppOverrideKeys.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static AppOverrideKeys callocStack(MemoryStack stack) {
        return AppOverrideKeys.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return AppOverrideKeys.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return AppOverrideKeys.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return AppOverrideKeys.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return AppOverrideKeys.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static ByteBuffer npchKey(long struct) {
        return MemoryUtil.memByteBufferNT1(MemoryUtil.memGetAddress(struct + (long)PCHKEY));
    }

    public static String npchKeyString(long struct) {
        return MemoryUtil.memASCII(MemoryUtil.memGetAddress(struct + (long)PCHKEY));
    }

    public static ByteBuffer npchValue(long struct, int capacity) {
        return MemoryUtil.memByteBuffer(MemoryUtil.memGetAddress(struct + (long)PCHVALUE), capacity);
    }

    public static void npchKey(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1(value);
        }
        MemoryUtil.memPutAddress(struct + (long)PCHKEY, MemoryUtil.memAddress(value));
    }

    public static void npchValue(long struct, ByteBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PCHVALUE, MemoryUtil.memAddress(value));
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)PCHKEY));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)PCHVALUE));
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            AppOverrideKeys.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = AppOverrideKeys.__struct(AppOverrideKeys.__member(POINTER_SIZE), AppOverrideKeys.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        PCHKEY = layout.offsetof(0);
        PCHVALUE = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<AppOverrideKeys, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected AppOverrideKeys newInstance(long address) {
            return new AppOverrideKeys(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="char *")
        public ByteBuffer pchKey() {
            return AppOverrideKeys.npchKey(this.address());
        }

        @NativeType(value="char *")
        public String pchKeyString() {
            return AppOverrideKeys.npchKeyString(this.address());
        }

        @NativeType(value="char *")
        public ByteBuffer pchValue(int capacity) {
            return AppOverrideKeys.npchValue(this.address(), capacity);
        }

        public Buffer pchKey(@NativeType(value="char *") ByteBuffer value) {
            AppOverrideKeys.npchKey(this.address(), value);
            return this;
        }

        public Buffer pchValue(@NativeType(value="char *") ByteBuffer value) {
            AppOverrideKeys.npchValue(this.address(), value);
            return this;
        }
    }
}

