/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.opengles.GLES;
import org.lwjgl.opengles.GLESCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class OESGetProgramBinary {
    public static final int GL_PROGRAM_BINARY_LENGTH_OES = 34625;
    public static final int GL_NUM_PROGRAM_BINARY_FORMATS_OES = 34814;
    public static final int GL_PROGRAM_BINARY_FORMATS_OES = 34815;

    protected OESGetProgramBinary() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLESCapabilities caps) {
        return Checks.checkFunctions(caps.glGetProgramBinaryOES, caps.glProgramBinaryOES);
    }

    public static native void nglGetProgramBinaryOES(int var0, int var1, long var2, long var4, long var6);

    public static void glGetProgramBinaryOES(@NativeType(value="GLuint") int program, @Nullable @NativeType(value="GLsizei *") IntBuffer length, @NativeType(value="GLenum *") IntBuffer binaryFormat, @NativeType(value="void *") ByteBuffer binary) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)length, 1);
            Checks.check((Buffer)binaryFormat, 1);
        }
        OESGetProgramBinary.nglGetProgramBinaryOES(program, binary.remaining(), MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(binaryFormat), MemoryUtil.memAddress(binary));
    }

    public static native void nglProgramBinaryOES(int var0, int var1, long var2, int var4);

    public static void glProgramBinaryOES(@NativeType(value="GLuint") int program, @NativeType(value="GLenum") int binaryFormat, @NativeType(value="void const *") ByteBuffer binary) {
        OESGetProgramBinary.nglProgramBinaryOES(program, binaryFormat, MemoryUtil.memAddress(binary), binary.remaining());
    }

    public static void glGetProgramBinaryOES(@NativeType(value="GLuint") int program, @Nullable @NativeType(value="GLsizei *") int[] length, @NativeType(value="GLenum *") int[] binaryFormat, @NativeType(value="void *") ByteBuffer binary) {
        long __functionAddress = GLES.getICD().glGetProgramBinaryOES;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.checkSafe(length, 1);
            Checks.check(binaryFormat, 1);
        }
        JNI.callPPPV(__functionAddress, program, binary.remaining(), length, binaryFormat, MemoryUtil.memAddress(binary));
    }

    static {
        GLES.initialize();
    }
}

