/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opencl;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct cl_mem_ext_host_ptr")
public class CLMemEXTHostPtr
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ALLOCATION_TYPE;
    public static final int HOST_CACHE_POLICY;

    CLMemEXTHostPtr(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public CLMemEXTHostPtr(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), CLMemEXTHostPtr.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="cl_uint")
    public int allocation_type() {
        return CLMemEXTHostPtr.nallocation_type(this.address());
    }

    @NativeType(value="cl_uint")
    public int host_cache_policy() {
        return CLMemEXTHostPtr.nhost_cache_policy(this.address());
    }

    public CLMemEXTHostPtr allocation_type(@NativeType(value="cl_uint") int value) {
        CLMemEXTHostPtr.nallocation_type(this.address(), value);
        return this;
    }

    public CLMemEXTHostPtr host_cache_policy(@NativeType(value="cl_uint") int value) {
        CLMemEXTHostPtr.nhost_cache_policy(this.address(), value);
        return this;
    }

    public CLMemEXTHostPtr set(int allocation_type, int host_cache_policy) {
        this.allocation_type(allocation_type);
        this.host_cache_policy(host_cache_policy);
        return this;
    }

    public CLMemEXTHostPtr set(CLMemEXTHostPtr src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static CLMemEXTHostPtr malloc() {
        return CLMemEXTHostPtr.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static CLMemEXTHostPtr calloc() {
        return CLMemEXTHostPtr.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static CLMemEXTHostPtr create() {
        return new CLMemEXTHostPtr(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static CLMemEXTHostPtr create(long address) {
        return new CLMemEXTHostPtr(address, null);
    }

    @Nullable
    public static CLMemEXTHostPtr createSafe(long address) {
        return address == 0L ? null : CLMemEXTHostPtr.create(address);
    }

    public static Buffer malloc(int capacity) {
        return CLMemEXTHostPtr.create(CLMemEXTHostPtr.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return CLMemEXTHostPtr.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(CLMemEXTHostPtr.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : CLMemEXTHostPtr.create(address, capacity);
    }

    public static CLMemEXTHostPtr mallocStack() {
        return CLMemEXTHostPtr.mallocStack(MemoryStack.stackGet());
    }

    public static CLMemEXTHostPtr callocStack() {
        return CLMemEXTHostPtr.callocStack(MemoryStack.stackGet());
    }

    public static CLMemEXTHostPtr mallocStack(MemoryStack stack) {
        return CLMemEXTHostPtr.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static CLMemEXTHostPtr callocStack(MemoryStack stack) {
        return CLMemEXTHostPtr.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return CLMemEXTHostPtr.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return CLMemEXTHostPtr.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return CLMemEXTHostPtr.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return CLMemEXTHostPtr.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nallocation_type(long struct) {
        return MemoryUtil.memGetInt(struct + (long)ALLOCATION_TYPE);
    }

    public static int nhost_cache_policy(long struct) {
        return MemoryUtil.memGetInt(struct + (long)HOST_CACHE_POLICY);
    }

    public static void nallocation_type(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)ALLOCATION_TYPE, value);
    }

    public static void nhost_cache_policy(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)HOST_CACHE_POLICY, value);
    }

    static {
        Struct.Layout layout = CLMemEXTHostPtr.__struct(CLMemEXTHostPtr.__member(4), CLMemEXTHostPtr.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        ALLOCATION_TYPE = layout.offsetof(0);
        HOST_CACHE_POLICY = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<CLMemEXTHostPtr, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected CLMemEXTHostPtr newInstance(long address) {
            return new CLMemEXTHostPtr(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="cl_uint")
        public int allocation_type() {
            return CLMemEXTHostPtr.nallocation_type(this.address());
        }

        @NativeType(value="cl_uint")
        public int host_cache_policy() {
            return CLMemEXTHostPtr.nhost_cache_policy(this.address());
        }

        public Buffer allocation_type(@NativeType(value="cl_uint") int value) {
            CLMemEXTHostPtr.nallocation_type(this.address(), value);
            return this;
        }

        public Buffer host_cache_policy(@NativeType(value="cl_uint") int value) {
            CLMemEXTHostPtr.nhost_cache_policy(this.address(), value);
            return this;
        }
    }
}

