/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opencl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import javax.annotation.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opencl.CL;
import org.lwjgl.opencl.CL11;
import org.lwjgl.opencl.CLCapabilities;
import org.lwjgl.opencl.CLImageDesc;
import org.lwjgl.opencl.CLImageFormat;
import org.lwjgl.opencl.CLProgramCallbackI;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class CL12
extends CL11 {
    public static final int CL_COMPILE_PROGRAM_FAILURE = -15;
    public static final int CL_LINKER_NOT_AVAILABLE = -16;
    public static final int CL_LINK_PROGRAM_FAILURE = -17;
    public static final int CL_DEVICE_PARTITION_FAILED = -18;
    public static final int CL_KERNEL_ARG_INFO_NOT_AVAILABLE = -19;
    public static final int CL_INVALID_IMAGE_DESCRIPTOR = -65;
    public static final int CL_INVALID_COMPILER_OPTIONS = -66;
    public static final int CL_INVALID_LINKER_OPTIONS = -67;
    public static final int CL_INVALID_DEVICE_PARTITION_COUNT = -68;
    public static final int CL_VERSION_1_2 = 1;
    public static final int CL_BLOCKING = 1;
    public static final int CL_NON_BLOCKING = 0;
    public static final int CL_DEVICE_TYPE_CUSTOM = 16;
    public static final int CL_DEVICE_DOUBLE_FP_CONFIG = 4146;
    public static final int CL_DEVICE_LINKER_AVAILABLE = 4158;
    public static final int CL_DEVICE_BUILT_IN_KERNELS = 4159;
    public static final int CL_DEVICE_IMAGE_MAX_BUFFER_SIZE = 4160;
    public static final int CL_DEVICE_IMAGE_MAX_ARRAY_SIZE = 4161;
    public static final int CL_DEVICE_PARENT_DEVICE = 4162;
    public static final int CL_DEVICE_PARTITION_MAX_SUB_DEVICES = 4163;
    public static final int CL_DEVICE_PARTITION_PROPERTIES = 4164;
    public static final int CL_DEVICE_PARTITION_AFFINITY_DOMAIN = 4165;
    public static final int CL_DEVICE_PARTITION_TYPE = 4166;
    public static final int CL_DEVICE_REFERENCE_COUNT = 4167;
    public static final int CL_DEVICE_PREFERRED_INTEROP_USER_SYNC = 4168;
    public static final int CL_DEVICE_PRINTF_BUFFER_SIZE = 4169;
    public static final int CL_FP_CORRECTLY_ROUNDED_DIVIDE_SQRT = 128;
    public static final int CL_CONTEXT_INTEROP_USER_SYNC = 4229;
    public static final int CL_DEVICE_PARTITION_BY_COUNTS_LIST_END = 0;
    public static final int CL_DEVICE_PARTITION_EQUALLY = 4230;
    public static final int CL_DEVICE_PARTITION_BY_COUNTS = 4231;
    public static final int CL_DEVICE_PARTITION_BY_AFFINITY_DOMAIN = 4232;
    public static final int CL_DEVICE_AFFINITY_DOMAIN_NUMA = 1;
    public static final int CL_DEVICE_AFFINITY_DOMAIN_L4_CACHE = 2;
    public static final int CL_DEVICE_AFFINITY_DOMAIN_L3_CACHE = 4;
    public static final int CL_DEVICE_AFFINITY_DOMAIN_L2_CACHE = 8;
    public static final int CL_DEVICE_AFFINITY_DOMAIN_L1_CACHE = 16;
    public static final int CL_DEVICE_AFFINITY_DOMAIN_NEXT_PARTITIONABLE = 32;
    public static final int CL_MEM_HOST_WRITE_ONLY = 128;
    public static final int CL_MEM_HOST_READ_ONLY = 256;
    public static final int CL_MEM_HOST_NO_ACCESS = 512;
    public static final int CL_MIGRATE_MEM_OBJECT_HOST = 1;
    public static final int CL_MIGRATE_MEM_OBJECT_CONTENT_UNDEFINED = 2;
    public static final int CL_MEM_OBJECT_IMAGE2D_ARRAY = 4339;
    public static final int CL_MEM_OBJECT_IMAGE1D = 4340;
    public static final int CL_MEM_OBJECT_IMAGE1D_ARRAY = 4341;
    public static final int CL_MEM_OBJECT_IMAGE1D_BUFFER = 4342;
    public static final int CL_IMAGE_ARRAY_SIZE = 4375;
    public static final int CL_IMAGE_BUFFER = 4376;
    public static final int CL_IMAGE_NUM_MIP_LEVELS = 4377;
    public static final int CL_IMAGE_NUM_SAMPLES = 4378;
    public static final int CL_MAP_WRITE_INVALIDATE_REGION = 4;
    public static final int CL_PROGRAM_NUM_KERNELS = 4455;
    public static final int CL_PROGRAM_KERNEL_NAMES = 4456;
    public static final int CL_PROGRAM_BINARY_TYPE = 4484;
    public static final int CL_PROGRAM_BINARY_TYPE_NONE = 0;
    public static final int CL_PROGRAM_BINARY_TYPE_COMPILED_OBJECT = 1;
    public static final int CL_PROGRAM_BINARY_TYPE_LIBRARY = 2;
    public static final int CL_PROGRAM_BINARY_TYPE_EXECUTABLE = 4;
    public static final int CL_KERNEL_ATTRIBUTES = 4501;
    public static final int CL_KERNEL_ARG_ADDRESS_QUALIFIER = 4502;
    public static final int CL_KERNEL_ARG_ACCESS_QUALIFIER = 4503;
    public static final int CL_KERNEL_ARG_TYPE_NAME = 4504;
    public static final int CL_KERNEL_ARG_TYPE_QUALIFIER = 6553;
    public static final int CL_KERNEL_ARG_NAME = 4506;
    public static final int CL_KERNEL_ARG_ADDRESS_GLOBAL = 4506;
    public static final int CL_KERNEL_ARG_ADDRESS_LOCAL = 4507;
    public static final int CL_KERNEL_ARG_ADDRESS_CONSTANT = 4508;
    public static final int CL_KERNEL_ARG_ADDRESS_PRIVATE = 4509;
    public static final int CL_KERNEL_ARG_ACCESS_READ_ONLY = 4512;
    public static final int CL_KERNEL_ARG_ACCESS_WRITE_ONLY = 4513;
    public static final int CL_KERNEL_ARG_ACCESS_READ_WRITE = 4514;
    public static final int CL_KERNEL_ARG_ACCESS_NONE = 4515;
    public static final int CL_KERNEL_ARG_TYPE_NONE = 0;
    public static final int CL_KERNEL_ARG_TYPE_CONST = 1;
    public static final int CL_KERNEL_ARG_TYPE_RESTRICT = 2;
    public static final int CL_KERNEL_ARG_TYPE_VOLATILE = 4;
    public static final int CL_KERNEL_GLOBAL_WORK_SIZE = 4533;
    public static final int CL_COMMAND_BARRIER = 4613;
    public static final int CL_COMMAND_MIGRATE_MEM_OBJECTS = 4614;
    public static final int CL_COMMAND_FILL_BUFFER = 4615;
    public static final int CL_COMMAND_FILL_IMAGE = 4616;

    protected CL12() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(CLCapabilities caps) {
        return Checks.checkFunctions(caps.clGetExtensionFunctionAddressForPlatform, caps.clRetainDevice, caps.clReleaseDevice, caps.clCreateSubDevices, caps.clCreateImage, caps.clCreateProgramWithBuiltInKernels, caps.clCompileProgram, caps.clLinkProgram, caps.clUnloadPlatformCompiler, caps.clGetKernelArgInfo, caps.clEnqueueFillBuffer, caps.clEnqueueFillImage, caps.clEnqueueMigrateMemObjects, caps.clEnqueueMarkerWithWaitList, caps.clEnqueueBarrierWithWaitList);
    }

    public static long nclGetExtensionFunctionAddressForPlatform(long platform, long funcname) {
        long __functionAddress = CL.getICD().clGetExtensionFunctionAddressForPlatform;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(platform);
        }
        return JNI.callPPP(__functionAddress, platform, funcname);
    }

    @NativeType(value="void *")
    public static long clGetExtensionFunctionAddressForPlatform(@NativeType(value="cl_platform_id") long platform, @NativeType(value="cl_char const *") ByteBuffer funcname) {
        if (Checks.CHECKS) {
            Checks.checkNT1(funcname);
        }
        return CL12.nclGetExtensionFunctionAddressForPlatform(platform, MemoryUtil.memAddress(funcname));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="void *")
    public static long clGetExtensionFunctionAddressForPlatform(@NativeType(value="cl_platform_id") long platform, @NativeType(value="cl_char const *") CharSequence funcname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer funcnameEncoded = stack.ASCII(funcname);
            long l = CL12.nclGetExtensionFunctionAddressForPlatform(platform, MemoryUtil.memAddress(funcnameEncoded));
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="cl_int")
    public static int clRetainDevice(@NativeType(value="cl_device_id") long device) {
        long __functionAddress = CL.getICD().clRetainDevice;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(device);
        }
        return JNI.callPI(__functionAddress, device);
    }

    @NativeType(value="cl_int")
    public static int clReleaseDevice(@NativeType(value="cl_device_id") long device) {
        long __functionAddress = CL.getICD().clReleaseDevice;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(device);
        }
        return JNI.callPI(__functionAddress, device);
    }

    public static int nclCreateSubDevices(long in_device, long properties, int num_devices, long out_devices, long num_devices_ret) {
        long __functionAddress = CL.getICD().clCreateSubDevices;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(in_device);
        }
        return JNI.callPPPPI(__functionAddress, in_device, properties, num_devices, out_devices, num_devices_ret);
    }

    @NativeType(value="cl_int")
    public static int clCreateSubDevices(@NativeType(value="cl_device_id") long in_device, @NativeType(value="cl_device_partition_property const *") PointerBuffer properties, @Nullable @NativeType(value="cl_device_id *") PointerBuffer out_devices, @Nullable @NativeType(value="cl_uint *") IntBuffer num_devices_ret) {
        if (Checks.CHECKS) {
            Checks.checkNT(properties);
            Checks.checkSafe((Buffer)num_devices_ret, 1);
        }
        return CL12.nclCreateSubDevices(in_device, MemoryUtil.memAddress(properties), Checks.remainingSafe(out_devices), MemoryUtil.memAddressSafe(out_devices), MemoryUtil.memAddressSafe(num_devices_ret));
    }

    public static long nclCreateImage(long context, long flags, long image_format, long image_desc, long host_ptr, long errcode_ret) {
        long __functionAddress = CL.getICD().clCreateImage;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(context);
        }
        return JNI.callPJPPPPP(__functionAddress, context, flags, image_format, image_desc, host_ptr, errcode_ret);
    }

    @NativeType(value="cl_mem")
    public static long clCreateImage(@NativeType(value="cl_context") long context, @NativeType(value="cl_mem_flags") long flags, @NativeType(value="cl_image_format const *") CLImageFormat image_format, @NativeType(value="cl_image_desc const *") CLImageDesc image_desc, @Nullable @NativeType(value="void *") ByteBuffer host_ptr, @Nullable @NativeType(value="cl_int *") IntBuffer errcode_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)errcode_ret, 1);
        }
        return CL12.nclCreateImage(context, flags, image_format.address(), image_desc.address(), MemoryUtil.memAddressSafe(host_ptr), MemoryUtil.memAddressSafe(errcode_ret));
    }

    @NativeType(value="cl_mem")
    public static long clCreateImage(@NativeType(value="cl_context") long context, @NativeType(value="cl_mem_flags") long flags, @NativeType(value="cl_image_format const *") CLImageFormat image_format, @NativeType(value="cl_image_desc const *") CLImageDesc image_desc, @Nullable @NativeType(value="void *") ShortBuffer host_ptr, @Nullable @NativeType(value="cl_int *") IntBuffer errcode_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)errcode_ret, 1);
        }
        return CL12.nclCreateImage(context, flags, image_format.address(), image_desc.address(), MemoryUtil.memAddressSafe(host_ptr), MemoryUtil.memAddressSafe(errcode_ret));
    }

    @NativeType(value="cl_mem")
    public static long clCreateImage(@NativeType(value="cl_context") long context, @NativeType(value="cl_mem_flags") long flags, @NativeType(value="cl_image_format const *") CLImageFormat image_format, @NativeType(value="cl_image_desc const *") CLImageDesc image_desc, @Nullable @NativeType(value="void *") IntBuffer host_ptr, @Nullable @NativeType(value="cl_int *") IntBuffer errcode_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)errcode_ret, 1);
        }
        return CL12.nclCreateImage(context, flags, image_format.address(), image_desc.address(), MemoryUtil.memAddressSafe(host_ptr), MemoryUtil.memAddressSafe(errcode_ret));
    }

    @NativeType(value="cl_mem")
    public static long clCreateImage(@NativeType(value="cl_context") long context, @NativeType(value="cl_mem_flags") long flags, @NativeType(value="cl_image_format const *") CLImageFormat image_format, @NativeType(value="cl_image_desc const *") CLImageDesc image_desc, @Nullable @NativeType(value="void *") FloatBuffer host_ptr, @Nullable @NativeType(value="cl_int *") IntBuffer errcode_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)errcode_ret, 1);
        }
        return CL12.nclCreateImage(context, flags, image_format.address(), image_desc.address(), MemoryUtil.memAddressSafe(host_ptr), MemoryUtil.memAddressSafe(errcode_ret));
    }

    public static long nclCreateProgramWithBuiltInKernels(long context, int num_devices, long device_list, long kernel_names, long errcode_ret) {
        long __functionAddress = CL.getICD().clCreateProgramWithBuiltInKernels;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(context);
        }
        return JNI.callPPPPP(__functionAddress, context, num_devices, device_list, kernel_names, errcode_ret);
    }

    @NativeType(value="cl_program")
    public static long clCreateProgramWithBuiltInKernels(@NativeType(value="cl_context") long context, @NativeType(value="cl_device_id const *") PointerBuffer device_list, @NativeType(value="cl_char const *") ByteBuffer kernel_names, @Nullable @NativeType(value="cl_int *") IntBuffer errcode_ret) {
        if (Checks.CHECKS) {
            Checks.checkNT1(kernel_names);
            Checks.checkSafe((Buffer)errcode_ret, 1);
        }
        return CL12.nclCreateProgramWithBuiltInKernels(context, device_list.remaining(), MemoryUtil.memAddress(device_list), MemoryUtil.memAddress(kernel_names), MemoryUtil.memAddressSafe(errcode_ret));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="cl_program")
    public static long clCreateProgramWithBuiltInKernels(@NativeType(value="cl_context") long context, @NativeType(value="cl_device_id const *") PointerBuffer device_list, @NativeType(value="cl_char const *") CharSequence kernel_names, @Nullable @NativeType(value="cl_int *") IntBuffer errcode_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)errcode_ret, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer kernel_namesEncoded = stack.ASCII(kernel_names);
            long l = CL12.nclCreateProgramWithBuiltInKernels(context, device_list.remaining(), MemoryUtil.memAddress(device_list), MemoryUtil.memAddress(kernel_namesEncoded), MemoryUtil.memAddressSafe(errcode_ret));
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="cl_program")
    public static long clCreateProgramWithBuiltInKernels(@NativeType(value="cl_context") long context, @NativeType(value="cl_device_id const *") long device, @NativeType(value="cl_char const *") CharSequence kernel_names, @Nullable @NativeType(value="cl_int *") IntBuffer errcode_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)errcode_ret, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer kernel_namesEncoded = stack.ASCII(kernel_names);
            PointerBuffer device_list = stack.pointers(device);
            long l = CL12.nclCreateProgramWithBuiltInKernels(context, 1, MemoryUtil.memAddress(device_list), MemoryUtil.memAddress(kernel_namesEncoded), MemoryUtil.memAddressSafe(errcode_ret));
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nclCompileProgram(long program, int num_devices, long device_list, long options, int num_input_headers, long input_headers, long header_include_names, long pfn_notify, long user_data) {
        long __functionAddress = CL.getICD().clCompileProgram;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(program);
        }
        return JNI.callPPPPPPPI(__functionAddress, program, num_devices, device_list, options, num_input_headers, input_headers, header_include_names, pfn_notify, user_data);
    }

    @NativeType(value="cl_int")
    public static int clCompileProgram(@NativeType(value="cl_program") long program, @Nullable @NativeType(value="cl_device_id const *") PointerBuffer device_list, @NativeType(value="cl_char const *") ByteBuffer options, @Nullable @NativeType(value="cl_program const *") PointerBuffer input_headers, @Nullable @NativeType(value="cl_char const **") PointerBuffer header_include_names, @Nullable @NativeType(value="void (*) (cl_program, void *)") CLProgramCallbackI pfn_notify, @NativeType(value="void *") long user_data) {
        if (Checks.CHECKS) {
            Checks.checkNT1(options);
            Checks.checkSafe(header_include_names, Checks.remainingSafe(input_headers));
        }
        return CL12.nclCompileProgram(program, Checks.remainingSafe(device_list), MemoryUtil.memAddressSafe(device_list), MemoryUtil.memAddress(options), Checks.remainingSafe(input_headers), MemoryUtil.memAddressSafe(input_headers), MemoryUtil.memAddressSafe(header_include_names), MemoryUtil.memAddressSafe(pfn_notify), user_data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="cl_int")
    public static int clCompileProgram(@NativeType(value="cl_program") long program, @Nullable @NativeType(value="cl_device_id const *") PointerBuffer device_list, @NativeType(value="cl_char const *") CharSequence options, @Nullable @NativeType(value="cl_program const *") PointerBuffer input_headers, @Nullable @NativeType(value="cl_char const **") PointerBuffer header_include_names, @Nullable @NativeType(value="void (*) (cl_program, void *)") CLProgramCallbackI pfn_notify, @NativeType(value="void *") long user_data) {
        if (Checks.CHECKS) {
            Checks.checkSafe(header_include_names, Checks.remainingSafe(input_headers));
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer optionsEncoded = stack.ASCII(options);
            int n = CL12.nclCompileProgram(program, Checks.remainingSafe(device_list), MemoryUtil.memAddressSafe(device_list), MemoryUtil.memAddress(optionsEncoded), Checks.remainingSafe(input_headers), MemoryUtil.memAddressSafe(input_headers), MemoryUtil.memAddressSafe(header_include_names), MemoryUtil.memAddressSafe(pfn_notify), user_data);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nclLinkProgram(long context, int num_devices, long device_list, long options, int num_input_programs, long input_programs, long pfn_notify, long user_data) {
        long __functionAddress = CL.getICD().clLinkProgram;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(context);
        }
        return JNI.callPPPPPPP(__functionAddress, context, num_devices, device_list, options, num_input_programs, input_programs, pfn_notify, user_data);
    }

    @NativeType(value="cl_program")
    public static long clLinkProgram(@NativeType(value="cl_context") long context, @Nullable @NativeType(value="cl_device_id const *") PointerBuffer device_list, @NativeType(value="cl_char const *") ByteBuffer options, @Nullable @NativeType(value="cl_program const *") PointerBuffer input_programs, @Nullable @NativeType(value="void (*) (cl_program, void *)") CLProgramCallbackI pfn_notify, @NativeType(value="void *") long user_data) {
        if (Checks.CHECKS) {
            Checks.checkNT1(options);
        }
        return CL12.nclLinkProgram(context, Checks.remainingSafe(device_list), MemoryUtil.memAddressSafe(device_list), MemoryUtil.memAddress(options), Checks.remainingSafe(input_programs), MemoryUtil.memAddressSafe(input_programs), MemoryUtil.memAddressSafe(pfn_notify), user_data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="cl_program")
    public static long clLinkProgram(@NativeType(value="cl_context") long context, @Nullable @NativeType(value="cl_device_id const *") PointerBuffer device_list, @NativeType(value="cl_char const *") CharSequence options, @Nullable @NativeType(value="cl_program const *") PointerBuffer input_programs, @Nullable @NativeType(value="void (*) (cl_program, void *)") CLProgramCallbackI pfn_notify, @NativeType(value="void *") long user_data) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer optionsEncoded = stack.ASCII(options);
            long l = CL12.nclLinkProgram(context, Checks.remainingSafe(device_list), MemoryUtil.memAddressSafe(device_list), MemoryUtil.memAddress(optionsEncoded), Checks.remainingSafe(input_programs), MemoryUtil.memAddressSafe(input_programs), MemoryUtil.memAddressSafe(pfn_notify), user_data);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="cl_program")
    public static long clLinkProgram(@NativeType(value="cl_context") long context, @Nullable @NativeType(value="cl_device_id const *") PointerBuffer device_list, @NativeType(value="cl_char const *") CharSequence options, @Nullable @NativeType(value="cl_program const *") long input_program, @Nullable @NativeType(value="void (*) (cl_program, void *)") CLProgramCallbackI pfn_notify, @NativeType(value="void *") long user_data) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer optionsEncoded = stack.ASCII(options);
            PointerBuffer input_programs = stack.pointers(input_program);
            long l = CL12.nclLinkProgram(context, Checks.remainingSafe(device_list), MemoryUtil.memAddressSafe(device_list), MemoryUtil.memAddress(optionsEncoded), 1, MemoryUtil.memAddress(input_programs), MemoryUtil.memAddressSafe(pfn_notify), user_data);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="cl_int")
    public static int clUnloadPlatformCompiler(@NativeType(value="cl_platform_id") long platform) {
        long __functionAddress = CL.getICD().clUnloadPlatformCompiler;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(platform);
        }
        return JNI.callPI(__functionAddress, platform);
    }

    public static int nclGetKernelArgInfo(long kernel, int arg_indx, int param_name, long param_value_size, long param_value, long param_value_size_ret) {
        long __functionAddress = CL.getICD().clGetKernelArgInfo;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(kernel);
        }
        return JNI.callPPPPI(__functionAddress, kernel, arg_indx, param_name, param_value_size, param_value, param_value_size_ret);
    }

    @NativeType(value="cl_int")
    public static int clGetKernelArgInfo(@NativeType(value="cl_kernel") long kernel, @NativeType(value="cl_uint") int arg_indx, @NativeType(value="cl_kernel_arg_info") int param_name, @Nullable @NativeType(value="void *") ByteBuffer param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe(param_value_size_ret, 1);
        }
        return CL12.nclGetKernelArgInfo(kernel, arg_indx, param_name, Checks.remainingSafe(param_value), MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    @NativeType(value="cl_int")
    public static int clGetKernelArgInfo(@NativeType(value="cl_kernel") long kernel, @NativeType(value="cl_uint") int arg_indx, @NativeType(value="cl_kernel_arg_info") int param_name, @Nullable @NativeType(value="void *") IntBuffer param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe(param_value_size_ret, 1);
        }
        return CL12.nclGetKernelArgInfo(kernel, arg_indx, param_name, Integer.toUnsignedLong(Checks.remainingSafe(param_value)) << 2, MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    @NativeType(value="cl_int")
    public static int clGetKernelArgInfo(@NativeType(value="cl_kernel") long kernel, @NativeType(value="cl_uint") int arg_indx, @NativeType(value="cl_kernel_arg_info") int param_name, @Nullable @NativeType(value="void *") LongBuffer param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe(param_value_size_ret, 1);
        }
        return CL12.nclGetKernelArgInfo(kernel, arg_indx, param_name, Integer.toUnsignedLong(Checks.remainingSafe(param_value)) << 3, MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    public static int nclEnqueueFillBuffer(long command_queue, long buffer, long pattern, long pattern_size, long offset, long size, int num_events_in_wait_list, long event_wait_list, long event) {
        long __functionAddress = CL.getICD().clEnqueueFillBuffer;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(command_queue);
            Checks.check(buffer);
        }
        return JNI.callPPPPPPPPI(__functionAddress, command_queue, buffer, pattern, pattern_size, offset, size, num_events_in_wait_list, event_wait_list, event);
    }

    @NativeType(value="cl_int")
    public static int clEnqueueFillBuffer(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long buffer, @NativeType(value="void const *") ByteBuffer pattern, @NativeType(value="size_t") long offset, @NativeType(value="size_t") long size, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event) {
        if (Checks.CHECKS) {
            Checks.checkSafe(event, 1);
        }
        return CL12.nclEnqueueFillBuffer(command_queue, buffer, MemoryUtil.memAddress(pattern), pattern.remaining(), offset, size, Checks.remainingSafe(event_wait_list), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static int nclEnqueueFillImage(long command_queue, long image, long fill_color, long origin, long region, int num_events_in_wait_list, long event_wait_list, long event) {
        long __functionAddress = CL.getICD().clEnqueueFillImage;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(command_queue);
            Checks.check(image);
        }
        return JNI.callPPPPPPPI(__functionAddress, command_queue, image, fill_color, origin, region, num_events_in_wait_list, event_wait_list, event);
    }

    @NativeType(value="cl_int")
    public static int clEnqueueFillImage(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long image, @NativeType(value="void const *") ByteBuffer fill_color, @NativeType(value="size_t const *") PointerBuffer origin, @NativeType(value="size_t const *") PointerBuffer region, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)fill_color, 16);
            Checks.check(origin, 1);
            Checks.check(region, 1);
            Checks.checkSafe(event, 1);
        }
        return CL12.nclEnqueueFillImage(command_queue, image, MemoryUtil.memAddress(fill_color), MemoryUtil.memAddress(origin), MemoryUtil.memAddress(region), Checks.remainingSafe(event_wait_list), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    @NativeType(value="cl_int")
    public static int clEnqueueFillImage(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long image, @NativeType(value="void const *") IntBuffer fill_color, @NativeType(value="size_t const *") PointerBuffer origin, @NativeType(value="size_t const *") PointerBuffer region, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)fill_color, 4);
            Checks.check(origin, 1);
            Checks.check(region, 1);
            Checks.checkSafe(event, 1);
        }
        return CL12.nclEnqueueFillImage(command_queue, image, MemoryUtil.memAddress(fill_color), MemoryUtil.memAddress(origin), MemoryUtil.memAddress(region), Checks.remainingSafe(event_wait_list), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    @NativeType(value="cl_int")
    public static int clEnqueueFillImage(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long image, @NativeType(value="void const *") FloatBuffer fill_color, @NativeType(value="size_t const *") PointerBuffer origin, @NativeType(value="size_t const *") PointerBuffer region, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)fill_color, 4);
            Checks.check(origin, 1);
            Checks.check(region, 1);
            Checks.checkSafe(event, 1);
        }
        return CL12.nclEnqueueFillImage(command_queue, image, MemoryUtil.memAddress(fill_color), MemoryUtil.memAddress(origin), MemoryUtil.memAddress(region), Checks.remainingSafe(event_wait_list), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static int nclEnqueueMigrateMemObjects(long command_queue, int num_mem_objects, long mem_objects, long flags, int num_events_in_wait_list, long event_wait_list, long event) {
        long __functionAddress = CL.getICD().clEnqueueMigrateMemObjects;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(command_queue);
        }
        return JNI.callPPJPPI(__functionAddress, command_queue, num_mem_objects, mem_objects, flags, num_events_in_wait_list, event_wait_list, event);
    }

    @NativeType(value="cl_int")
    public static int clEnqueueMigrateMemObjects(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem const *") PointerBuffer mem_objects, @NativeType(value="cl_mem_migration_flags") long flags, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event) {
        if (Checks.CHECKS) {
            Checks.checkSafe(event, 1);
        }
        return CL12.nclEnqueueMigrateMemObjects(command_queue, mem_objects.remaining(), MemoryUtil.memAddress(mem_objects), flags, Checks.remainingSafe(event_wait_list), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static int nclEnqueueMarkerWithWaitList(long command_queue, int num_events_in_wait_list, long event_wait_list, long event) {
        long __functionAddress = CL.getICD().clEnqueueMarkerWithWaitList;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(command_queue);
        }
        return JNI.callPPPI(__functionAddress, command_queue, num_events_in_wait_list, event_wait_list, event);
    }

    @NativeType(value="cl_int")
    public static int clEnqueueMarkerWithWaitList(@NativeType(value="cl_command_queue") long command_queue, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event) {
        if (Checks.CHECKS) {
            Checks.checkSafe(event, 1);
        }
        return CL12.nclEnqueueMarkerWithWaitList(command_queue, Checks.remainingSafe(event_wait_list), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static int nclEnqueueBarrierWithWaitList(long command_queue, int num_events_in_wait_list, long event_wait_list, long event) {
        long __functionAddress = CL.getICD().clEnqueueBarrierWithWaitList;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(command_queue);
        }
        return JNI.callPPPI(__functionAddress, command_queue, num_events_in_wait_list, event_wait_list, event);
    }

    @NativeType(value="cl_int")
    public static int clEnqueueBarrierWithWaitList(@NativeType(value="cl_command_queue") long command_queue, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event) {
        if (Checks.CHECKS) {
            Checks.checkSafe(event, 1);
        }
        return CL12.nclEnqueueBarrierWithWaitList(command_queue, Checks.remainingSafe(event_wait_list), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    @NativeType(value="cl_int")
    public static int clCreateSubDevices(@NativeType(value="cl_device_id") long in_device, @NativeType(value="cl_device_partition_property const *") PointerBuffer properties, @Nullable @NativeType(value="cl_device_id *") PointerBuffer out_devices, @Nullable @NativeType(value="cl_uint *") int[] num_devices_ret) {
        long __functionAddress = CL.getICD().clCreateSubDevices;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(in_device);
            Checks.checkNT(properties);
            Checks.checkSafe(num_devices_ret, 1);
        }
        return JNI.callPPPPI(__functionAddress, in_device, MemoryUtil.memAddress(properties), Checks.remainingSafe(out_devices), MemoryUtil.memAddressSafe(out_devices), num_devices_ret);
    }

    @NativeType(value="cl_mem")
    public static long clCreateImage(@NativeType(value="cl_context") long context, @NativeType(value="cl_mem_flags") long flags, @NativeType(value="cl_image_format const *") CLImageFormat image_format, @NativeType(value="cl_image_desc const *") CLImageDesc image_desc, @Nullable @NativeType(value="void *") ByteBuffer host_ptr, @Nullable @NativeType(value="cl_int *") int[] errcode_ret) {
        long __functionAddress = CL.getICD().clCreateImage;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(context);
            Checks.checkSafe(errcode_ret, 1);
        }
        return JNI.callPJPPPPP(__functionAddress, context, flags, image_format.address(), image_desc.address(), MemoryUtil.memAddressSafe(host_ptr), errcode_ret);
    }

    @NativeType(value="cl_mem")
    public static long clCreateImage(@NativeType(value="cl_context") long context, @NativeType(value="cl_mem_flags") long flags, @NativeType(value="cl_image_format const *") CLImageFormat image_format, @NativeType(value="cl_image_desc const *") CLImageDesc image_desc, @Nullable @NativeType(value="void *") short[] host_ptr, @Nullable @NativeType(value="cl_int *") int[] errcode_ret) {
        long __functionAddress = CL.getICD().clCreateImage;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(context);
            Checks.checkSafe(errcode_ret, 1);
        }
        return JNI.callPJPPPPP(__functionAddress, context, flags, image_format.address(), image_desc.address(), host_ptr, errcode_ret);
    }

    @NativeType(value="cl_mem")
    public static long clCreateImage(@NativeType(value="cl_context") long context, @NativeType(value="cl_mem_flags") long flags, @NativeType(value="cl_image_format const *") CLImageFormat image_format, @NativeType(value="cl_image_desc const *") CLImageDesc image_desc, @Nullable @NativeType(value="void *") int[] host_ptr, @Nullable @NativeType(value="cl_int *") int[] errcode_ret) {
        long __functionAddress = CL.getICD().clCreateImage;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(context);
            Checks.checkSafe(errcode_ret, 1);
        }
        return JNI.callPJPPPPP(__functionAddress, context, flags, image_format.address(), image_desc.address(), host_ptr, errcode_ret);
    }

    @NativeType(value="cl_mem")
    public static long clCreateImage(@NativeType(value="cl_context") long context, @NativeType(value="cl_mem_flags") long flags, @NativeType(value="cl_image_format const *") CLImageFormat image_format, @NativeType(value="cl_image_desc const *") CLImageDesc image_desc, @Nullable @NativeType(value="void *") float[] host_ptr, @Nullable @NativeType(value="cl_int *") int[] errcode_ret) {
        long __functionAddress = CL.getICD().clCreateImage;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(context);
            Checks.checkSafe(errcode_ret, 1);
        }
        return JNI.callPJPPPPP(__functionAddress, context, flags, image_format.address(), image_desc.address(), host_ptr, errcode_ret);
    }

    @NativeType(value="cl_program")
    public static long clCreateProgramWithBuiltInKernels(@NativeType(value="cl_context") long context, @NativeType(value="cl_device_id const *") PointerBuffer device_list, @NativeType(value="cl_char const *") ByteBuffer kernel_names, @Nullable @NativeType(value="cl_int *") int[] errcode_ret) {
        long __functionAddress = CL.getICD().clCreateProgramWithBuiltInKernels;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(context);
            Checks.checkNT1(kernel_names);
            Checks.checkSafe(errcode_ret, 1);
        }
        return JNI.callPPPPP(__functionAddress, context, device_list.remaining(), MemoryUtil.memAddress(device_list), MemoryUtil.memAddress(kernel_names), errcode_ret);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="cl_program")
    public static long clCreateProgramWithBuiltInKernels(@NativeType(value="cl_context") long context, @NativeType(value="cl_device_id const *") PointerBuffer device_list, @NativeType(value="cl_char const *") CharSequence kernel_names, @Nullable @NativeType(value="cl_int *") int[] errcode_ret) {
        long __functionAddress = CL.getICD().clCreateProgramWithBuiltInKernels;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(context);
            Checks.checkSafe(errcode_ret, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer kernel_namesEncoded = stack.ASCII(kernel_names);
            long l = JNI.callPPPPP(__functionAddress, context, device_list.remaining(), MemoryUtil.memAddress(device_list), MemoryUtil.memAddress(kernel_namesEncoded), errcode_ret);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="cl_int")
    public static int clGetKernelArgInfo(@NativeType(value="cl_kernel") long kernel, @NativeType(value="cl_uint") int arg_indx, @NativeType(value="cl_kernel_arg_info") int param_name, @Nullable @NativeType(value="void *") int[] param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        long __functionAddress = CL.getICD().clGetKernelArgInfo;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(kernel);
            Checks.checkSafe(param_value_size_ret, 1);
        }
        return JNI.callPPPPI(__functionAddress, kernel, arg_indx, param_name, Integer.toUnsignedLong(Checks.lengthSafe(param_value)) << 2, param_value, MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    @NativeType(value="cl_int")
    public static int clGetKernelArgInfo(@NativeType(value="cl_kernel") long kernel, @NativeType(value="cl_uint") int arg_indx, @NativeType(value="cl_kernel_arg_info") int param_name, @Nullable @NativeType(value="void *") long[] param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        long __functionAddress = CL.getICD().clGetKernelArgInfo;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(kernel);
            Checks.checkSafe(param_value_size_ret, 1);
        }
        return JNI.callPPPPI(__functionAddress, kernel, arg_indx, param_name, Integer.toUnsignedLong(Checks.lengthSafe(param_value)) << 3, param_value, MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    @NativeType(value="cl_int")
    public static int clEnqueueFillImage(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long image, @NativeType(value="void const *") int[] fill_color, @NativeType(value="size_t const *") PointerBuffer origin, @NativeType(value="size_t const *") PointerBuffer region, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event) {
        long __functionAddress = CL.getICD().clEnqueueFillImage;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(command_queue);
            Checks.check(image);
            Checks.check(fill_color, 4);
            Checks.check(origin, 1);
            Checks.check(region, 1);
            Checks.checkSafe(event, 1);
        }
        return JNI.callPPPPPPPI(__functionAddress, command_queue, image, fill_color, MemoryUtil.memAddress(origin), MemoryUtil.memAddress(region), Checks.remainingSafe(event_wait_list), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    @NativeType(value="cl_int")
    public static int clEnqueueFillImage(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long image, @NativeType(value="void const *") float[] fill_color, @NativeType(value="size_t const *") PointerBuffer origin, @NativeType(value="size_t const *") PointerBuffer region, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event) {
        long __functionAddress = CL.getICD().clEnqueueFillImage;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(command_queue);
            Checks.check(image);
            Checks.check(fill_color, 4);
            Checks.check(origin, 1);
            Checks.check(region, 1);
            Checks.checkSafe(event, 1);
        }
        return JNI.callPPPPPPPI(__functionAddress, command_queue, image, fill_color, MemoryUtil.memAddress(origin), MemoryUtil.memAddress(region), Checks.remainingSafe(event_wait_list), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }
}

