/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.odbc;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class SQL_TIME_STRUCT
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int HOUR;
    public static final int MINUTE;
    public static final int SECOND;

    SQL_TIME_STRUCT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public SQL_TIME_STRUCT(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), SQL_TIME_STRUCT.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="SQLUSMALLINT")
    public short hour() {
        return SQL_TIME_STRUCT.nhour(this.address());
    }

    @NativeType(value="SQLUSMALLINT")
    public short minute() {
        return SQL_TIME_STRUCT.nminute(this.address());
    }

    @NativeType(value="SQLUSMALLINT")
    public short second() {
        return SQL_TIME_STRUCT.nsecond(this.address());
    }

    public SQL_TIME_STRUCT hour(@NativeType(value="SQLUSMALLINT") short value) {
        SQL_TIME_STRUCT.nhour(this.address(), value);
        return this;
    }

    public SQL_TIME_STRUCT minute(@NativeType(value="SQLUSMALLINT") short value) {
        SQL_TIME_STRUCT.nminute(this.address(), value);
        return this;
    }

    public SQL_TIME_STRUCT second(@NativeType(value="SQLUSMALLINT") short value) {
        SQL_TIME_STRUCT.nsecond(this.address(), value);
        return this;
    }

    public SQL_TIME_STRUCT set(short hour, short minute, short second) {
        this.hour(hour);
        this.minute(minute);
        this.second(second);
        return this;
    }

    public SQL_TIME_STRUCT set(SQL_TIME_STRUCT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static SQL_TIME_STRUCT malloc() {
        return SQL_TIME_STRUCT.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static SQL_TIME_STRUCT calloc() {
        return SQL_TIME_STRUCT.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static SQL_TIME_STRUCT create() {
        return new SQL_TIME_STRUCT(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static SQL_TIME_STRUCT create(long address) {
        return new SQL_TIME_STRUCT(address, null);
    }

    @Nullable
    public static SQL_TIME_STRUCT createSafe(long address) {
        return address == 0L ? null : SQL_TIME_STRUCT.create(address);
    }

    public static Buffer malloc(int capacity) {
        return SQL_TIME_STRUCT.create(SQL_TIME_STRUCT.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return SQL_TIME_STRUCT.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(SQL_TIME_STRUCT.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : SQL_TIME_STRUCT.create(address, capacity);
    }

    public static SQL_TIME_STRUCT mallocStack() {
        return SQL_TIME_STRUCT.mallocStack(MemoryStack.stackGet());
    }

    public static SQL_TIME_STRUCT callocStack() {
        return SQL_TIME_STRUCT.callocStack(MemoryStack.stackGet());
    }

    public static SQL_TIME_STRUCT mallocStack(MemoryStack stack) {
        return SQL_TIME_STRUCT.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static SQL_TIME_STRUCT callocStack(MemoryStack stack) {
        return SQL_TIME_STRUCT.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return SQL_TIME_STRUCT.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return SQL_TIME_STRUCT.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return SQL_TIME_STRUCT.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return SQL_TIME_STRUCT.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static short nhour(long struct) {
        return MemoryUtil.memGetShort(struct + (long)HOUR);
    }

    public static short nminute(long struct) {
        return MemoryUtil.memGetShort(struct + (long)MINUTE);
    }

    public static short nsecond(long struct) {
        return MemoryUtil.memGetShort(struct + (long)SECOND);
    }

    public static void nhour(long struct, short value) {
        MemoryUtil.memPutShort(struct + (long)HOUR, value);
    }

    public static void nminute(long struct, short value) {
        MemoryUtil.memPutShort(struct + (long)MINUTE, value);
    }

    public static void nsecond(long struct, short value) {
        MemoryUtil.memPutShort(struct + (long)SECOND, value);
    }

    static {
        Struct.Layout layout = SQL_TIME_STRUCT.__struct(SQL_TIME_STRUCT.__member(2), SQL_TIME_STRUCT.__member(2), SQL_TIME_STRUCT.__member(2));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        HOUR = layout.offsetof(0);
        MINUTE = layout.offsetof(1);
        SECOND = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<SQL_TIME_STRUCT, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected SQL_TIME_STRUCT newInstance(long address) {
            return new SQL_TIME_STRUCT(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="SQLUSMALLINT")
        public short hour() {
            return SQL_TIME_STRUCT.nhour(this.address());
        }

        @NativeType(value="SQLUSMALLINT")
        public short minute() {
            return SQL_TIME_STRUCT.nminute(this.address());
        }

        @NativeType(value="SQLUSMALLINT")
        public short second() {
            return SQL_TIME_STRUCT.nsecond(this.address());
        }

        public Buffer hour(@NativeType(value="SQLUSMALLINT") short value) {
            SQL_TIME_STRUCT.nhour(this.address(), value);
            return this;
        }

        public Buffer minute(@NativeType(value="SQLUSMALLINT") short value) {
            SQL_TIME_STRUCT.nminute(this.address(), value);
            return this;
        }

        public Buffer second(@NativeType(value="SQLUSMALLINT") short value) {
            SQL_TIME_STRUCT.nsecond(this.address(), value);
            return this;
        }
    }
}

