/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.odbc;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.odbc.SQL_DAY_SECOND_STRUCT;
import org.lwjgl.odbc.SQL_YEAR_MONTH_STRUCT;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class SQL_INTERVAL_STRUCT
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int INTERVAL_TYPE;
    public static final int INTERVAL_SIGN;
    public static final int INTVAL;
    public static final int INTVAL_YEAR_MONTH;
    public static final int INTVAL_DAY_SECOND;

    SQL_INTERVAL_STRUCT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public SQL_INTERVAL_STRUCT(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), SQL_INTERVAL_STRUCT.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="SQLINTERVAL")
    public int interval_type() {
        return SQL_INTERVAL_STRUCT.ninterval_type(this.address());
    }

    @NativeType(value="SQLSMALLINT")
    public short interval_sign() {
        return SQL_INTERVAL_STRUCT.ninterval_sign(this.address());
    }

    public SQL_YEAR_MONTH_STRUCT intval_year_month() {
        return SQL_INTERVAL_STRUCT.nintval_year_month(this.address());
    }

    public SQL_INTERVAL_STRUCT intval_year_month(Consumer<SQL_YEAR_MONTH_STRUCT> consumer) {
        consumer.accept(this.intval_year_month());
        return this;
    }

    public SQL_DAY_SECOND_STRUCT intval_day_second() {
        return SQL_INTERVAL_STRUCT.nintval_day_second(this.address());
    }

    public SQL_INTERVAL_STRUCT intval_day_second(Consumer<SQL_DAY_SECOND_STRUCT> consumer) {
        consumer.accept(this.intval_day_second());
        return this;
    }

    public SQL_INTERVAL_STRUCT interval_type(@NativeType(value="SQLINTERVAL") int value) {
        SQL_INTERVAL_STRUCT.ninterval_type(this.address(), value);
        return this;
    }

    public SQL_INTERVAL_STRUCT interval_sign(@NativeType(value="SQLSMALLINT") short value) {
        SQL_INTERVAL_STRUCT.ninterval_sign(this.address(), value);
        return this;
    }

    public SQL_INTERVAL_STRUCT intval_year_month(SQL_YEAR_MONTH_STRUCT value) {
        SQL_INTERVAL_STRUCT.nintval_year_month(this.address(), value);
        return this;
    }

    public SQL_INTERVAL_STRUCT intval_day_second(SQL_DAY_SECOND_STRUCT value) {
        SQL_INTERVAL_STRUCT.nintval_day_second(this.address(), value);
        return this;
    }

    public SQL_INTERVAL_STRUCT set(int interval_type, short interval_sign, SQL_YEAR_MONTH_STRUCT intval_year_month, SQL_DAY_SECOND_STRUCT intval_day_second) {
        this.interval_type(interval_type);
        this.interval_sign(interval_sign);
        this.intval_year_month(intval_year_month);
        this.intval_day_second(intval_day_second);
        return this;
    }

    public SQL_INTERVAL_STRUCT set(SQL_INTERVAL_STRUCT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static SQL_INTERVAL_STRUCT malloc() {
        return SQL_INTERVAL_STRUCT.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static SQL_INTERVAL_STRUCT calloc() {
        return SQL_INTERVAL_STRUCT.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static SQL_INTERVAL_STRUCT create() {
        return new SQL_INTERVAL_STRUCT(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static SQL_INTERVAL_STRUCT create(long address) {
        return new SQL_INTERVAL_STRUCT(address, null);
    }

    @Nullable
    public static SQL_INTERVAL_STRUCT createSafe(long address) {
        return address == 0L ? null : SQL_INTERVAL_STRUCT.create(address);
    }

    public static Buffer malloc(int capacity) {
        return SQL_INTERVAL_STRUCT.create(SQL_INTERVAL_STRUCT.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return SQL_INTERVAL_STRUCT.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(SQL_INTERVAL_STRUCT.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : SQL_INTERVAL_STRUCT.create(address, capacity);
    }

    public static SQL_INTERVAL_STRUCT mallocStack() {
        return SQL_INTERVAL_STRUCT.mallocStack(MemoryStack.stackGet());
    }

    public static SQL_INTERVAL_STRUCT callocStack() {
        return SQL_INTERVAL_STRUCT.callocStack(MemoryStack.stackGet());
    }

    public static SQL_INTERVAL_STRUCT mallocStack(MemoryStack stack) {
        return SQL_INTERVAL_STRUCT.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static SQL_INTERVAL_STRUCT callocStack(MemoryStack stack) {
        return SQL_INTERVAL_STRUCT.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return SQL_INTERVAL_STRUCT.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return SQL_INTERVAL_STRUCT.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return SQL_INTERVAL_STRUCT.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return SQL_INTERVAL_STRUCT.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ninterval_type(long struct) {
        return MemoryUtil.memGetInt(struct + (long)INTERVAL_TYPE);
    }

    public static short ninterval_sign(long struct) {
        return MemoryUtil.memGetShort(struct + (long)INTERVAL_SIGN);
    }

    public static SQL_YEAR_MONTH_STRUCT nintval_year_month(long struct) {
        return SQL_YEAR_MONTH_STRUCT.create(struct + (long)INTVAL_YEAR_MONTH);
    }

    public static SQL_DAY_SECOND_STRUCT nintval_day_second(long struct) {
        return SQL_DAY_SECOND_STRUCT.create(struct + (long)INTVAL_DAY_SECOND);
    }

    public static void ninterval_type(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)INTERVAL_TYPE, value);
    }

    public static void ninterval_sign(long struct, short value) {
        MemoryUtil.memPutShort(struct + (long)INTERVAL_SIGN, value);
    }

    public static void nintval_year_month(long struct, SQL_YEAR_MONTH_STRUCT value) {
        MemoryUtil.memCopy(value.address(), struct + (long)INTVAL_YEAR_MONTH, SQL_YEAR_MONTH_STRUCT.SIZEOF);
    }

    public static void nintval_day_second(long struct, SQL_DAY_SECOND_STRUCT value) {
        MemoryUtil.memCopy(value.address(), struct + (long)INTVAL_DAY_SECOND, SQL_DAY_SECOND_STRUCT.SIZEOF);
    }

    static {
        Struct.Layout layout = SQL_INTERVAL_STRUCT.__struct(SQL_INTERVAL_STRUCT.__member(4), SQL_INTERVAL_STRUCT.__member(2), SQL_INTERVAL_STRUCT.__struct(SQL_INTERVAL_STRUCT.__member(SQL_YEAR_MONTH_STRUCT.SIZEOF, SQL_YEAR_MONTH_STRUCT.ALIGNOF), SQL_INTERVAL_STRUCT.__member(SQL_DAY_SECOND_STRUCT.SIZEOF, SQL_DAY_SECOND_STRUCT.ALIGNOF)));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        INTERVAL_TYPE = layout.offsetof(0);
        INTERVAL_SIGN = layout.offsetof(1);
        INTVAL = layout.offsetof(2);
        INTVAL_YEAR_MONTH = layout.offsetof(3);
        INTVAL_DAY_SECOND = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<SQL_INTERVAL_STRUCT, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected SQL_INTERVAL_STRUCT newInstance(long address) {
            return new SQL_INTERVAL_STRUCT(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="SQLINTERVAL")
        public int interval_type() {
            return SQL_INTERVAL_STRUCT.ninterval_type(this.address());
        }

        @NativeType(value="SQLSMALLINT")
        public short interval_sign() {
            return SQL_INTERVAL_STRUCT.ninterval_sign(this.address());
        }

        public SQL_YEAR_MONTH_STRUCT intval_year_month() {
            return SQL_INTERVAL_STRUCT.nintval_year_month(this.address());
        }

        public Buffer intval_year_month(Consumer<SQL_YEAR_MONTH_STRUCT> consumer) {
            consumer.accept(this.intval_year_month());
            return this;
        }

        public SQL_DAY_SECOND_STRUCT intval_day_second() {
            return SQL_INTERVAL_STRUCT.nintval_day_second(this.address());
        }

        public Buffer intval_day_second(Consumer<SQL_DAY_SECOND_STRUCT> consumer) {
            consumer.accept(this.intval_day_second());
            return this;
        }

        public Buffer interval_type(@NativeType(value="SQLINTERVAL") int value) {
            SQL_INTERVAL_STRUCT.ninterval_type(this.address(), value);
            return this;
        }

        public Buffer interval_sign(@NativeType(value="SQLSMALLINT") short value) {
            SQL_INTERVAL_STRUCT.ninterval_sign(this.address(), value);
            return this;
        }

        public Buffer intval_year_month(SQL_YEAR_MONTH_STRUCT value) {
            SQL_INTERVAL_STRUCT.nintval_year_month(this.address(), value);
            return this;
        }

        public Buffer intval_day_second(SQL_DAY_SECOND_STRUCT value) {
            SQL_INTERVAL_STRUCT.nintval_day_second(this.address(), value);
            return this;
        }
    }
}

