/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct nk_vec2")
public class NkVec2
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int X;
    public static final int Y;

    NkVec2(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public NkVec2(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), NkVec2.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public float x() {
        return NkVec2.nx(this.address());
    }

    public float y() {
        return NkVec2.ny(this.address());
    }

    public NkVec2 x(float value) {
        NkVec2.nx(this.address(), value);
        return this;
    }

    public NkVec2 y(float value) {
        NkVec2.ny(this.address(), value);
        return this;
    }

    public NkVec2 set(float x, float y) {
        this.x(x);
        this.y(y);
        return this;
    }

    public NkVec2 set(NkVec2 src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static NkVec2 malloc() {
        return NkVec2.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static NkVec2 calloc() {
        return NkVec2.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static NkVec2 create() {
        return new NkVec2(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static NkVec2 create(long address) {
        return new NkVec2(address, null);
    }

    @Nullable
    public static NkVec2 createSafe(long address) {
        return address == 0L ? null : NkVec2.create(address);
    }

    public static Buffer malloc(int capacity) {
        return NkVec2.create(NkVec2.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return NkVec2.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(NkVec2.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : NkVec2.create(address, capacity);
    }

    public static NkVec2 mallocStack() {
        return NkVec2.mallocStack(MemoryStack.stackGet());
    }

    public static NkVec2 callocStack() {
        return NkVec2.callocStack(MemoryStack.stackGet());
    }

    public static NkVec2 mallocStack(MemoryStack stack) {
        return NkVec2.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static NkVec2 callocStack(MemoryStack stack) {
        return NkVec2.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return NkVec2.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return NkVec2.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return NkVec2.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return NkVec2.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static float nx(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)X);
    }

    public static float ny(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)Y);
    }

    public static void nx(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)X, value);
    }

    public static void ny(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)Y, value);
    }

    static {
        Struct.Layout layout = NkVec2.__struct(NkVec2.__member(4), NkVec2.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        X = layout.offsetof(0);
        Y = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<NkVec2, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected NkVec2 newInstance(long address) {
            return new NkVec2(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        public float x() {
            return NkVec2.nx(this.address());
        }

        public float y() {
            return NkVec2.ny(this.address());
        }

        public Buffer x(float value) {
            NkVec2.nx(this.address(), value);
            return this;
        }

        public Buffer y(float value) {
            NkVec2.ny(this.address(), value);
            return this;
        }
    }
}

