/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.nuklear.NkColor;
import org.lwjgl.nuklear.NkStyleItem;
import org.lwjgl.nuklear.NkVec2;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct nk_style_chart")
public class NkStyleChart
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int BACKGROUND;
    public static final int BORDER_COLOR;
    public static final int SELECTED_COLOR;
    public static final int COLOR;
    public static final int BORDER;
    public static final int ROUNDING;
    public static final int PADDING;

    NkStyleChart(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public NkStyleChart(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), NkStyleChart.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="struct nk_style_item")
    public NkStyleItem background() {
        return NkStyleChart.nbackground(this.address());
    }

    public NkStyleChart background(Consumer<NkStyleItem> consumer) {
        consumer.accept(this.background());
        return this;
    }

    @NativeType(value="struct nk_color")
    public NkColor border_color() {
        return NkStyleChart.nborder_color(this.address());
    }

    public NkStyleChart border_color(Consumer<NkColor> consumer) {
        consumer.accept(this.border_color());
        return this;
    }

    @NativeType(value="struct nk_color")
    public NkColor selected_color() {
        return NkStyleChart.nselected_color(this.address());
    }

    public NkStyleChart selected_color(Consumer<NkColor> consumer) {
        consumer.accept(this.selected_color());
        return this;
    }

    @NativeType(value="struct nk_color")
    public NkColor color() {
        return NkStyleChart.ncolor(this.address());
    }

    public NkStyleChart color(Consumer<NkColor> consumer) {
        consumer.accept(this.color());
        return this;
    }

    public float border() {
        return NkStyleChart.nborder(this.address());
    }

    public float rounding() {
        return NkStyleChart.nrounding(this.address());
    }

    @NativeType(value="struct nk_vec2")
    public NkVec2 padding() {
        return NkStyleChart.npadding(this.address());
    }

    public NkStyleChart padding(Consumer<NkVec2> consumer) {
        consumer.accept(this.padding());
        return this;
    }

    public NkStyleChart background(@NativeType(value="struct nk_style_item") NkStyleItem value) {
        NkStyleChart.nbackground(this.address(), value);
        return this;
    }

    public NkStyleChart border_color(@NativeType(value="struct nk_color") NkColor value) {
        NkStyleChart.nborder_color(this.address(), value);
        return this;
    }

    public NkStyleChart selected_color(@NativeType(value="struct nk_color") NkColor value) {
        NkStyleChart.nselected_color(this.address(), value);
        return this;
    }

    public NkStyleChart color(@NativeType(value="struct nk_color") NkColor value) {
        NkStyleChart.ncolor(this.address(), value);
        return this;
    }

    public NkStyleChart border(float value) {
        NkStyleChart.nborder(this.address(), value);
        return this;
    }

    public NkStyleChart rounding(float value) {
        NkStyleChart.nrounding(this.address(), value);
        return this;
    }

    public NkStyleChart padding(@NativeType(value="struct nk_vec2") NkVec2 value) {
        NkStyleChart.npadding(this.address(), value);
        return this;
    }

    public NkStyleChart set(NkStyleItem background, NkColor border_color, NkColor selected_color, NkColor color, float border, float rounding, NkVec2 padding) {
        this.background(background);
        this.border_color(border_color);
        this.selected_color(selected_color);
        this.color(color);
        this.border(border);
        this.rounding(rounding);
        this.padding(padding);
        return this;
    }

    public NkStyleChart set(NkStyleChart src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static NkStyleChart malloc() {
        return NkStyleChart.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static NkStyleChart calloc() {
        return NkStyleChart.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static NkStyleChart create() {
        return new NkStyleChart(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static NkStyleChart create(long address) {
        return new NkStyleChart(address, null);
    }

    @Nullable
    public static NkStyleChart createSafe(long address) {
        return address == 0L ? null : NkStyleChart.create(address);
    }

    public static Buffer malloc(int capacity) {
        return NkStyleChart.create(NkStyleChart.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return NkStyleChart.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(NkStyleChart.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : NkStyleChart.create(address, capacity);
    }

    public static NkStyleChart mallocStack() {
        return NkStyleChart.mallocStack(MemoryStack.stackGet());
    }

    public static NkStyleChart callocStack() {
        return NkStyleChart.callocStack(MemoryStack.stackGet());
    }

    public static NkStyleChart mallocStack(MemoryStack stack) {
        return NkStyleChart.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static NkStyleChart callocStack(MemoryStack stack) {
        return NkStyleChart.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return NkStyleChart.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return NkStyleChart.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return NkStyleChart.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return NkStyleChart.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static NkStyleItem nbackground(long struct) {
        return NkStyleItem.create(struct + (long)BACKGROUND);
    }

    public static NkColor nborder_color(long struct) {
        return NkColor.create(struct + (long)BORDER_COLOR);
    }

    public static NkColor nselected_color(long struct) {
        return NkColor.create(struct + (long)SELECTED_COLOR);
    }

    public static NkColor ncolor(long struct) {
        return NkColor.create(struct + (long)COLOR);
    }

    public static float nborder(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)BORDER);
    }

    public static float nrounding(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)ROUNDING);
    }

    public static NkVec2 npadding(long struct) {
        return NkVec2.create(struct + (long)PADDING);
    }

    public static void nbackground(long struct, NkStyleItem value) {
        MemoryUtil.memCopy(value.address(), struct + (long)BACKGROUND, NkStyleItem.SIZEOF);
    }

    public static void nborder_color(long struct, NkColor value) {
        MemoryUtil.memCopy(value.address(), struct + (long)BORDER_COLOR, NkColor.SIZEOF);
    }

    public static void nselected_color(long struct, NkColor value) {
        MemoryUtil.memCopy(value.address(), struct + (long)SELECTED_COLOR, NkColor.SIZEOF);
    }

    public static void ncolor(long struct, NkColor value) {
        MemoryUtil.memCopy(value.address(), struct + (long)COLOR, NkColor.SIZEOF);
    }

    public static void nborder(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)BORDER, value);
    }

    public static void nrounding(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)ROUNDING, value);
    }

    public static void npadding(long struct, NkVec2 value) {
        MemoryUtil.memCopy(value.address(), struct + (long)PADDING, NkVec2.SIZEOF);
    }

    static {
        Struct.Layout layout = NkStyleChart.__struct(NkStyleChart.__member(NkStyleItem.SIZEOF, NkStyleItem.ALIGNOF), NkStyleChart.__member(NkColor.SIZEOF, NkColor.ALIGNOF), NkStyleChart.__member(NkColor.SIZEOF, NkColor.ALIGNOF), NkStyleChart.__member(NkColor.SIZEOF, NkColor.ALIGNOF), NkStyleChart.__member(4), NkStyleChart.__member(4), NkStyleChart.__member(NkVec2.SIZEOF, NkVec2.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        BACKGROUND = layout.offsetof(0);
        BORDER_COLOR = layout.offsetof(1);
        SELECTED_COLOR = layout.offsetof(2);
        COLOR = layout.offsetof(3);
        BORDER = layout.offsetof(4);
        ROUNDING = layout.offsetof(5);
        PADDING = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<NkStyleChart, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected NkStyleChart newInstance(long address) {
            return new NkStyleChart(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="struct nk_style_item")
        public NkStyleItem background() {
            return NkStyleChart.nbackground(this.address());
        }

        public Buffer background(Consumer<NkStyleItem> consumer) {
            consumer.accept(this.background());
            return this;
        }

        @NativeType(value="struct nk_color")
        public NkColor border_color() {
            return NkStyleChart.nborder_color(this.address());
        }

        public Buffer border_color(Consumer<NkColor> consumer) {
            consumer.accept(this.border_color());
            return this;
        }

        @NativeType(value="struct nk_color")
        public NkColor selected_color() {
            return NkStyleChart.nselected_color(this.address());
        }

        public Buffer selected_color(Consumer<NkColor> consumer) {
            consumer.accept(this.selected_color());
            return this;
        }

        @NativeType(value="struct nk_color")
        public NkColor color() {
            return NkStyleChart.ncolor(this.address());
        }

        public Buffer color(Consumer<NkColor> consumer) {
            consumer.accept(this.color());
            return this;
        }

        public float border() {
            return NkStyleChart.nborder(this.address());
        }

        public float rounding() {
            return NkStyleChart.nrounding(this.address());
        }

        @NativeType(value="struct nk_vec2")
        public NkVec2 padding() {
            return NkStyleChart.npadding(this.address());
        }

        public Buffer padding(Consumer<NkVec2> consumer) {
            consumer.accept(this.padding());
            return this;
        }

        public Buffer background(@NativeType(value="struct nk_style_item") NkStyleItem value) {
            NkStyleChart.nbackground(this.address(), value);
            return this;
        }

        public Buffer border_color(@NativeType(value="struct nk_color") NkColor value) {
            NkStyleChart.nborder_color(this.address(), value);
            return this;
        }

        public Buffer selected_color(@NativeType(value="struct nk_color") NkColor value) {
            NkStyleChart.nselected_color(this.address(), value);
            return this;
        }

        public Buffer color(@NativeType(value="struct nk_color") NkColor value) {
            NkStyleChart.ncolor(this.address(), value);
            return this;
        }

        public Buffer border(float value) {
            NkStyleChart.nborder(this.address(), value);
            return this;
        }

        public Buffer rounding(float value) {
            NkStyleChart.nrounding(this.address(), value);
            return this;
        }

        public Buffer padding(@NativeType(value="struct nk_vec2") NkVec2 value) {
            NkStyleChart.npadding(this.address(), value);
            return this;
        }
    }
}

