/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.nuklear.NkCursor;
import org.lwjgl.nuklear.NkStyleButton;
import org.lwjgl.nuklear.NkStyleChart;
import org.lwjgl.nuklear.NkStyleCombo;
import org.lwjgl.nuklear.NkStyleEdit;
import org.lwjgl.nuklear.NkStyleProgress;
import org.lwjgl.nuklear.NkStyleProperty;
import org.lwjgl.nuklear.NkStyleScrollbar;
import org.lwjgl.nuklear.NkStyleSelectable;
import org.lwjgl.nuklear.NkStyleSlider;
import org.lwjgl.nuklear.NkStyleTab;
import org.lwjgl.nuklear.NkStyleText;
import org.lwjgl.nuklear.NkStyleToggle;
import org.lwjgl.nuklear.NkStyleWindow;
import org.lwjgl.nuklear.NkUserFont;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct nk_style")
public class NkStyle
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int FONT;
    public static final int CURSORS;
    public static final int CURSOR_ACTIVE;
    public static final int CURSOR_LAST;
    public static final int CURSOR_VISIBLE;
    public static final int TEXT;
    public static final int BUTTON;
    public static final int CONTEXTUAL_BUTTON;
    public static final int MENU_BUTTON;
    public static final int OPTION;
    public static final int CHECKBOX;
    public static final int SELECTABLE;
    public static final int SLIDER;
    public static final int PROGRESS;
    public static final int PROPERTY;
    public static final int EDIT;
    public static final int CHART;
    public static final int SCROLLH;
    public static final int SCROLLV;
    public static final int TAB;
    public static final int COMBO;
    public static final int WINDOW;

    NkStyle(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public NkStyle(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), NkStyle.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @Nullable
    @NativeType(value="struct nk_user_font *")
    public NkUserFont font() {
        return NkStyle.nfont(this.address());
    }

    @NativeType(value="struct nk_cursor *[NK_CURSOR_COUNT]")
    public PointerBuffer cursors() {
        return NkStyle.ncursors(this.address());
    }

    @Nullable
    @NativeType(value="struct nk_cursor *")
    public NkCursor cursors(int index) {
        return NkStyle.ncursors(this.address(), index);
    }

    @Nullable
    @NativeType(value="struct nk_cursor *")
    public NkCursor cursor_active() {
        return NkStyle.ncursor_active(this.address());
    }

    @Nullable
    @NativeType(value="struct nk_cursor *")
    public NkCursor cursor_last() {
        return NkStyle.ncursor_last(this.address());
    }

    @NativeType(value="int")
    public boolean cursor_visible() {
        return NkStyle.ncursor_visible(this.address()) != 0;
    }

    @NativeType(value="struct nk_style_text")
    public NkStyleText text() {
        return NkStyle.ntext(this.address());
    }

    public NkStyle text(Consumer<NkStyleText> consumer) {
        consumer.accept(this.text());
        return this;
    }

    @NativeType(value="struct nk_style_button")
    public NkStyleButton button() {
        return NkStyle.nbutton(this.address());
    }

    public NkStyle button(Consumer<NkStyleButton> consumer) {
        consumer.accept(this.button());
        return this;
    }

    @NativeType(value="struct nk_style_button")
    public NkStyleButton contextual_button() {
        return NkStyle.ncontextual_button(this.address());
    }

    public NkStyle contextual_button(Consumer<NkStyleButton> consumer) {
        consumer.accept(this.contextual_button());
        return this;
    }

    @NativeType(value="struct nk_style_button")
    public NkStyleButton menu_button() {
        return NkStyle.nmenu_button(this.address());
    }

    public NkStyle menu_button(Consumer<NkStyleButton> consumer) {
        consumer.accept(this.menu_button());
        return this;
    }

    @NativeType(value="struct nk_style_toggle")
    public NkStyleToggle option() {
        return NkStyle.noption(this.address());
    }

    public NkStyle option(Consumer<NkStyleToggle> consumer) {
        consumer.accept(this.option());
        return this;
    }

    @NativeType(value="struct nk_style_toggle")
    public NkStyleToggle checkbox() {
        return NkStyle.ncheckbox(this.address());
    }

    public NkStyle checkbox(Consumer<NkStyleToggle> consumer) {
        consumer.accept(this.checkbox());
        return this;
    }

    @NativeType(value="struct nk_style_selectable")
    public NkStyleSelectable selectable() {
        return NkStyle.nselectable(this.address());
    }

    public NkStyle selectable(Consumer<NkStyleSelectable> consumer) {
        consumer.accept(this.selectable());
        return this;
    }

    @NativeType(value="struct nk_style_slider")
    public NkStyleSlider slider() {
        return NkStyle.nslider(this.address());
    }

    public NkStyle slider(Consumer<NkStyleSlider> consumer) {
        consumer.accept(this.slider());
        return this;
    }

    @NativeType(value="struct nk_style_progress")
    public NkStyleProgress progress() {
        return NkStyle.nprogress(this.address());
    }

    public NkStyle progress(Consumer<NkStyleProgress> consumer) {
        consumer.accept(this.progress());
        return this;
    }

    @NativeType(value="struct nk_style_property")
    public NkStyleProperty property() {
        return NkStyle.nproperty(this.address());
    }

    public NkStyle property(Consumer<NkStyleProperty> consumer) {
        consumer.accept(this.property());
        return this;
    }

    @NativeType(value="struct nk_style_edit")
    public NkStyleEdit edit() {
        return NkStyle.nedit(this.address());
    }

    public NkStyle edit(Consumer<NkStyleEdit> consumer) {
        consumer.accept(this.edit());
        return this;
    }

    @NativeType(value="struct nk_style_chart")
    public NkStyleChart chart() {
        return NkStyle.nchart(this.address());
    }

    public NkStyle chart(Consumer<NkStyleChart> consumer) {
        consumer.accept(this.chart());
        return this;
    }

    @NativeType(value="struct nk_style_scrollbar")
    public NkStyleScrollbar scrollh() {
        return NkStyle.nscrollh(this.address());
    }

    public NkStyle scrollh(Consumer<NkStyleScrollbar> consumer) {
        consumer.accept(this.scrollh());
        return this;
    }

    @NativeType(value="struct nk_style_scrollbar")
    public NkStyleScrollbar scrollv() {
        return NkStyle.nscrollv(this.address());
    }

    public NkStyle scrollv(Consumer<NkStyleScrollbar> consumer) {
        consumer.accept(this.scrollv());
        return this;
    }

    @NativeType(value="struct nk_style_tab")
    public NkStyleTab tab() {
        return NkStyle.ntab(this.address());
    }

    public NkStyle tab(Consumer<NkStyleTab> consumer) {
        consumer.accept(this.tab());
        return this;
    }

    @NativeType(value="struct nk_style_combo")
    public NkStyleCombo combo() {
        return NkStyle.ncombo(this.address());
    }

    public NkStyle combo(Consumer<NkStyleCombo> consumer) {
        consumer.accept(this.combo());
        return this;
    }

    @NativeType(value="struct nk_style_window")
    public NkStyleWindow window() {
        return NkStyle.nwindow(this.address());
    }

    public NkStyle window(Consumer<NkStyleWindow> consumer) {
        consumer.accept(this.window());
        return this;
    }

    public NkStyle font(@Nullable @NativeType(value="struct nk_user_font *") NkUserFont value) {
        NkStyle.nfont(this.address(), value);
        return this;
    }

    public NkStyle cursors(@NativeType(value="struct nk_cursor *[NK_CURSOR_COUNT]") PointerBuffer value) {
        NkStyle.ncursors(this.address(), value);
        return this;
    }

    public NkStyle cursors(int index, @Nullable @NativeType(value="struct nk_cursor *") NkCursor value) {
        NkStyle.ncursors(this.address(), index, value);
        return this;
    }

    public NkStyle cursor_active(@Nullable @NativeType(value="struct nk_cursor *") NkCursor value) {
        NkStyle.ncursor_active(this.address(), value);
        return this;
    }

    public NkStyle cursor_last(@Nullable @NativeType(value="struct nk_cursor *") NkCursor value) {
        NkStyle.ncursor_last(this.address(), value);
        return this;
    }

    public NkStyle cursor_visible(@NativeType(value="int") boolean value) {
        NkStyle.ncursor_visible(this.address(), value ? 1 : 0);
        return this;
    }

    public NkStyle text(@NativeType(value="struct nk_style_text") NkStyleText value) {
        NkStyle.ntext(this.address(), value);
        return this;
    }

    public NkStyle button(@NativeType(value="struct nk_style_button") NkStyleButton value) {
        NkStyle.nbutton(this.address(), value);
        return this;
    }

    public NkStyle contextual_button(@NativeType(value="struct nk_style_button") NkStyleButton value) {
        NkStyle.ncontextual_button(this.address(), value);
        return this;
    }

    public NkStyle menu_button(@NativeType(value="struct nk_style_button") NkStyleButton value) {
        NkStyle.nmenu_button(this.address(), value);
        return this;
    }

    public NkStyle option(@NativeType(value="struct nk_style_toggle") NkStyleToggle value) {
        NkStyle.noption(this.address(), value);
        return this;
    }

    public NkStyle checkbox(@NativeType(value="struct nk_style_toggle") NkStyleToggle value) {
        NkStyle.ncheckbox(this.address(), value);
        return this;
    }

    public NkStyle selectable(@NativeType(value="struct nk_style_selectable") NkStyleSelectable value) {
        NkStyle.nselectable(this.address(), value);
        return this;
    }

    public NkStyle slider(@NativeType(value="struct nk_style_slider") NkStyleSlider value) {
        NkStyle.nslider(this.address(), value);
        return this;
    }

    public NkStyle progress(@NativeType(value="struct nk_style_progress") NkStyleProgress value) {
        NkStyle.nprogress(this.address(), value);
        return this;
    }

    public NkStyle property(@NativeType(value="struct nk_style_property") NkStyleProperty value) {
        NkStyle.nproperty(this.address(), value);
        return this;
    }

    public NkStyle edit(@NativeType(value="struct nk_style_edit") NkStyleEdit value) {
        NkStyle.nedit(this.address(), value);
        return this;
    }

    public NkStyle chart(@NativeType(value="struct nk_style_chart") NkStyleChart value) {
        NkStyle.nchart(this.address(), value);
        return this;
    }

    public NkStyle scrollh(@NativeType(value="struct nk_style_scrollbar") NkStyleScrollbar value) {
        NkStyle.nscrollh(this.address(), value);
        return this;
    }

    public NkStyle scrollv(@NativeType(value="struct nk_style_scrollbar") NkStyleScrollbar value) {
        NkStyle.nscrollv(this.address(), value);
        return this;
    }

    public NkStyle tab(@NativeType(value="struct nk_style_tab") NkStyleTab value) {
        NkStyle.ntab(this.address(), value);
        return this;
    }

    public NkStyle combo(@NativeType(value="struct nk_style_combo") NkStyleCombo value) {
        NkStyle.ncombo(this.address(), value);
        return this;
    }

    public NkStyle window(@NativeType(value="struct nk_style_window") NkStyleWindow value) {
        NkStyle.nwindow(this.address(), value);
        return this;
    }

    public NkStyle set(@Nullable NkUserFont font, PointerBuffer cursors, @Nullable NkCursor cursor_active, @Nullable NkCursor cursor_last, boolean cursor_visible, NkStyleText text, NkStyleButton button, NkStyleButton contextual_button, NkStyleButton menu_button, NkStyleToggle option, NkStyleToggle checkbox, NkStyleSelectable selectable, NkStyleSlider slider, NkStyleProgress progress, NkStyleProperty property, NkStyleEdit edit, NkStyleChart chart, NkStyleScrollbar scrollh, NkStyleScrollbar scrollv, NkStyleTab tab, NkStyleCombo combo, NkStyleWindow window) {
        this.font(font);
        this.cursors(cursors);
        this.cursor_active(cursor_active);
        this.cursor_last(cursor_last);
        this.cursor_visible(cursor_visible);
        this.text(text);
        this.button(button);
        this.contextual_button(contextual_button);
        this.menu_button(menu_button);
        this.option(option);
        this.checkbox(checkbox);
        this.selectable(selectable);
        this.slider(slider);
        this.progress(progress);
        this.property(property);
        this.edit(edit);
        this.chart(chart);
        this.scrollh(scrollh);
        this.scrollv(scrollv);
        this.tab(tab);
        this.combo(combo);
        this.window(window);
        return this;
    }

    public NkStyle set(NkStyle src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static NkStyle malloc() {
        return NkStyle.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static NkStyle calloc() {
        return NkStyle.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static NkStyle create() {
        return new NkStyle(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static NkStyle create(long address) {
        return new NkStyle(address, null);
    }

    @Nullable
    public static NkStyle createSafe(long address) {
        return address == 0L ? null : NkStyle.create(address);
    }

    public static Buffer malloc(int capacity) {
        return NkStyle.create(NkStyle.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return NkStyle.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(NkStyle.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : NkStyle.create(address, capacity);
    }

    public static NkStyle mallocStack() {
        return NkStyle.mallocStack(MemoryStack.stackGet());
    }

    public static NkStyle callocStack() {
        return NkStyle.callocStack(MemoryStack.stackGet());
    }

    public static NkStyle mallocStack(MemoryStack stack) {
        return NkStyle.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static NkStyle callocStack(MemoryStack stack) {
        return NkStyle.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return NkStyle.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return NkStyle.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return NkStyle.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return NkStyle.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    @Nullable
    public static NkUserFont nfont(long struct) {
        return NkUserFont.createSafe(MemoryUtil.memGetAddress(struct + (long)FONT));
    }

    public static PointerBuffer ncursors(long struct) {
        return MemoryUtil.memPointerBuffer(struct + (long)CURSORS, 7);
    }

    @Nullable
    public static NkCursor ncursors(long struct, int index) {
        return NkCursor.createSafe(MemoryUtil.memGetAddress(struct + (long)CURSORS + Checks.check(index, 7) * (long)POINTER_SIZE));
    }

    @Nullable
    public static NkCursor ncursor_active(long struct) {
        return NkCursor.createSafe(MemoryUtil.memGetAddress(struct + (long)CURSOR_ACTIVE));
    }

    @Nullable
    public static NkCursor ncursor_last(long struct) {
        return NkCursor.createSafe(MemoryUtil.memGetAddress(struct + (long)CURSOR_LAST));
    }

    public static int ncursor_visible(long struct) {
        return MemoryUtil.memGetInt(struct + (long)CURSOR_VISIBLE);
    }

    public static NkStyleText ntext(long struct) {
        return NkStyleText.create(struct + (long)TEXT);
    }

    public static NkStyleButton nbutton(long struct) {
        return NkStyleButton.create(struct + (long)BUTTON);
    }

    public static NkStyleButton ncontextual_button(long struct) {
        return NkStyleButton.create(struct + (long)CONTEXTUAL_BUTTON);
    }

    public static NkStyleButton nmenu_button(long struct) {
        return NkStyleButton.create(struct + (long)MENU_BUTTON);
    }

    public static NkStyleToggle noption(long struct) {
        return NkStyleToggle.create(struct + (long)OPTION);
    }

    public static NkStyleToggle ncheckbox(long struct) {
        return NkStyleToggle.create(struct + (long)CHECKBOX);
    }

    public static NkStyleSelectable nselectable(long struct) {
        return NkStyleSelectable.create(struct + (long)SELECTABLE);
    }

    public static NkStyleSlider nslider(long struct) {
        return NkStyleSlider.create(struct + (long)SLIDER);
    }

    public static NkStyleProgress nprogress(long struct) {
        return NkStyleProgress.create(struct + (long)PROGRESS);
    }

    public static NkStyleProperty nproperty(long struct) {
        return NkStyleProperty.create(struct + (long)PROPERTY);
    }

    public static NkStyleEdit nedit(long struct) {
        return NkStyleEdit.create(struct + (long)EDIT);
    }

    public static NkStyleChart nchart(long struct) {
        return NkStyleChart.create(struct + (long)CHART);
    }

    public static NkStyleScrollbar nscrollh(long struct) {
        return NkStyleScrollbar.create(struct + (long)SCROLLH);
    }

    public static NkStyleScrollbar nscrollv(long struct) {
        return NkStyleScrollbar.create(struct + (long)SCROLLV);
    }

    public static NkStyleTab ntab(long struct) {
        return NkStyleTab.create(struct + (long)TAB);
    }

    public static NkStyleCombo ncombo(long struct) {
        return NkStyleCombo.create(struct + (long)COMBO);
    }

    public static NkStyleWindow nwindow(long struct) {
        return NkStyleWindow.create(struct + (long)WINDOW);
    }

    public static void nfont(long struct, @Nullable NkUserFont value) {
        MemoryUtil.memPutAddress(struct + (long)FONT, MemoryUtil.memAddressSafe(value));
    }

    public static void ncursors(long struct, PointerBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 7);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)CURSORS, value.remaining() * POINTER_SIZE);
    }

    public static void ncursors(long struct, int index, @Nullable NkCursor value) {
        MemoryUtil.memPutAddress(struct + (long)CURSORS + Checks.check(index, 7) * (long)POINTER_SIZE, MemoryUtil.memAddressSafe(value));
    }

    public static void ncursor_active(long struct, @Nullable NkCursor value) {
        MemoryUtil.memPutAddress(struct + (long)CURSOR_ACTIVE, MemoryUtil.memAddressSafe(value));
    }

    public static void ncursor_last(long struct, @Nullable NkCursor value) {
        MemoryUtil.memPutAddress(struct + (long)CURSOR_LAST, MemoryUtil.memAddressSafe(value));
    }

    public static void ncursor_visible(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)CURSOR_VISIBLE, value);
    }

    public static void ntext(long struct, NkStyleText value) {
        MemoryUtil.memCopy(value.address(), struct + (long)TEXT, NkStyleText.SIZEOF);
    }

    public static void nbutton(long struct, NkStyleButton value) {
        MemoryUtil.memCopy(value.address(), struct + (long)BUTTON, NkStyleButton.SIZEOF);
    }

    public static void ncontextual_button(long struct, NkStyleButton value) {
        MemoryUtil.memCopy(value.address(), struct + (long)CONTEXTUAL_BUTTON, NkStyleButton.SIZEOF);
    }

    public static void nmenu_button(long struct, NkStyleButton value) {
        MemoryUtil.memCopy(value.address(), struct + (long)MENU_BUTTON, NkStyleButton.SIZEOF);
    }

    public static void noption(long struct, NkStyleToggle value) {
        MemoryUtil.memCopy(value.address(), struct + (long)OPTION, NkStyleToggle.SIZEOF);
    }

    public static void ncheckbox(long struct, NkStyleToggle value) {
        MemoryUtil.memCopy(value.address(), struct + (long)CHECKBOX, NkStyleToggle.SIZEOF);
    }

    public static void nselectable(long struct, NkStyleSelectable value) {
        MemoryUtil.memCopy(value.address(), struct + (long)SELECTABLE, NkStyleSelectable.SIZEOF);
    }

    public static void nslider(long struct, NkStyleSlider value) {
        MemoryUtil.memCopy(value.address(), struct + (long)SLIDER, NkStyleSlider.SIZEOF);
    }

    public static void nprogress(long struct, NkStyleProgress value) {
        MemoryUtil.memCopy(value.address(), struct + (long)PROGRESS, NkStyleProgress.SIZEOF);
    }

    public static void nproperty(long struct, NkStyleProperty value) {
        MemoryUtil.memCopy(value.address(), struct + (long)PROPERTY, NkStyleProperty.SIZEOF);
    }

    public static void nedit(long struct, NkStyleEdit value) {
        MemoryUtil.memCopy(value.address(), struct + (long)EDIT, NkStyleEdit.SIZEOF);
    }

    public static void nchart(long struct, NkStyleChart value) {
        MemoryUtil.memCopy(value.address(), struct + (long)CHART, NkStyleChart.SIZEOF);
    }

    public static void nscrollh(long struct, NkStyleScrollbar value) {
        MemoryUtil.memCopy(value.address(), struct + (long)SCROLLH, NkStyleScrollbar.SIZEOF);
    }

    public static void nscrollv(long struct, NkStyleScrollbar value) {
        MemoryUtil.memCopy(value.address(), struct + (long)SCROLLV, NkStyleScrollbar.SIZEOF);
    }

    public static void ntab(long struct, NkStyleTab value) {
        MemoryUtil.memCopy(value.address(), struct + (long)TAB, NkStyleTab.SIZEOF);
    }

    public static void ncombo(long struct, NkStyleCombo value) {
        MemoryUtil.memCopy(value.address(), struct + (long)COMBO, NkStyleCombo.SIZEOF);
    }

    public static void nwindow(long struct, NkStyleWindow value) {
        MemoryUtil.memCopy(value.address(), struct + (long)WINDOW, NkStyleWindow.SIZEOF);
    }

    static {
        Struct.Layout layout = NkStyle.__struct(NkStyle.__member(POINTER_SIZE), NkStyle.__array(POINTER_SIZE, 7), NkStyle.__member(POINTER_SIZE), NkStyle.__member(POINTER_SIZE), NkStyle.__member(4), NkStyle.__member(NkStyleText.SIZEOF, NkStyleText.ALIGNOF), NkStyle.__member(NkStyleButton.SIZEOF, NkStyleButton.ALIGNOF), NkStyle.__member(NkStyleButton.SIZEOF, NkStyleButton.ALIGNOF), NkStyle.__member(NkStyleButton.SIZEOF, NkStyleButton.ALIGNOF), NkStyle.__member(NkStyleToggle.SIZEOF, NkStyleToggle.ALIGNOF), NkStyle.__member(NkStyleToggle.SIZEOF, NkStyleToggle.ALIGNOF), NkStyle.__member(NkStyleSelectable.SIZEOF, NkStyleSelectable.ALIGNOF), NkStyle.__member(NkStyleSlider.SIZEOF, NkStyleSlider.ALIGNOF), NkStyle.__member(NkStyleProgress.SIZEOF, NkStyleProgress.ALIGNOF), NkStyle.__member(NkStyleProperty.SIZEOF, NkStyleProperty.ALIGNOF), NkStyle.__member(NkStyleEdit.SIZEOF, NkStyleEdit.ALIGNOF), NkStyle.__member(NkStyleChart.SIZEOF, NkStyleChart.ALIGNOF), NkStyle.__member(NkStyleScrollbar.SIZEOF, NkStyleScrollbar.ALIGNOF), NkStyle.__member(NkStyleScrollbar.SIZEOF, NkStyleScrollbar.ALIGNOF), NkStyle.__member(NkStyleTab.SIZEOF, NkStyleTab.ALIGNOF), NkStyle.__member(NkStyleCombo.SIZEOF, NkStyleCombo.ALIGNOF), NkStyle.__member(NkStyleWindow.SIZEOF, NkStyleWindow.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        FONT = layout.offsetof(0);
        CURSORS = layout.offsetof(1);
        CURSOR_ACTIVE = layout.offsetof(2);
        CURSOR_LAST = layout.offsetof(3);
        CURSOR_VISIBLE = layout.offsetof(4);
        TEXT = layout.offsetof(5);
        BUTTON = layout.offsetof(6);
        CONTEXTUAL_BUTTON = layout.offsetof(7);
        MENU_BUTTON = layout.offsetof(8);
        OPTION = layout.offsetof(9);
        CHECKBOX = layout.offsetof(10);
        SELECTABLE = layout.offsetof(11);
        SLIDER = layout.offsetof(12);
        PROGRESS = layout.offsetof(13);
        PROPERTY = layout.offsetof(14);
        EDIT = layout.offsetof(15);
        CHART = layout.offsetof(16);
        SCROLLH = layout.offsetof(17);
        SCROLLV = layout.offsetof(18);
        TAB = layout.offsetof(19);
        COMBO = layout.offsetof(20);
        WINDOW = layout.offsetof(21);
    }

    public static class Buffer
    extends StructBuffer<NkStyle, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected NkStyle newInstance(long address) {
            return new NkStyle(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @Nullable
        @NativeType(value="struct nk_user_font *")
        public NkUserFont font() {
            return NkStyle.nfont(this.address());
        }

        @NativeType(value="struct nk_cursor *[NK_CURSOR_COUNT]")
        public PointerBuffer cursors() {
            return NkStyle.ncursors(this.address());
        }

        @Nullable
        @NativeType(value="struct nk_cursor *")
        public NkCursor cursors(int index) {
            return NkStyle.ncursors(this.address(), index);
        }

        @Nullable
        @NativeType(value="struct nk_cursor *")
        public NkCursor cursor_active() {
            return NkStyle.ncursor_active(this.address());
        }

        @Nullable
        @NativeType(value="struct nk_cursor *")
        public NkCursor cursor_last() {
            return NkStyle.ncursor_last(this.address());
        }

        @NativeType(value="int")
        public boolean cursor_visible() {
            return NkStyle.ncursor_visible(this.address()) != 0;
        }

        @NativeType(value="struct nk_style_text")
        public NkStyleText text() {
            return NkStyle.ntext(this.address());
        }

        public Buffer text(Consumer<NkStyleText> consumer) {
            consumer.accept(this.text());
            return this;
        }

        @NativeType(value="struct nk_style_button")
        public NkStyleButton button() {
            return NkStyle.nbutton(this.address());
        }

        public Buffer button(Consumer<NkStyleButton> consumer) {
            consumer.accept(this.button());
            return this;
        }

        @NativeType(value="struct nk_style_button")
        public NkStyleButton contextual_button() {
            return NkStyle.ncontextual_button(this.address());
        }

        public Buffer contextual_button(Consumer<NkStyleButton> consumer) {
            consumer.accept(this.contextual_button());
            return this;
        }

        @NativeType(value="struct nk_style_button")
        public NkStyleButton menu_button() {
            return NkStyle.nmenu_button(this.address());
        }

        public Buffer menu_button(Consumer<NkStyleButton> consumer) {
            consumer.accept(this.menu_button());
            return this;
        }

        @NativeType(value="struct nk_style_toggle")
        public NkStyleToggle option() {
            return NkStyle.noption(this.address());
        }

        public Buffer option(Consumer<NkStyleToggle> consumer) {
            consumer.accept(this.option());
            return this;
        }

        @NativeType(value="struct nk_style_toggle")
        public NkStyleToggle checkbox() {
            return NkStyle.ncheckbox(this.address());
        }

        public Buffer checkbox(Consumer<NkStyleToggle> consumer) {
            consumer.accept(this.checkbox());
            return this;
        }

        @NativeType(value="struct nk_style_selectable")
        public NkStyleSelectable selectable() {
            return NkStyle.nselectable(this.address());
        }

        public Buffer selectable(Consumer<NkStyleSelectable> consumer) {
            consumer.accept(this.selectable());
            return this;
        }

        @NativeType(value="struct nk_style_slider")
        public NkStyleSlider slider() {
            return NkStyle.nslider(this.address());
        }

        public Buffer slider(Consumer<NkStyleSlider> consumer) {
            consumer.accept(this.slider());
            return this;
        }

        @NativeType(value="struct nk_style_progress")
        public NkStyleProgress progress() {
            return NkStyle.nprogress(this.address());
        }

        public Buffer progress(Consumer<NkStyleProgress> consumer) {
            consumer.accept(this.progress());
            return this;
        }

        @NativeType(value="struct nk_style_property")
        public NkStyleProperty property() {
            return NkStyle.nproperty(this.address());
        }

        public Buffer property(Consumer<NkStyleProperty> consumer) {
            consumer.accept(this.property());
            return this;
        }

        @NativeType(value="struct nk_style_edit")
        public NkStyleEdit edit() {
            return NkStyle.nedit(this.address());
        }

        public Buffer edit(Consumer<NkStyleEdit> consumer) {
            consumer.accept(this.edit());
            return this;
        }

        @NativeType(value="struct nk_style_chart")
        public NkStyleChart chart() {
            return NkStyle.nchart(this.address());
        }

        public Buffer chart(Consumer<NkStyleChart> consumer) {
            consumer.accept(this.chart());
            return this;
        }

        @NativeType(value="struct nk_style_scrollbar")
        public NkStyleScrollbar scrollh() {
            return NkStyle.nscrollh(this.address());
        }

        public Buffer scrollh(Consumer<NkStyleScrollbar> consumer) {
            consumer.accept(this.scrollh());
            return this;
        }

        @NativeType(value="struct nk_style_scrollbar")
        public NkStyleScrollbar scrollv() {
            return NkStyle.nscrollv(this.address());
        }

        public Buffer scrollv(Consumer<NkStyleScrollbar> consumer) {
            consumer.accept(this.scrollv());
            return this;
        }

        @NativeType(value="struct nk_style_tab")
        public NkStyleTab tab() {
            return NkStyle.ntab(this.address());
        }

        public Buffer tab(Consumer<NkStyleTab> consumer) {
            consumer.accept(this.tab());
            return this;
        }

        @NativeType(value="struct nk_style_combo")
        public NkStyleCombo combo() {
            return NkStyle.ncombo(this.address());
        }

        public Buffer combo(Consumer<NkStyleCombo> consumer) {
            consumer.accept(this.combo());
            return this;
        }

        @NativeType(value="struct nk_style_window")
        public NkStyleWindow window() {
            return NkStyle.nwindow(this.address());
        }

        public Buffer window(Consumer<NkStyleWindow> consumer) {
            consumer.accept(this.window());
            return this;
        }

        public Buffer font(@Nullable @NativeType(value="struct nk_user_font *") NkUserFont value) {
            NkStyle.nfont(this.address(), value);
            return this;
        }

        public Buffer cursors(@NativeType(value="struct nk_cursor *[NK_CURSOR_COUNT]") PointerBuffer value) {
            NkStyle.ncursors(this.address(), value);
            return this;
        }

        public Buffer cursors(int index, @Nullable @NativeType(value="struct nk_cursor *") NkCursor value) {
            NkStyle.ncursors(this.address(), index, value);
            return this;
        }

        public Buffer cursor_active(@Nullable @NativeType(value="struct nk_cursor *") NkCursor value) {
            NkStyle.ncursor_active(this.address(), value);
            return this;
        }

        public Buffer cursor_last(@Nullable @NativeType(value="struct nk_cursor *") NkCursor value) {
            NkStyle.ncursor_last(this.address(), value);
            return this;
        }

        public Buffer cursor_visible(@NativeType(value="int") boolean value) {
            NkStyle.ncursor_visible(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer text(@NativeType(value="struct nk_style_text") NkStyleText value) {
            NkStyle.ntext(this.address(), value);
            return this;
        }

        public Buffer button(@NativeType(value="struct nk_style_button") NkStyleButton value) {
            NkStyle.nbutton(this.address(), value);
            return this;
        }

        public Buffer contextual_button(@NativeType(value="struct nk_style_button") NkStyleButton value) {
            NkStyle.ncontextual_button(this.address(), value);
            return this;
        }

        public Buffer menu_button(@NativeType(value="struct nk_style_button") NkStyleButton value) {
            NkStyle.nmenu_button(this.address(), value);
            return this;
        }

        public Buffer option(@NativeType(value="struct nk_style_toggle") NkStyleToggle value) {
            NkStyle.noption(this.address(), value);
            return this;
        }

        public Buffer checkbox(@NativeType(value="struct nk_style_toggle") NkStyleToggle value) {
            NkStyle.ncheckbox(this.address(), value);
            return this;
        }

        public Buffer selectable(@NativeType(value="struct nk_style_selectable") NkStyleSelectable value) {
            NkStyle.nselectable(this.address(), value);
            return this;
        }

        public Buffer slider(@NativeType(value="struct nk_style_slider") NkStyleSlider value) {
            NkStyle.nslider(this.address(), value);
            return this;
        }

        public Buffer progress(@NativeType(value="struct nk_style_progress") NkStyleProgress value) {
            NkStyle.nprogress(this.address(), value);
            return this;
        }

        public Buffer property(@NativeType(value="struct nk_style_property") NkStyleProperty value) {
            NkStyle.nproperty(this.address(), value);
            return this;
        }

        public Buffer edit(@NativeType(value="struct nk_style_edit") NkStyleEdit value) {
            NkStyle.nedit(this.address(), value);
            return this;
        }

        public Buffer chart(@NativeType(value="struct nk_style_chart") NkStyleChart value) {
            NkStyle.nchart(this.address(), value);
            return this;
        }

        public Buffer scrollh(@NativeType(value="struct nk_style_scrollbar") NkStyleScrollbar value) {
            NkStyle.nscrollh(this.address(), value);
            return this;
        }

        public Buffer scrollv(@NativeType(value="struct nk_style_scrollbar") NkStyleScrollbar value) {
            NkStyle.nscrollv(this.address(), value);
            return this;
        }

        public Buffer tab(@NativeType(value="struct nk_style_tab") NkStyleTab value) {
            NkStyle.ntab(this.address(), value);
            return this;
        }

        public Buffer combo(@NativeType(value="struct nk_style_combo") NkStyleCombo value) {
            NkStyle.ncombo(this.address(), value);
            return this;
        }

        public Buffer window(@NativeType(value="struct nk_style_window") NkStyleWindow value) {
            NkStyle.nwindow(this.address(), value);
            return this;
        }
    }
}

