/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.nuklear.NkConfigStackFlagsElement;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct nk_config_stack_flags")
class NkConfigStackFlags
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int HEAD;
    public static final int ELEMENTS;

    NkConfigStackFlags(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    NkConfigStackFlags(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), NkConfigStackFlags.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int head() {
        return NkConfigStackFlags.nhead(this.address());
    }

    @NativeType(value="struct nk_config_stack_flags_element[32]")
    public NkConfigStackFlagsElement.Buffer elements() {
        return NkConfigStackFlags.nelements(this.address());
    }

    @NativeType(value="struct nk_config_stack_flags_element")
    public NkConfigStackFlagsElement elements(int index) {
        return NkConfigStackFlags.nelements(this.address(), index);
    }

    public static NkConfigStackFlags create(long address) {
        return new NkConfigStackFlags(address, null);
    }

    @Nullable
    public static NkConfigStackFlags createSafe(long address) {
        return address == 0L ? null : NkConfigStackFlags.create(address);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : NkConfigStackFlags.create(address, capacity);
    }

    public static int nhead(long struct) {
        return MemoryUtil.memGetInt(struct + (long)HEAD);
    }

    public static NkConfigStackFlagsElement.Buffer nelements(long struct) {
        return NkConfigStackFlagsElement.create(struct + (long)ELEMENTS, 32);
    }

    public static NkConfigStackFlagsElement nelements(long struct, int index) {
        return NkConfigStackFlagsElement.create(struct + (long)ELEMENTS + Checks.check(index, 32) * (long)NkConfigStackFlagsElement.SIZEOF);
    }

    static {
        Struct.Layout layout = NkConfigStackFlags.__struct(NkConfigStackFlags.__member(4), NkConfigStackFlags.__array(NkConfigStackFlagsElement.SIZEOF, NkConfigStackFlagsElement.ALIGNOF, 32));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        HEAD = layout.offsetof(0);
        ELEMENTS = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<NkConfigStackFlags, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected NkConfigStackFlags newInstance(long address) {
            return new NkConfigStackFlags(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        public int head() {
            return NkConfigStackFlags.nhead(this.address());
        }

        @NativeType(value="struct nk_config_stack_flags_element[32]")
        public NkConfigStackFlagsElement.Buffer elements() {
            return NkConfigStackFlags.nelements(this.address());
        }

        @NativeType(value="struct nk_config_stack_flags_element")
        public NkConfigStackFlagsElement elements(int index) {
            return NkConfigStackFlags.nelements(this.address(), index);
        }
    }
}

