/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct nk_color")
public class NkColor
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int R;
    public static final int G;
    public static final int B;
    public static final int A;

    NkColor(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public NkColor(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), NkColor.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="nk_byte")
    public byte r() {
        return NkColor.nr(this.address());
    }

    @NativeType(value="nk_byte")
    public byte g() {
        return NkColor.ng(this.address());
    }

    @NativeType(value="nk_byte")
    public byte b() {
        return NkColor.nb(this.address());
    }

    @NativeType(value="nk_byte")
    public byte a() {
        return NkColor.na(this.address());
    }

    public NkColor r(@NativeType(value="nk_byte") byte value) {
        NkColor.nr(this.address(), value);
        return this;
    }

    public NkColor g(@NativeType(value="nk_byte") byte value) {
        NkColor.ng(this.address(), value);
        return this;
    }

    public NkColor b(@NativeType(value="nk_byte") byte value) {
        NkColor.nb(this.address(), value);
        return this;
    }

    public NkColor a(@NativeType(value="nk_byte") byte value) {
        NkColor.na(this.address(), value);
        return this;
    }

    public NkColor set(byte r, byte g, byte b, byte a) {
        this.r(r);
        this.g(g);
        this.b(b);
        this.a(a);
        return this;
    }

    public NkColor set(NkColor src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static NkColor malloc() {
        return NkColor.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static NkColor calloc() {
        return NkColor.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static NkColor create() {
        return new NkColor(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static NkColor create(long address) {
        return new NkColor(address, null);
    }

    @Nullable
    public static NkColor createSafe(long address) {
        return address == 0L ? null : NkColor.create(address);
    }

    public static Buffer malloc(int capacity) {
        return NkColor.create(NkColor.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return NkColor.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(NkColor.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : NkColor.create(address, capacity);
    }

    public static NkColor mallocStack() {
        return NkColor.mallocStack(MemoryStack.stackGet());
    }

    public static NkColor callocStack() {
        return NkColor.callocStack(MemoryStack.stackGet());
    }

    public static NkColor mallocStack(MemoryStack stack) {
        return NkColor.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static NkColor callocStack(MemoryStack stack) {
        return NkColor.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return NkColor.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return NkColor.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return NkColor.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return NkColor.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static byte nr(long struct) {
        return MemoryUtil.memGetByte(struct + (long)R);
    }

    public static byte ng(long struct) {
        return MemoryUtil.memGetByte(struct + (long)G);
    }

    public static byte nb(long struct) {
        return MemoryUtil.memGetByte(struct + (long)B);
    }

    public static byte na(long struct) {
        return MemoryUtil.memGetByte(struct + (long)A);
    }

    public static void nr(long struct, byte value) {
        MemoryUtil.memPutByte(struct + (long)R, value);
    }

    public static void ng(long struct, byte value) {
        MemoryUtil.memPutByte(struct + (long)G, value);
    }

    public static void nb(long struct, byte value) {
        MemoryUtil.memPutByte(struct + (long)B, value);
    }

    public static void na(long struct, byte value) {
        MemoryUtil.memPutByte(struct + (long)A, value);
    }

    static {
        Struct.Layout layout = NkColor.__struct(NkColor.__member(1), NkColor.__member(1), NkColor.__member(1), NkColor.__member(1));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        R = layout.offsetof(0);
        G = layout.offsetof(1);
        B = layout.offsetof(2);
        A = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<NkColor, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected NkColor newInstance(long address) {
            return new NkColor(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="nk_byte")
        public byte r() {
            return NkColor.nr(this.address());
        }

        @NativeType(value="nk_byte")
        public byte g() {
            return NkColor.ng(this.address());
        }

        @NativeType(value="nk_byte")
        public byte b() {
            return NkColor.nb(this.address());
        }

        @NativeType(value="nk_byte")
        public byte a() {
            return NkColor.na(this.address());
        }

        public Buffer r(@NativeType(value="nk_byte") byte value) {
            NkColor.nr(this.address(), value);
            return this;
        }

        public Buffer g(@NativeType(value="nk_byte") byte value) {
            NkColor.ng(this.address(), value);
            return this;
        }

        public Buffer b(@NativeType(value="nk_byte") byte value) {
            NkColor.nb(this.address(), value);
            return this;
        }

        public Buffer a(@NativeType(value="nk_byte") byte value) {
            NkColor.na(this.address(), value);
            return this;
        }
    }
}

