/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nanovg;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct NVGtextRow")
public class NVGTextRow
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int START;
    public static final int END;
    public static final int NEXT;
    public static final int WIDTH;
    public static final int MINX;
    public static final int MAXX;

    NVGTextRow(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public NVGTextRow(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), NVGTextRow.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="char *")
    public long start() {
        return NVGTextRow.nstart(this.address());
    }

    @NativeType(value="char *")
    public long end() {
        return NVGTextRow.nend(this.address());
    }

    @NativeType(value="char *")
    public long next() {
        return NVGTextRow.nnext(this.address());
    }

    public float width() {
        return NVGTextRow.nwidth(this.address());
    }

    public float minx() {
        return NVGTextRow.nminx(this.address());
    }

    public float maxx() {
        return NVGTextRow.nmaxx(this.address());
    }

    public static NVGTextRow malloc() {
        return NVGTextRow.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static NVGTextRow calloc() {
        return NVGTextRow.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static NVGTextRow create() {
        return new NVGTextRow(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static NVGTextRow create(long address) {
        return new NVGTextRow(address, null);
    }

    @Nullable
    public static NVGTextRow createSafe(long address) {
        return address == 0L ? null : NVGTextRow.create(address);
    }

    public static Buffer malloc(int capacity) {
        return NVGTextRow.create(NVGTextRow.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return NVGTextRow.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(NVGTextRow.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : NVGTextRow.create(address, capacity);
    }

    public static NVGTextRow mallocStack() {
        return NVGTextRow.mallocStack(MemoryStack.stackGet());
    }

    public static NVGTextRow callocStack() {
        return NVGTextRow.callocStack(MemoryStack.stackGet());
    }

    public static NVGTextRow mallocStack(MemoryStack stack) {
        return NVGTextRow.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static NVGTextRow callocStack(MemoryStack stack) {
        return NVGTextRow.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return NVGTextRow.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return NVGTextRow.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return NVGTextRow.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return NVGTextRow.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nstart(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)START);
    }

    public static long nend(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)END);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static float nwidth(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)WIDTH);
    }

    public static float nminx(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)MINX);
    }

    public static float nmaxx(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)MAXX);
    }

    static {
        Struct.Layout layout = NVGTextRow.__struct(NVGTextRow.__member(POINTER_SIZE), NVGTextRow.__member(POINTER_SIZE), NVGTextRow.__member(POINTER_SIZE), NVGTextRow.__member(4), NVGTextRow.__member(4), NVGTextRow.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        START = layout.offsetof(0);
        END = layout.offsetof(1);
        NEXT = layout.offsetof(2);
        WIDTH = layout.offsetof(3);
        MINX = layout.offsetof(4);
        MAXX = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<NVGTextRow, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected NVGTextRow newInstance(long address) {
            return new NVGTextRow(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="char *")
        public long start() {
            return NVGTextRow.nstart(this.address());
        }

        @NativeType(value="char *")
        public long end() {
            return NVGTextRow.nend(this.address());
        }

        @NativeType(value="char *")
        public long next() {
            return NVGTextRow.nnext(this.address());
        }

        public float width() {
            return NVGTextRow.nwidth(this.address());
        }

        public float minx() {
            return NVGTextRow.nminx(this.address());
        }

        public float maxx() {
            return NVGTextRow.nmaxx(this.address());
        }
    }
}

