/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.bgfx;

import java.nio.ByteBuffer;
import java.nio.ShortBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct bgfx_vertex_decl_t")
public class BGFXVertexDecl
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int HASH;
    public static final int STRIDE;
    public static final int OFFSET;
    public static final int ATTRIBUTES;

    BGFXVertexDecl(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public BGFXVertexDecl(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), BGFXVertexDecl.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint32_t")
    public int hash() {
        return BGFXVertexDecl.nhash(this.address());
    }

    @NativeType(value="uint16_t")
    public short stride() {
        return BGFXVertexDecl.nstride(this.address());
    }

    @NativeType(value="uint16_t[BGFX_ATTRIB_COUNT]")
    public ShortBuffer offset() {
        return BGFXVertexDecl.noffset(this.address());
    }

    @NativeType(value="uint16_t")
    public short offset(int index) {
        return BGFXVertexDecl.noffset(this.address(), index);
    }

    @NativeType(value="uint16_t[BGFX_ATTRIB_COUNT]")
    public ShortBuffer attributes() {
        return BGFXVertexDecl.nattributes(this.address());
    }

    @NativeType(value="uint16_t")
    public short attributes(int index) {
        return BGFXVertexDecl.nattributes(this.address(), index);
    }

    public BGFXVertexDecl hash(@NativeType(value="uint32_t") int value) {
        BGFXVertexDecl.nhash(this.address(), value);
        return this;
    }

    public BGFXVertexDecl stride(@NativeType(value="uint16_t") short value) {
        BGFXVertexDecl.nstride(this.address(), value);
        return this;
    }

    public BGFXVertexDecl offset(@NativeType(value="uint16_t[BGFX_ATTRIB_COUNT]") ShortBuffer value) {
        BGFXVertexDecl.noffset(this.address(), value);
        return this;
    }

    public BGFXVertexDecl offset(int index, @NativeType(value="uint16_t") short value) {
        BGFXVertexDecl.noffset(this.address(), index, value);
        return this;
    }

    public BGFXVertexDecl attributes(@NativeType(value="uint16_t[BGFX_ATTRIB_COUNT]") ShortBuffer value) {
        BGFXVertexDecl.nattributes(this.address(), value);
        return this;
    }

    public BGFXVertexDecl attributes(int index, @NativeType(value="uint16_t") short value) {
        BGFXVertexDecl.nattributes(this.address(), index, value);
        return this;
    }

    public BGFXVertexDecl set(int hash, short stride, ShortBuffer offset, ShortBuffer attributes) {
        this.hash(hash);
        this.stride(stride);
        this.offset(offset);
        this.attributes(attributes);
        return this;
    }

    public BGFXVertexDecl set(BGFXVertexDecl src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static BGFXVertexDecl malloc() {
        return BGFXVertexDecl.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static BGFXVertexDecl calloc() {
        return BGFXVertexDecl.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static BGFXVertexDecl create() {
        return new BGFXVertexDecl(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static BGFXVertexDecl create(long address) {
        return new BGFXVertexDecl(address, null);
    }

    @Nullable
    public static BGFXVertexDecl createSafe(long address) {
        return address == 0L ? null : BGFXVertexDecl.create(address);
    }

    public static Buffer malloc(int capacity) {
        return BGFXVertexDecl.create(BGFXVertexDecl.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return BGFXVertexDecl.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BGFXVertexDecl.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : BGFXVertexDecl.create(address, capacity);
    }

    public static BGFXVertexDecl mallocStack() {
        return BGFXVertexDecl.mallocStack(MemoryStack.stackGet());
    }

    public static BGFXVertexDecl callocStack() {
        return BGFXVertexDecl.callocStack(MemoryStack.stackGet());
    }

    public static BGFXVertexDecl mallocStack(MemoryStack stack) {
        return BGFXVertexDecl.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static BGFXVertexDecl callocStack(MemoryStack stack) {
        return BGFXVertexDecl.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return BGFXVertexDecl.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return BGFXVertexDecl.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return BGFXVertexDecl.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return BGFXVertexDecl.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nhash(long struct) {
        return MemoryUtil.memGetInt(struct + (long)HASH);
    }

    public static short nstride(long struct) {
        return MemoryUtil.memGetShort(struct + (long)STRIDE);
    }

    public static ShortBuffer noffset(long struct) {
        return MemoryUtil.memShortBuffer(struct + (long)OFFSET, 18);
    }

    public static short noffset(long struct, int index) {
        return MemoryUtil.memGetShort(struct + (long)OFFSET + Checks.check(index, 18) * 2L);
    }

    public static ShortBuffer nattributes(long struct) {
        return MemoryUtil.memShortBuffer(struct + (long)ATTRIBUTES, 18);
    }

    public static short nattributes(long struct, int index) {
        return MemoryUtil.memGetShort(struct + (long)ATTRIBUTES + Checks.check(index, 18) * 2L);
    }

    public static void nhash(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)HASH, value);
    }

    public static void nstride(long struct, short value) {
        MemoryUtil.memPutShort(struct + (long)STRIDE, value);
    }

    public static void noffset(long struct, ShortBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 18);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)OFFSET, value.remaining() * 2);
    }

    public static void noffset(long struct, int index, short value) {
        MemoryUtil.memPutShort(struct + (long)OFFSET + Checks.check(index, 18) * 2L, value);
    }

    public static void nattributes(long struct, ShortBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 18);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)ATTRIBUTES, value.remaining() * 2);
    }

    public static void nattributes(long struct, int index, short value) {
        MemoryUtil.memPutShort(struct + (long)ATTRIBUTES + Checks.check(index, 18) * 2L, value);
    }

    static {
        Struct.Layout layout = BGFXVertexDecl.__struct(BGFXVertexDecl.__member(4), BGFXVertexDecl.__member(2), BGFXVertexDecl.__array(2, 18), BGFXVertexDecl.__array(2, 18));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        HASH = layout.offsetof(0);
        STRIDE = layout.offsetof(1);
        OFFSET = layout.offsetof(2);
        ATTRIBUTES = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<BGFXVertexDecl, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected BGFXVertexDecl newInstance(long address) {
            return new BGFXVertexDecl(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="uint32_t")
        public int hash() {
            return BGFXVertexDecl.nhash(this.address());
        }

        @NativeType(value="uint16_t")
        public short stride() {
            return BGFXVertexDecl.nstride(this.address());
        }

        @NativeType(value="uint16_t[BGFX_ATTRIB_COUNT]")
        public ShortBuffer offset() {
            return BGFXVertexDecl.noffset(this.address());
        }

        @NativeType(value="uint16_t")
        public short offset(int index) {
            return BGFXVertexDecl.noffset(this.address(), index);
        }

        @NativeType(value="uint16_t[BGFX_ATTRIB_COUNT]")
        public ShortBuffer attributes() {
            return BGFXVertexDecl.nattributes(this.address());
        }

        @NativeType(value="uint16_t")
        public short attributes(int index) {
            return BGFXVertexDecl.nattributes(this.address(), index);
        }

        public Buffer hash(@NativeType(value="uint32_t") int value) {
            BGFXVertexDecl.nhash(this.address(), value);
            return this;
        }

        public Buffer stride(@NativeType(value="uint16_t") short value) {
            BGFXVertexDecl.nstride(this.address(), value);
            return this;
        }

        public Buffer offset(@NativeType(value="uint16_t[BGFX_ATTRIB_COUNT]") ShortBuffer value) {
            BGFXVertexDecl.noffset(this.address(), value);
            return this;
        }

        public Buffer offset(int index, @NativeType(value="uint16_t") short value) {
            BGFXVertexDecl.noffset(this.address(), index, value);
            return this;
        }

        public Buffer attributes(@NativeType(value="uint16_t[BGFX_ATTRIB_COUNT]") ShortBuffer value) {
            BGFXVertexDecl.nattributes(this.address(), value);
            return this;
        }

        public Buffer attributes(int index, @NativeType(value="uint16_t") short value) {
            BGFXVertexDecl.nattributes(this.address(), index, value);
            return this;
        }
    }
}

