/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.bgfx;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct bgfx_transform_t")
public class BGFXTransform
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int DATA;
    public static final int NUM;

    BGFXTransform(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public BGFXTransform(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), BGFXTransform.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="float *")
    public FloatBuffer data() {
        return BGFXTransform.ndata(this.address());
    }

    @NativeType(value="uint16_t")
    public short num() {
        return BGFXTransform.nnum(this.address());
    }

    public static BGFXTransform malloc() {
        return BGFXTransform.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static BGFXTransform calloc() {
        return BGFXTransform.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static BGFXTransform create() {
        return new BGFXTransform(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static BGFXTransform create(long address) {
        return new BGFXTransform(address, null);
    }

    @Nullable
    public static BGFXTransform createSafe(long address) {
        return address == 0L ? null : BGFXTransform.create(address);
    }

    public static Buffer malloc(int capacity) {
        return BGFXTransform.create(BGFXTransform.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return BGFXTransform.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BGFXTransform.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : BGFXTransform.create(address, capacity);
    }

    public static BGFXTransform mallocStack() {
        return BGFXTransform.mallocStack(MemoryStack.stackGet());
    }

    public static BGFXTransform callocStack() {
        return BGFXTransform.callocStack(MemoryStack.stackGet());
    }

    public static BGFXTransform mallocStack(MemoryStack stack) {
        return BGFXTransform.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static BGFXTransform callocStack(MemoryStack stack) {
        return BGFXTransform.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return BGFXTransform.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return BGFXTransform.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return BGFXTransform.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return BGFXTransform.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static FloatBuffer ndata(long struct) {
        return MemoryUtil.memFloatBuffer(MemoryUtil.memGetAddress(struct + (long)DATA), Short.toUnsignedInt(BGFXTransform.nnum(struct)) << 4);
    }

    public static short nnum(long struct) {
        return MemoryUtil.memGetShort(struct + (long)NUM);
    }

    static {
        Struct.Layout layout = BGFXTransform.__struct(BGFXTransform.__member(POINTER_SIZE), BGFXTransform.__member(2));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        DATA = layout.offsetof(0);
        NUM = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<BGFXTransform, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected BGFXTransform newInstance(long address) {
            return new BGFXTransform(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="float *")
        public FloatBuffer data() {
            return BGFXTransform.ndata(this.address());
        }

        @NativeType(value="uint16_t")
        public short num() {
            return BGFXTransform.nnum(this.address());
        }
    }
}

