/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.bgfx;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct bgfx_memory_t")
public class BGFXMemory
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int DATA;
    public static final int SIZE;

    BGFXMemory(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public BGFXMemory(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), BGFXMemory.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint8_t *")
    public ByteBuffer data() {
        return BGFXMemory.ndata(this.address());
    }

    @NativeType(value="uint32_t")
    public int size() {
        return BGFXMemory.nsize(this.address());
    }

    public BGFXMemory data(@NativeType(value="uint8_t *") ByteBuffer value) {
        BGFXMemory.ndata(this.address(), value);
        return this;
    }

    public BGFXMemory set(BGFXMemory src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static BGFXMemory malloc() {
        return BGFXMemory.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static BGFXMemory calloc() {
        return BGFXMemory.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static BGFXMemory create() {
        return new BGFXMemory(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static BGFXMemory create(long address) {
        return new BGFXMemory(address, null);
    }

    @Nullable
    public static BGFXMemory createSafe(long address) {
        return address == 0L ? null : BGFXMemory.create(address);
    }

    public static Buffer malloc(int capacity) {
        return BGFXMemory.create(BGFXMemory.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return BGFXMemory.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BGFXMemory.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : BGFXMemory.create(address, capacity);
    }

    public static BGFXMemory mallocStack() {
        return BGFXMemory.mallocStack(MemoryStack.stackGet());
    }

    public static BGFXMemory callocStack() {
        return BGFXMemory.callocStack(MemoryStack.stackGet());
    }

    public static BGFXMemory mallocStack(MemoryStack stack) {
        return BGFXMemory.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static BGFXMemory callocStack(MemoryStack stack) {
        return BGFXMemory.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return BGFXMemory.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return BGFXMemory.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return BGFXMemory.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return BGFXMemory.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static ByteBuffer ndata(long struct) {
        return MemoryUtil.memByteBuffer(MemoryUtil.memGetAddress(struct + (long)DATA), BGFXMemory.nsize(struct));
    }

    public static int nsize(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SIZE);
    }

    public static void ndata(long struct, ByteBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)DATA, MemoryUtil.memAddress(value));
        BGFXMemory.nsize(struct, value.remaining());
    }

    public static void nsize(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SIZE, value);
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)DATA));
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            BGFXMemory.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = BGFXMemory.__struct(BGFXMemory.__member(POINTER_SIZE), BGFXMemory.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        DATA = layout.offsetof(0);
        SIZE = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<BGFXMemory, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected BGFXMemory newInstance(long address) {
            return new BGFXMemory(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="uint8_t *")
        public ByteBuffer data() {
            return BGFXMemory.ndata(this.address());
        }

        @NativeType(value="uint32_t")
        public int size() {
            return BGFXMemory.nsize(this.address());
        }

        public Buffer data(@NativeType(value="uint8_t *") ByteBuffer value) {
            BGFXMemory.ndata(this.address(), value);
            return this;
        }
    }
}

