/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.assimp;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.assimp.AIString;
import org.lwjgl.assimp.AITexel;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct aiTexture")
public class AITexture
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MWIDTH;
    public static final int MHEIGHT;
    public static final int ACHFORMATHINT;
    public static final int PCDATA;
    public static final int MFILENAME;

    AITexture(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public AITexture(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), AITexture.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="unsigned int")
    public int mWidth() {
        return AITexture.nmWidth(this.address());
    }

    @NativeType(value="unsigned int")
    public int mHeight() {
        return AITexture.nmHeight(this.address());
    }

    @NativeType(value="char[4]")
    public ByteBuffer achFormatHint() {
        return AITexture.nachFormatHint(this.address());
    }

    @NativeType(value="char[4]")
    public String achFormatHintString() {
        return AITexture.nachFormatHintString(this.address());
    }

    @NativeType(value="struct aiTexel *")
    public AITexel.Buffer pcData(int capacity) {
        return AITexture.npcData(this.address(), capacity);
    }

    @NativeType(value="struct aiString")
    public AIString mFilename() {
        return AITexture.nmFilename(this.address());
    }

    public AITexture mFilename(Consumer<AIString> consumer) {
        consumer.accept(this.mFilename());
        return this;
    }

    public static AITexture create(long address) {
        return new AITexture(address, null);
    }

    @Nullable
    public static AITexture createSafe(long address) {
        return address == 0L ? null : AITexture.create(address);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : AITexture.create(address, capacity);
    }

    public static int nmWidth(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MWIDTH);
    }

    public static int nmHeight(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MHEIGHT);
    }

    public static ByteBuffer nachFormatHint(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)ACHFORMATHINT, 4);
    }

    public static String nachFormatHintString(long struct) {
        return MemoryUtil.memASCII(struct + (long)ACHFORMATHINT);
    }

    public static AITexel.Buffer npcData(long struct, int capacity) {
        return AITexel.create(MemoryUtil.memGetAddress(struct + (long)PCDATA), capacity);
    }

    public static AIString nmFilename(long struct) {
        return AIString.create(struct + (long)MFILENAME);
    }

    static {
        Struct.Layout layout = AITexture.__struct(AITexture.__member(4), AITexture.__member(4), AITexture.__array(1, 4), AITexture.__member(POINTER_SIZE), AITexture.__member(AIString.SIZEOF, AIString.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MWIDTH = layout.offsetof(0);
        MHEIGHT = layout.offsetof(1);
        ACHFORMATHINT = layout.offsetof(2);
        PCDATA = layout.offsetof(3);
        MFILENAME = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<AITexture, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected AITexture newInstance(long address) {
            return new AITexture(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="unsigned int")
        public int mWidth() {
            return AITexture.nmWidth(this.address());
        }

        @NativeType(value="unsigned int")
        public int mHeight() {
            return AITexture.nmHeight(this.address());
        }

        @NativeType(value="char[4]")
        public ByteBuffer achFormatHint() {
            return AITexture.nachFormatHint(this.address());
        }

        @NativeType(value="char[4]")
        public String achFormatHintString() {
            return AITexture.nachFormatHintString(this.address());
        }

        @NativeType(value="struct aiTexel *")
        public AITexel.Buffer pcData(int capacity) {
            return AITexture.npcData(this.address(), capacity);
        }

        @NativeType(value="struct aiString")
        public AIString mFilename() {
            return AITexture.nmFilename(this.address());
        }

        public Buffer mFilename(Consumer<AIString> consumer) {
            consumer.accept(this.mFilename());
            return this;
        }
    }
}

