/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.assimp;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct aiColor4D")
public class AIColor4D
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int R;
    public static final int G;
    public static final int B;
    public static final int A;

    AIColor4D(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public AIColor4D(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), AIColor4D.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public float r() {
        return AIColor4D.nr(this.address());
    }

    public float g() {
        return AIColor4D.ng(this.address());
    }

    public float b() {
        return AIColor4D.nb(this.address());
    }

    public float a() {
        return AIColor4D.na(this.address());
    }

    public AIColor4D r(float value) {
        AIColor4D.nr(this.address(), value);
        return this;
    }

    public AIColor4D g(float value) {
        AIColor4D.ng(this.address(), value);
        return this;
    }

    public AIColor4D b(float value) {
        AIColor4D.nb(this.address(), value);
        return this;
    }

    public AIColor4D a(float value) {
        AIColor4D.na(this.address(), value);
        return this;
    }

    public AIColor4D set(float r, float g, float b, float a) {
        this.r(r);
        this.g(g);
        this.b(b);
        this.a(a);
        return this;
    }

    public AIColor4D set(AIColor4D src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static AIColor4D malloc() {
        return AIColor4D.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static AIColor4D calloc() {
        return AIColor4D.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static AIColor4D create() {
        return new AIColor4D(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static AIColor4D create(long address) {
        return new AIColor4D(address, null);
    }

    @Nullable
    public static AIColor4D createSafe(long address) {
        return address == 0L ? null : AIColor4D.create(address);
    }

    public static Buffer malloc(int capacity) {
        return AIColor4D.create(AIColor4D.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return AIColor4D.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(AIColor4D.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : AIColor4D.create(address, capacity);
    }

    public static AIColor4D mallocStack() {
        return AIColor4D.mallocStack(MemoryStack.stackGet());
    }

    public static AIColor4D callocStack() {
        return AIColor4D.callocStack(MemoryStack.stackGet());
    }

    public static AIColor4D mallocStack(MemoryStack stack) {
        return AIColor4D.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static AIColor4D callocStack(MemoryStack stack) {
        return AIColor4D.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return AIColor4D.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return AIColor4D.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return AIColor4D.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return AIColor4D.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static float nr(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)R);
    }

    public static float ng(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)G);
    }

    public static float nb(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)B);
    }

    public static float na(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)A);
    }

    public static void nr(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)R, value);
    }

    public static void ng(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)G, value);
    }

    public static void nb(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)B, value);
    }

    public static void na(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)A, value);
    }

    static {
        Struct.Layout layout = AIColor4D.__struct(AIColor4D.__member(4), AIColor4D.__member(4), AIColor4D.__member(4), AIColor4D.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        R = layout.offsetof(0);
        G = layout.offsetof(1);
        B = layout.offsetof(2);
        A = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<AIColor4D, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected AIColor4D newInstance(long address) {
            return new AIColor4D(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        public float r() {
            return AIColor4D.nr(this.address());
        }

        public float g() {
            return AIColor4D.ng(this.address());
        }

        public float b() {
            return AIColor4D.nb(this.address());
        }

        public float a() {
            return AIColor4D.na(this.address());
        }

        public Buffer r(float value) {
            AIColor4D.nr(this.address(), value);
            return this;
        }

        public Buffer g(float value) {
            AIColor4D.ng(this.address(), value);
            return this;
        }

        public Buffer b(float value) {
            AIColor4D.nb(this.address(), value);
            return this;
        }

        public Buffer a(float value) {
            AIColor4D.na(this.address(), value);
            return this;
        }
    }
}

