/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.assimp;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.assimp.AIString;
import org.lwjgl.assimp.AIVector3D;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct aiCamera")
public class AICamera
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MNAME;
    public static final int MPOSITION;
    public static final int MUP;
    public static final int MLOOKAT;
    public static final int MHORIZONTALFOV;
    public static final int MCLIPPLANENEAR;
    public static final int MCLIPPLANEFAR;
    public static final int MASPECT;

    AICamera(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public AICamera(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), AICamera.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="struct aiString")
    public AIString mName() {
        return AICamera.nmName(this.address());
    }

    public AICamera mName(Consumer<AIString> consumer) {
        consumer.accept(this.mName());
        return this;
    }

    @NativeType(value="struct aiVector3D")
    public AIVector3D mPosition() {
        return AICamera.nmPosition(this.address());
    }

    public AICamera mPosition(Consumer<AIVector3D> consumer) {
        consumer.accept(this.mPosition());
        return this;
    }

    @NativeType(value="struct aiVector3D")
    public AIVector3D mUp() {
        return AICamera.nmUp(this.address());
    }

    public AICamera mUp(Consumer<AIVector3D> consumer) {
        consumer.accept(this.mUp());
        return this;
    }

    @NativeType(value="struct aiVector3D")
    public AIVector3D mLookAt() {
        return AICamera.nmLookAt(this.address());
    }

    public AICamera mLookAt(Consumer<AIVector3D> consumer) {
        consumer.accept(this.mLookAt());
        return this;
    }

    public float mHorizontalFOV() {
        return AICamera.nmHorizontalFOV(this.address());
    }

    public float mClipPlaneNear() {
        return AICamera.nmClipPlaneNear(this.address());
    }

    public float mClipPlaneFar() {
        return AICamera.nmClipPlaneFar(this.address());
    }

    public float mAspect() {
        return AICamera.nmAspect(this.address());
    }

    public AICamera mName(@NativeType(value="struct aiString") AIString value) {
        AICamera.nmName(this.address(), value);
        return this;
    }

    public AICamera mPosition(@NativeType(value="struct aiVector3D") AIVector3D value) {
        AICamera.nmPosition(this.address(), value);
        return this;
    }

    public AICamera mUp(@NativeType(value="struct aiVector3D") AIVector3D value) {
        AICamera.nmUp(this.address(), value);
        return this;
    }

    public AICamera mLookAt(@NativeType(value="struct aiVector3D") AIVector3D value) {
        AICamera.nmLookAt(this.address(), value);
        return this;
    }

    public AICamera mHorizontalFOV(float value) {
        AICamera.nmHorizontalFOV(this.address(), value);
        return this;
    }

    public AICamera mClipPlaneNear(float value) {
        AICamera.nmClipPlaneNear(this.address(), value);
        return this;
    }

    public AICamera mClipPlaneFar(float value) {
        AICamera.nmClipPlaneFar(this.address(), value);
        return this;
    }

    public AICamera mAspect(float value) {
        AICamera.nmAspect(this.address(), value);
        return this;
    }

    public AICamera set(AIString mName, AIVector3D mPosition, AIVector3D mUp, AIVector3D mLookAt, float mHorizontalFOV, float mClipPlaneNear, float mClipPlaneFar, float mAspect) {
        this.mName(mName);
        this.mPosition(mPosition);
        this.mUp(mUp);
        this.mLookAt(mLookAt);
        this.mHorizontalFOV(mHorizontalFOV);
        this.mClipPlaneNear(mClipPlaneNear);
        this.mClipPlaneFar(mClipPlaneFar);
        this.mAspect(mAspect);
        return this;
    }

    public AICamera set(AICamera src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static AICamera malloc() {
        return AICamera.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static AICamera calloc() {
        return AICamera.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static AICamera create() {
        return new AICamera(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static AICamera create(long address) {
        return new AICamera(address, null);
    }

    @Nullable
    public static AICamera createSafe(long address) {
        return address == 0L ? null : AICamera.create(address);
    }

    public static Buffer malloc(int capacity) {
        return AICamera.create(AICamera.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return AICamera.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(AICamera.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : AICamera.create(address, capacity);
    }

    public static AICamera mallocStack() {
        return AICamera.mallocStack(MemoryStack.stackGet());
    }

    public static AICamera callocStack() {
        return AICamera.callocStack(MemoryStack.stackGet());
    }

    public static AICamera mallocStack(MemoryStack stack) {
        return AICamera.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static AICamera callocStack(MemoryStack stack) {
        return AICamera.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return AICamera.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return AICamera.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return AICamera.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return AICamera.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static AIString nmName(long struct) {
        return AIString.create(struct + (long)MNAME);
    }

    public static AIVector3D nmPosition(long struct) {
        return AIVector3D.create(struct + (long)MPOSITION);
    }

    public static AIVector3D nmUp(long struct) {
        return AIVector3D.create(struct + (long)MUP);
    }

    public static AIVector3D nmLookAt(long struct) {
        return AIVector3D.create(struct + (long)MLOOKAT);
    }

    public static float nmHorizontalFOV(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)MHORIZONTALFOV);
    }

    public static float nmClipPlaneNear(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)MCLIPPLANENEAR);
    }

    public static float nmClipPlaneFar(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)MCLIPPLANEFAR);
    }

    public static float nmAspect(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)MASPECT);
    }

    public static void nmName(long struct, AIString value) {
        MemoryUtil.memCopy(value.address(), struct + (long)MNAME, AIString.SIZEOF);
    }

    public static void nmPosition(long struct, AIVector3D value) {
        MemoryUtil.memCopy(value.address(), struct + (long)MPOSITION, AIVector3D.SIZEOF);
    }

    public static void nmUp(long struct, AIVector3D value) {
        MemoryUtil.memCopy(value.address(), struct + (long)MUP, AIVector3D.SIZEOF);
    }

    public static void nmLookAt(long struct, AIVector3D value) {
        MemoryUtil.memCopy(value.address(), struct + (long)MLOOKAT, AIVector3D.SIZEOF);
    }

    public static void nmHorizontalFOV(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)MHORIZONTALFOV, value);
    }

    public static void nmClipPlaneNear(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)MCLIPPLANENEAR, value);
    }

    public static void nmClipPlaneFar(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)MCLIPPLANEFAR, value);
    }

    public static void nmAspect(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)MASPECT, value);
    }

    static {
        Struct.Layout layout = AICamera.__struct(AICamera.__member(AIString.SIZEOF, AIString.ALIGNOF), AICamera.__member(AIVector3D.SIZEOF, AIVector3D.ALIGNOF), AICamera.__member(AIVector3D.SIZEOF, AIVector3D.ALIGNOF), AICamera.__member(AIVector3D.SIZEOF, AIVector3D.ALIGNOF), AICamera.__member(4), AICamera.__member(4), AICamera.__member(4), AICamera.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MNAME = layout.offsetof(0);
        MPOSITION = layout.offsetof(1);
        MUP = layout.offsetof(2);
        MLOOKAT = layout.offsetof(3);
        MHORIZONTALFOV = layout.offsetof(4);
        MCLIPPLANENEAR = layout.offsetof(5);
        MCLIPPLANEFAR = layout.offsetof(6);
        MASPECT = layout.offsetof(7);
    }

    public static class Buffer
    extends StructBuffer<AICamera, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected AICamera newInstance(long address) {
            return new AICamera(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="struct aiString")
        public AIString mName() {
            return AICamera.nmName(this.address());
        }

        public Buffer mName(Consumer<AIString> consumer) {
            consumer.accept(this.mName());
            return this;
        }

        @NativeType(value="struct aiVector3D")
        public AIVector3D mPosition() {
            return AICamera.nmPosition(this.address());
        }

        public Buffer mPosition(Consumer<AIVector3D> consumer) {
            consumer.accept(this.mPosition());
            return this;
        }

        @NativeType(value="struct aiVector3D")
        public AIVector3D mUp() {
            return AICamera.nmUp(this.address());
        }

        public Buffer mUp(Consumer<AIVector3D> consumer) {
            consumer.accept(this.mUp());
            return this;
        }

        @NativeType(value="struct aiVector3D")
        public AIVector3D mLookAt() {
            return AICamera.nmLookAt(this.address());
        }

        public Buffer mLookAt(Consumer<AIVector3D> consumer) {
            consumer.accept(this.mLookAt());
            return this;
        }

        public float mHorizontalFOV() {
            return AICamera.nmHorizontalFOV(this.address());
        }

        public float mClipPlaneNear() {
            return AICamera.nmClipPlaneNear(this.address());
        }

        public float mClipPlaneFar() {
            return AICamera.nmClipPlaneFar(this.address());
        }

        public float mAspect() {
            return AICamera.nmAspect(this.address());
        }

        public Buffer mName(@NativeType(value="struct aiString") AIString value) {
            AICamera.nmName(this.address(), value);
            return this;
        }

        public Buffer mPosition(@NativeType(value="struct aiVector3D") AIVector3D value) {
            AICamera.nmPosition(this.address(), value);
            return this;
        }

        public Buffer mUp(@NativeType(value="struct aiVector3D") AIVector3D value) {
            AICamera.nmUp(this.address(), value);
            return this;
        }

        public Buffer mLookAt(@NativeType(value="struct aiVector3D") AIVector3D value) {
            AICamera.nmLookAt(this.address(), value);
            return this;
        }

        public Buffer mHorizontalFOV(float value) {
            AICamera.nmHorizontalFOV(this.address(), value);
            return this;
        }

        public Buffer mClipPlaneNear(float value) {
            AICamera.nmClipPlaneNear(this.address(), value);
            return this;
        }

        public Buffer mClipPlaneFar(float value) {
            AICamera.nmClipPlaneFar(this.address(), value);
            return this;
        }

        public Buffer mAspect(float value) {
            AICamera.nmAspect(this.address(), value);
            return this;
        }
    }
}

