/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.assimp;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.assimp.AIString;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct aiAnimation")
public class AIAnimation
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MNAME;
    public static final int MDURATION;
    public static final int MTICKSPERSECOND;
    public static final int MNUMCHANNELS;
    public static final int MCHANNELS;
    public static final int MNUMMESHCHANNELS;
    public static final int MMESHCHANNELS;

    AIAnimation(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public AIAnimation(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), AIAnimation.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="struct aiString")
    public AIString mName() {
        return AIAnimation.nmName(this.address());
    }

    public AIAnimation mName(Consumer<AIString> consumer) {
        consumer.accept(this.mName());
        return this;
    }

    public double mDuration() {
        return AIAnimation.nmDuration(this.address());
    }

    public double mTicksPerSecond() {
        return AIAnimation.nmTicksPerSecond(this.address());
    }

    @NativeType(value="unsigned int")
    public int mNumChannels() {
        return AIAnimation.nmNumChannels(this.address());
    }

    @NativeType(value="struct aiNodeAnim **")
    public PointerBuffer mChannels() {
        return AIAnimation.nmChannels(this.address());
    }

    @NativeType(value="unsigned int")
    public int mNumMeshChannels() {
        return AIAnimation.nmNumMeshChannels(this.address());
    }

    @NativeType(value="struct aiMeshAnim **")
    public PointerBuffer mMeshChannels() {
        return AIAnimation.nmMeshChannels(this.address());
    }

    public AIAnimation mName(@NativeType(value="struct aiString") AIString value) {
        AIAnimation.nmName(this.address(), value);
        return this;
    }

    public AIAnimation mDuration(double value) {
        AIAnimation.nmDuration(this.address(), value);
        return this;
    }

    public AIAnimation mTicksPerSecond(double value) {
        AIAnimation.nmTicksPerSecond(this.address(), value);
        return this;
    }

    public AIAnimation mChannels(@NativeType(value="struct aiNodeAnim **") PointerBuffer value) {
        AIAnimation.nmChannels(this.address(), value);
        return this;
    }

    public AIAnimation mMeshChannels(@NativeType(value="struct aiMeshAnim **") PointerBuffer value) {
        AIAnimation.nmMeshChannels(this.address(), value);
        return this;
    }

    public AIAnimation set(AIString mName, double mDuration, double mTicksPerSecond, PointerBuffer mChannels, PointerBuffer mMeshChannels) {
        this.mName(mName);
        this.mDuration(mDuration);
        this.mTicksPerSecond(mTicksPerSecond);
        this.mChannels(mChannels);
        this.mMeshChannels(mMeshChannels);
        return this;
    }

    public AIAnimation set(AIAnimation src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static AIAnimation malloc() {
        return AIAnimation.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static AIAnimation calloc() {
        return AIAnimation.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static AIAnimation create() {
        return new AIAnimation(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static AIAnimation create(long address) {
        return new AIAnimation(address, null);
    }

    @Nullable
    public static AIAnimation createSafe(long address) {
        return address == 0L ? null : AIAnimation.create(address);
    }

    public static Buffer malloc(int capacity) {
        return AIAnimation.create(AIAnimation.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return AIAnimation.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(AIAnimation.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : AIAnimation.create(address, capacity);
    }

    public static AIAnimation mallocStack() {
        return AIAnimation.mallocStack(MemoryStack.stackGet());
    }

    public static AIAnimation callocStack() {
        return AIAnimation.callocStack(MemoryStack.stackGet());
    }

    public static AIAnimation mallocStack(MemoryStack stack) {
        return AIAnimation.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static AIAnimation callocStack(MemoryStack stack) {
        return AIAnimation.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return AIAnimation.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return AIAnimation.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return AIAnimation.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return AIAnimation.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static AIString nmName(long struct) {
        return AIString.create(struct + (long)MNAME);
    }

    public static double nmDuration(long struct) {
        return MemoryUtil.memGetDouble(struct + (long)MDURATION);
    }

    public static double nmTicksPerSecond(long struct) {
        return MemoryUtil.memGetDouble(struct + (long)MTICKSPERSECOND);
    }

    public static int nmNumChannels(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MNUMCHANNELS);
    }

    public static PointerBuffer nmChannels(long struct) {
        return MemoryUtil.memPointerBuffer(MemoryUtil.memGetAddress(struct + (long)MCHANNELS), AIAnimation.nmNumChannels(struct));
    }

    public static int nmNumMeshChannels(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MNUMMESHCHANNELS);
    }

    public static PointerBuffer nmMeshChannels(long struct) {
        return MemoryUtil.memPointerBuffer(MemoryUtil.memGetAddress(struct + (long)MMESHCHANNELS), AIAnimation.nmNumMeshChannels(struct));
    }

    public static void nmName(long struct, AIString value) {
        MemoryUtil.memCopy(value.address(), struct + (long)MNAME, AIString.SIZEOF);
    }

    public static void nmDuration(long struct, double value) {
        MemoryUtil.memPutDouble(struct + (long)MDURATION, value);
    }

    public static void nmTicksPerSecond(long struct, double value) {
        MemoryUtil.memPutDouble(struct + (long)MTICKSPERSECOND, value);
    }

    public static void nmNumChannels(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)MNUMCHANNELS, value);
    }

    public static void nmChannels(long struct, PointerBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)MCHANNELS, MemoryUtil.memAddress(value));
        AIAnimation.nmNumChannels(struct, value.remaining());
    }

    public static void nmNumMeshChannels(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)MNUMMESHCHANNELS, value);
    }

    public static void nmMeshChannels(long struct, PointerBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)MMESHCHANNELS, MemoryUtil.memAddress(value));
        AIAnimation.nmNumMeshChannels(struct, value.remaining());
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)MCHANNELS));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)MMESHCHANNELS));
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            AIAnimation.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = AIAnimation.__struct(AIAnimation.__member(AIString.SIZEOF, AIString.ALIGNOF), AIAnimation.__member(8), AIAnimation.__member(8), AIAnimation.__member(4), AIAnimation.__member(POINTER_SIZE), AIAnimation.__member(4), AIAnimation.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MNAME = layout.offsetof(0);
        MDURATION = layout.offsetof(1);
        MTICKSPERSECOND = layout.offsetof(2);
        MNUMCHANNELS = layout.offsetof(3);
        MCHANNELS = layout.offsetof(4);
        MNUMMESHCHANNELS = layout.offsetof(5);
        MMESHCHANNELS = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<AIAnimation, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected AIAnimation newInstance(long address) {
            return new AIAnimation(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="struct aiString")
        public AIString mName() {
            return AIAnimation.nmName(this.address());
        }

        public Buffer mName(Consumer<AIString> consumer) {
            consumer.accept(this.mName());
            return this;
        }

        public double mDuration() {
            return AIAnimation.nmDuration(this.address());
        }

        public double mTicksPerSecond() {
            return AIAnimation.nmTicksPerSecond(this.address());
        }

        @NativeType(value="unsigned int")
        public int mNumChannels() {
            return AIAnimation.nmNumChannels(this.address());
        }

        @NativeType(value="struct aiNodeAnim **")
        public PointerBuffer mChannels() {
            return AIAnimation.nmChannels(this.address());
        }

        @NativeType(value="unsigned int")
        public int mNumMeshChannels() {
            return AIAnimation.nmNumMeshChannels(this.address());
        }

        @NativeType(value="struct aiMeshAnim **")
        public PointerBuffer mMeshChannels() {
            return AIAnimation.nmMeshChannels(this.address());
        }

        public Buffer mName(@NativeType(value="struct aiString") AIString value) {
            AIAnimation.nmName(this.address(), value);
            return this;
        }

        public Buffer mDuration(double value) {
            AIAnimation.nmDuration(this.address(), value);
            return this;
        }

        public Buffer mTicksPerSecond(double value) {
            AIAnimation.nmTicksPerSecond(this.address(), value);
            return this;
        }

        public Buffer mChannels(@NativeType(value="struct aiNodeAnim **") PointerBuffer value) {
            AIAnimation.nmChannels(this.address(), value);
            return this;
        }

        public Buffer mMeshChannels(@NativeType(value="struct aiMeshAnim **") PointerBuffer value) {
            AIAnimation.nmMeshChannels(this.address(), value);
            return this;
        }
    }
}

